/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.List;
import com.mojang.serialization.Dynamic;
import java.util.Optional;
import net.minecraft.util.Mth;
import net.minecraft.util.datafix.fixes.References;

public class VillagerRebuildLevelAndXpFix
extends DataFix {
    private static final int TRADES_PER_LEVEL = 2;
    private static final int[] LEVEL_XP_THRESHOLDS = new int[]{0, 10, 50, 100, 150};

    public static int getMinXpPerLevel(int level) {
        return LEVEL_XP_THRESHOLDS[Mth.clamp(level - 1, 0, LEVEL_XP_THRESHOLDS.length - 1)];
    }

    public VillagerRebuildLevelAndXpFix(Schema outputSchema, boolean changesType) {
        super(outputSchema, changesType);
    }

    public TypeRewriteRule makeRule() {
        Type choiceType = this.getInputSchema().getChoiceType(References.ENTITY, "minecraft:villager");
        OpticFinder opticFinder = DSL.namedChoice((String)"minecraft:villager", (Type)choiceType);
        OpticFinder opticFinder1 = choiceType.findField("Offers");
        Type type = opticFinder1.type();
        OpticFinder opticFinder2 = type.findField("Recipes");
        List.ListType listType = (List.ListType)opticFinder2.type();
        OpticFinder opticFinder3 = listType.getElement().finder();
        return this.fixTypeEverywhereTyped("Villager level and xp rebuild", this.getInputSchema().getType(References.ENTITY), typed -> typed.updateTyped(opticFinder, choiceType, typed1 -> {
            Optional optional;
            int i;
            Dynamic dynamic = (Dynamic)((Object)((Object)((Object)typed1.get(DSL.remainderFinder()))));
            int _int = dynamic.get("VillagerData").get("level").asInt(0);
            Typed<?> typed2 = typed1;
            if ((_int == 0 || _int == 1) && (_int = Mth.clamp((i = typed1.getOptionalTyped(opticFinder1).flatMap(typed3 -> typed3.getOptionalTyped(opticFinder2)).map(typed3 -> typed3.getAllTyped(opticFinder3).size()).orElse(0).intValue()) / 2, 1, 5)) > 1) {
                typed2 = VillagerRebuildLevelAndXpFix.addLevel(typed1, _int);
            }
            if ((optional = dynamic.get("Xp").asNumber().result()).isEmpty()) {
                typed2 = VillagerRebuildLevelAndXpFix.addXpFromLevel(typed2, _int);
            }
            return typed2;
        }));
    }

    private static Typed<?> addLevel(Typed<?> typed, int level) {
        return typed.update(DSL.remainderFinder(), dynamic -> dynamic.update("VillagerData", dynamic1 -> dynamic1.set("level", dynamic1.createInt(level))));
    }

    private static Typed<?> addXpFromLevel(Typed<?> typed, int xp) {
        int minXpPerLevel = VillagerRebuildLevelAndXpFix.getMinXpPerLevel(xp);
        return typed.update(DSL.remainderFinder(), dynamic -> dynamic.set("Xp", dynamic.createInt(minXpPerLevel)));
    }
}

