/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling.jfr.stats;

import com.google.common.base.MoreObjects;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import jdk.jfr.consumer.RecordedEvent;
import jdk.jfr.consumer.RecordedThread;

public record ThreadAllocationStat(Instant timestamp, String threadName, long totalBytes) {
    private static final String UNKNOWN_THREAD = "unknown";

    public static ThreadAllocationStat from(RecordedEvent event) {
        RecordedThread thread = event.getThread("thread");
        String string = thread == null ? UNKNOWN_THREAD : (String)MoreObjects.firstNonNull((Object)thread.getJavaName(), (Object)UNKNOWN_THREAD);
        return new ThreadAllocationStat(event.getStartTime(), string, event.getLong("allocated"));
    }

    public static Summary summary(List<ThreadAllocationStat> stats) {
        TreeMap<String, Double> map = new TreeMap<String, Double>();
        Map<String, List<ThreadAllocationStat>> map1 = stats.stream().collect(Collectors.groupingBy(threadAllocationStat -> threadAllocationStat.threadName));
        map1.forEach((string, list) -> {
            if (list.size() >= 2) {
                ThreadAllocationStat threadAllocationStat = (ThreadAllocationStat)list.get(0);
                ThreadAllocationStat threadAllocationStat1 = (ThreadAllocationStat)list.get(list.size() - 1);
                long seconds = Duration.between(threadAllocationStat.timestamp, threadAllocationStat1.timestamp).getSeconds();
                long l = threadAllocationStat1.totalBytes - threadAllocationStat.totalBytes;
                map.put((String)string, (double)l / (double)seconds);
            }
        });
        return new Summary(map);
    }

    public record Summary(Map<String, Double> allocationsPerSecondByThread) {
    }
}

