/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.damagesource;

import io.papermc.paper.adventure.PaperAdventure;
import javax.annotation.Nullable;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageScaling;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.event.entity.EntityDamageEvent;
import org.purpurmc.purpur.PurpurConfig;

public class DamageSource {
    private final Holder<DamageType> type;
    @Nullable
    private final Entity causingEntity;
    @Nullable
    private final Entity directEntity;
    @Nullable
    private final Vec3 damageSourcePosition;
    @Nullable
    private EntityDamageEvent.DamageCause knownCause;
    @Nullable
    private Entity eventEntityDamager = null;
    @Nullable
    private Block eventBlockDamager;
    @Nullable
    private BlockState fromBlockSnapshot;
    private boolean critical;
    private boolean scissors = false;
    private boolean stonecutter = false;

    public DamageSource knownCause(EntityDamageEvent.DamageCause cause) {
        DamageSource damageSource = this.copy();
        damageSource.knownCause = cause;
        return damageSource;
    }

    @Nullable
    public EntityDamageEvent.DamageCause knownCause() {
        return this.knownCause;
    }

    public DamageSource scissors() {
        this.knownCause(EntityDamageEvent.DamageCause.SUICIDE);
        this.scissors = true;
        return this;
    }

    public boolean isScissors() {
        return this.scissors;
    }

    public DamageSource stonecutter() {
        this.knownCause(EntityDamageEvent.DamageCause.CONTACT);
        this.stonecutter = true;
        return this;
    }

    public boolean isStonecutter() {
        return this.stonecutter;
    }

    @Nullable
    public Entity eventEntityDamager() {
        return this.eventEntityDamager;
    }

    public DamageSource eventEntityDamager(Entity entity) {
        if (this.directEntity != null) {
            throw new IllegalStateException("Cannot set an event damager when a direct entity is already set (report a bug to Paper)");
        }
        DamageSource damageSource = this.copy();
        damageSource.eventEntityDamager = entity;
        return damageSource;
    }

    @Nullable
    public Block eventBlockDamager() {
        return this.eventBlockDamager;
    }

    public DamageSource eventBlockDamager(LevelAccessor level, @Nullable BlockPos pos) {
        if (pos == null) {
            return this;
        }
        DamageSource damageSource = this.copy();
        damageSource.eventBlockDamager = CraftBlock.at(level, pos);
        return damageSource;
    }

    @Nullable
    public BlockState causingBlockSnapshot() {
        return this.fromBlockSnapshot;
    }

    public DamageSource causingBlockSnapshot(BlockState blockState) {
        if (this.eventBlockDamager != null) {
            throw new IllegalStateException("Cannot set a block snapshot when an event block damager is already set (report a bug to Paper)");
        }
        DamageSource damageSource = this.copy();
        damageSource.fromBlockSnapshot = blockState;
        return damageSource;
    }

    public boolean isCritical() {
        return this.critical;
    }

    public DamageSource critical() {
        DamageSource damageSource = this.copy();
        damageSource.critical = true;
        return damageSource;
    }

    private DamageSource copy() {
        DamageSource damageSource = new DamageSource(this.type, this.directEntity, this.causingEntity, this.damageSourcePosition);
        damageSource.knownCause = this.knownCause;
        damageSource.eventEntityDamager = this.eventEntityDamager;
        damageSource.eventBlockDamager = this.eventBlockDamager;
        damageSource.fromBlockSnapshot = this.fromBlockSnapshot;
        damageSource.critical = this.critical;
        damageSource.scissors = this.isScissors();
        damageSource.stonecutter = this.isStonecutter();
        return damageSource;
    }

    public String toString() {
        return "DamageSource (" + this.type().msgId() + ")";
    }

    public float getFoodExhaustion() {
        return this.type().exhaustion();
    }

    public boolean isDirect() {
        return this.causingEntity == this.directEntity;
    }

    public DamageSource(Holder<DamageType> type, @Nullable Entity directEntity, @Nullable Entity causingEntity, @Nullable Vec3 damageSourcePosition) {
        this.type = type;
        this.causingEntity = causingEntity;
        this.directEntity = directEntity;
        this.damageSourcePosition = damageSourcePosition;
    }

    public DamageSource(Holder<DamageType> type, @Nullable Entity directEntity, @Nullable Entity causingEntity) {
        this(type, directEntity, causingEntity, null);
    }

    public DamageSource(Holder<DamageType> type, Vec3 damageSourcePosition) {
        this(type, null, null, damageSourcePosition);
    }

    public DamageSource(Holder<DamageType> type, @Nullable Entity entity) {
        this(type, entity, entity);
    }

    public DamageSource(Holder<DamageType> type) {
        this(type, null, null, null);
    }

    @Nullable
    public Entity getDirectEntity() {
        return this.directEntity;
    }

    @Nullable
    public Entity getEntity() {
        return this.causingEntity;
    }

    @Nullable
    public ItemStack getWeaponItem() {
        return this.directEntity != null ? this.directEntity.getWeaponItem() : null;
    }

    public Component getLocalizedDeathMessage(LivingEntity livingEntity) {
        ItemStack itemStack;
        String string = "death.attack." + this.type().msgId();
        if (this.causingEntity == null && this.directEntity == null) {
            LivingEntity killCredit = livingEntity.getKillCredit();
            String string1 = string + ".player";
            return killCredit != null ? Component.translatable(string1, livingEntity.getDisplayName(), killCredit.getDisplayName()) : Component.translatable(string, livingEntity.getDisplayName());
        }
        Component component = this.causingEntity == null ? this.directEntity.getDisplayName() : this.causingEntity.getDisplayName();
        Entity entity = this.causingEntity;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity1 = (LivingEntity)entity;
            itemStack = livingEntity1.getMainHandItem();
        } else {
            itemStack = ItemStack.EMPTY;
        }
        ItemStack itemStack2 = itemStack;
        return !itemStack2.isEmpty() && (PurpurConfig.playerDeathsAlwaysShowItem || itemStack2.has(DataComponents.CUSTOM_NAME)) ? Component.translatable(string + ".item", livingEntity.getDisplayName(), component, itemStack2.getDisplayName()) : Component.translatable(string, livingEntity.getDisplayName(), component);
    }

    public Component getLocalizedDeathMessage(String str, LivingEntity entity) {
        net.kyori.adventure.text.Component name = PaperAdventure.asAdventure(entity.getDisplayName());
        TagResolver.Single template = Placeholder.component((String)"player", (ComponentLike)name);
        net.kyori.adventure.text.Component component = MiniMessage.miniMessage().deserialize(str, (TagResolver)template);
        return PaperAdventure.asVanilla(component);
    }

    public String getMsgId() {
        return this.type().msgId();
    }

    public boolean scalesWithDifficulty() {
        return switch (this.type().scaling()) {
            default -> throw new MatchException(null, null);
            case DamageScaling.NEVER -> false;
            case DamageScaling.WHEN_CAUSED_BY_LIVING_NON_PLAYER -> {
                if (this.causingEntity instanceof LivingEntity && !(this.causingEntity instanceof Player)) {
                    yield true;
                }
                yield false;
            }
            case DamageScaling.ALWAYS -> true;
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isCreativePlayer() {
        Entity entity = this.getEntity();
        if (!(entity instanceof Player)) return false;
        Player player = (Player)entity;
        if (!player.getAbilities().instabuild) return false;
        return true;
    }

    @Nullable
    public Vec3 getSourcePosition() {
        if (this.damageSourcePosition != null) {
            return this.damageSourcePosition;
        }
        return this.directEntity != null ? this.directEntity.position() : null;
    }

    @Nullable
    public Vec3 sourcePositionRaw() {
        return this.damageSourcePosition;
    }

    public boolean is(TagKey<DamageType> damageTypeKey) {
        return this.type.is(damageTypeKey);
    }

    public boolean is(ResourceKey<DamageType> damageTypeKey) {
        return this.type.is(damageTypeKey);
    }

    public DamageType type() {
        return this.type.value();
    }

    public Holder<DamageType> typeHolder() {
        return this.type;
    }
}

