/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.memory.ExpirableValue;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import org.apache.commons.lang3.mutable.MutableObject;
import org.slf4j.Logger;

public class Brain<E extends LivingEntity> {
    static final Logger LOGGER = LogUtils.getLogger();
    private final Supplier<Codec<Brain<E>>> codec;
    private static final int SCHEDULE_UPDATE_DELAY = 20;
    private final Map<MemoryModuleType<?>, Optional<? extends ExpirableValue<?>>> memories = Maps.newHashMap();
    private final Map<SensorType<? extends Sensor<? super E>>, Sensor<? super E>> sensors = Maps.newLinkedHashMap();
    private final Map<Integer, Map<Activity, Set<BehaviorControl<? super E>>>> availableBehaviorsByPriority = Maps.newTreeMap();
    private Schedule schedule = Schedule.EMPTY;
    private final Map<Activity, Set<Pair<MemoryModuleType<?>, MemoryStatus>>> activityRequirements = Maps.newHashMap();
    private final Map<Activity, Set<MemoryModuleType<?>>> activityMemoriesToEraseWhenStopped = Maps.newHashMap();
    private Set<Activity> coreActivities = Sets.newHashSet();
    private final Set<Activity> activeActivities = Sets.newHashSet();
    private Activity defaultActivity = Activity.IDLE;
    private long lastScheduleUpdate = -9999L;

    public static <E extends LivingEntity> Provider<E> provider(Collection<? extends MemoryModuleType<?>> memoryTypes, Collection<? extends SensorType<? extends Sensor<? super E>>> sensorTypes) {
        return new Provider(memoryTypes, sensorTypes);
    }

    public static <E extends LivingEntity> Codec<Brain<E>> codec(final Collection<? extends MemoryModuleType<?>> memoryTypes, final Collection<? extends SensorType<? extends Sensor<? super E>>> sensorTypes) {
        final MutableObject mutableObject = new MutableObject();
        mutableObject.setValue((Object)new MapCodec<Brain<E>>(){

            public <T> Stream<T> keys(DynamicOps<T> ops) {
                return memoryTypes.stream().flatMap(memoryModuleType -> memoryModuleType.getCodec().map(codec -> BuiltInRegistries.MEMORY_MODULE_TYPE.getKey((MemoryModuleType<?>)memoryModuleType)).stream()).map(resourceLocation -> ops.createString(resourceLocation.toString()));
            }

            public <T> DataResult<Brain<E>> decode(DynamicOps<T> ops, MapLike<T> input) {
                MutableObject mutableObject1 = new MutableObject((Object)DataResult.success((Object)ImmutableList.builder()));
                input.entries().forEach(pair -> {
                    DataResult dataResult = BuiltInRegistries.MEMORY_MODULE_TYPE.byNameCodec().parse(ops, pair.getFirst());
                    DataResult dataResult1 = dataResult.flatMap(memoryModuleType -> this.captureRead((MemoryModuleType)memoryModuleType, ops, (Object)pair.getSecond()));
                    mutableObject1.setValue((Object)((DataResult)mutableObject1.getValue()).apply2(ImmutableList.Builder::add, dataResult1));
                });
                ImmutableList list = ((DataResult)mutableObject1.getValue()).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).map(ImmutableList.Builder::build).orElseGet(ImmutableList::of);
                return DataResult.success(new Brain(memoryTypes, sensorTypes, list, () -> ((MutableObject)mutableObject).getValue()));
            }

            private <T, U> DataResult<MemoryValue<U>> captureRead(MemoryModuleType<U> memoryModuleType, DynamicOps<T> dynamicOps, T object) {
                return memoryModuleType.getCodec().map(DataResult::success).orElseGet(() -> DataResult.error(() -> "No codec for memory: " + String.valueOf(memoryModuleType))).flatMap(codec -> codec.parse(dynamicOps, object)).map(expirableValue -> new MemoryValue(memoryModuleType, Optional.of(expirableValue)));
            }

            public <T> RecordBuilder<T> encode(Brain<E> input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
                input.memories().forEach(memoryValue -> memoryValue.serialize(ops, prefix));
                return prefix;
            }
        }.fieldOf("memories").codec());
        return (Codec)mutableObject.getValue();
    }

    public Brain(Collection<? extends MemoryModuleType<?>> memoryModuleTypes, Collection<? extends SensorType<? extends Sensor<? super E>>> sensorTypes, ImmutableList<MemoryValue<?>> memoryValues, Supplier<Codec<Brain<E>>> codec) {
        this.codec = codec;
        for (MemoryModuleType<?> memoryModuleType : memoryModuleTypes) {
            this.memories.put(memoryModuleType, Optional.empty());
        }
        for (SensorType sensorType : sensorTypes) {
            this.sensors.put(sensorType, (Sensor<E>)sensorType.create());
        }
        for (Sensor sensor : this.sensors.values()) {
            for (MemoryModuleType<?> memoryModuleType1 : sensor.requires()) {
                this.memories.put(memoryModuleType1, Optional.empty());
            }
        }
        for (MemoryValue memoryValue : memoryValues) {
            memoryValue.setMemoryInternal(this);
        }
    }

    public <T> DataResult<T> serializeStart(DynamicOps<T> ops) {
        return this.codec.get().encodeStart(ops, (Object)this);
    }

    Stream<MemoryValue<?>> memories() {
        return this.memories.entrySet().stream().map(memory -> MemoryValue.createUnchecked((MemoryModuleType)memory.getKey(), (Optional)memory.getValue()));
    }

    public boolean hasMemoryValue(MemoryModuleType<?> type) {
        return this.checkMemory(type, MemoryStatus.VALUE_PRESENT);
    }

    public void clearMemories() {
        this.memories.keySet().forEach(memoryModuleType -> this.memories.put((MemoryModuleType<?>)memoryModuleType, Optional.empty()));
    }

    public <U> void eraseMemory(MemoryModuleType<U> type) {
        this.setMemory(type, Optional.empty());
    }

    public <U> void setMemory(MemoryModuleType<U> memoryType, @Nullable U memory) {
        this.setMemory(memoryType, Optional.ofNullable(memory));
    }

    public <U> void setMemoryWithExpiry(MemoryModuleType<U> memoryType, U memory, long timeToLive) {
        this.setMemoryInternal(memoryType, Optional.of(ExpirableValue.of(memory, timeToLive)));
    }

    public <U> void setMemory(MemoryModuleType<U> memoryType, Optional<? extends U> memory) {
        this.setMemoryInternal(memoryType, memory.map(ExpirableValue::of));
    }

    <U> void setMemoryInternal(MemoryModuleType<U> memoryType, Optional<? extends ExpirableValue<?>> memory) {
        if (this.memories.containsKey(memoryType)) {
            if (memory.isPresent() && this.isEmptyCollection(memory.get().getValue())) {
                this.eraseMemory(memoryType);
            } else {
                this.memories.put(memoryType, memory);
            }
        }
    }

    public <U> Optional<U> getMemory(MemoryModuleType<U> type) {
        Optional<ExpirableValue<?>> optional = this.memories.get(type);
        if (optional == null) {
            throw new IllegalStateException("Unregistered memory fetched: " + String.valueOf(type));
        }
        return optional.map(ExpirableValue::getValue);
    }

    @Nullable
    public <U> Optional<U> getMemoryInternal(MemoryModuleType<U> type) {
        Optional<ExpirableValue<?>> optional = this.memories.get(type);
        return optional == null ? null : optional.map(ExpirableValue::getValue);
    }

    public <U> long getTimeUntilExpiry(MemoryModuleType<U> memoryType) {
        Optional<ExpirableValue<?>> optional = this.memories.get(memoryType);
        return optional.map(ExpirableValue::getTimeToLive).orElse(0L);
    }

    @Deprecated
    @VisibleForDebug
    public Map<MemoryModuleType<?>, Optional<? extends ExpirableValue<?>>> getMemories() {
        return this.memories;
    }

    public <U> boolean isMemoryValue(MemoryModuleType<U> memoryType, U memory) {
        return this.hasMemoryValue(memoryType) && this.getMemory(memoryType).filter(object -> object.equals(memory)).isPresent();
    }

    public boolean checkMemory(MemoryModuleType<?> memoryType, MemoryStatus memoryStatus) {
        Optional<ExpirableValue<?>> optional = this.memories.get(memoryType);
        return optional != null && (memoryStatus == MemoryStatus.REGISTERED || memoryStatus == MemoryStatus.VALUE_PRESENT && optional.isPresent() || memoryStatus == MemoryStatus.VALUE_ABSENT && optional.isEmpty());
    }

    public Schedule getSchedule() {
        return this.schedule;
    }

    public void setSchedule(Schedule newSchedule) {
        this.schedule = newSchedule;
    }

    public void setCoreActivities(Set<Activity> newActivities) {
        this.coreActivities = newActivities;
    }

    @Deprecated
    @VisibleForDebug
    public Set<Activity> getActiveActivities() {
        return this.activeActivities;
    }

    @Deprecated
    @VisibleForDebug
    public List<BehaviorControl<? super E>> getRunningBehaviors() {
        ObjectArrayList list = new ObjectArrayList();
        for (Map<Activity, Set<BehaviorControl<E>>> map : this.availableBehaviorsByPriority.values()) {
            for (Set<BehaviorControl<E>> set : map.values()) {
                for (BehaviorControl<E> behaviorControl : set) {
                    if (behaviorControl.getStatus() != Behavior.Status.RUNNING) continue;
                    list.add(behaviorControl);
                }
            }
        }
        return list;
    }

    public void useDefaultActivity() {
        this.setActiveActivity(this.defaultActivity);
    }

    public Optional<Activity> getActiveNonCoreActivity() {
        for (Activity activity : this.activeActivities) {
            if (this.coreActivities.contains(activity)) continue;
            return Optional.of(activity);
        }
        return Optional.empty();
    }

    public void setActiveActivityIfPossible(Activity activity) {
        if (this.activityRequirementsAreMet(activity)) {
            this.setActiveActivity(activity);
        } else {
            this.useDefaultActivity();
        }
    }

    private void setActiveActivity(Activity activity) {
        if (!this.isActive(activity)) {
            this.eraseMemoriesForOtherActivitesThan(activity);
            this.activeActivities.clear();
            this.activeActivities.addAll(this.coreActivities);
            this.activeActivities.add(activity);
        }
    }

    private void eraseMemoriesForOtherActivitesThan(Activity activity) {
        for (Activity activity1 : this.activeActivities) {
            Set<MemoryModuleType<?>> set;
            if (activity1 == activity || (set = this.activityMemoriesToEraseWhenStopped.get(activity1)) == null) continue;
            for (MemoryModuleType<?> memoryModuleType : set) {
                this.eraseMemory(memoryModuleType);
            }
        }
    }

    public void updateActivityFromSchedule(long dayTime, long gameTime) {
        if (gameTime - this.lastScheduleUpdate > 20L) {
            this.lastScheduleUpdate = gameTime;
            Activity activityAt = this.getSchedule().getActivityAt((int)(dayTime % 24000L));
            if (!this.activeActivities.contains(activityAt)) {
                this.setActiveActivityIfPossible(activityAt);
            }
        }
    }

    public void setActiveActivityToFirstValid(List<Activity> activities) {
        for (Activity activity : activities) {
            if (!this.activityRequirementsAreMet(activity)) continue;
            this.setActiveActivity(activity);
            break;
        }
    }

    public void setDefaultActivity(Activity newFallbackActivity) {
        this.defaultActivity = newFallbackActivity;
    }

    public void addActivity(Activity activity, int priorityStart, ImmutableList<? extends BehaviorControl<? super E>> tasks) {
        this.addActivity(activity, this.createPriorityPairs(priorityStart, tasks));
    }

    public void addActivityAndRemoveMemoryWhenStopped(Activity activity, int priorityStart, ImmutableList<? extends BehaviorControl<? super E>> tasks, MemoryModuleType<?> memoryType) {
        ImmutableSet set = ImmutableSet.of((Object)Pair.of(memoryType, (Object)((Object)MemoryStatus.VALUE_PRESENT)));
        ImmutableSet set1 = ImmutableSet.of(memoryType);
        this.addActivityAndRemoveMemoriesWhenStopped(activity, (ImmutableList<? extends Pair<Integer, ? extends BehaviorControl<? super E>>>)this.createPriorityPairs(priorityStart, tasks), (Set<Pair<MemoryModuleType<?>, MemoryStatus>>)set, (Set<MemoryModuleType<?>>)set1);
    }

    public void addActivity(Activity activity, ImmutableList<? extends Pair<Integer, ? extends BehaviorControl<? super E>>> tasks) {
        this.addActivityAndRemoveMemoriesWhenStopped(activity, tasks, (Set<Pair<MemoryModuleType<?>, MemoryStatus>>)ImmutableSet.of(), Sets.newHashSet());
    }

    public void addActivityWithConditions(Activity activity, int priorityStart, ImmutableList<? extends BehaviorControl<? super E>> tasks, Set<Pair<MemoryModuleType<?>, MemoryStatus>> memoryStatuses) {
        this.addActivityWithConditions(activity, this.createPriorityPairs(priorityStart, tasks), memoryStatuses);
    }

    public void addActivityWithConditions(Activity activity, ImmutableList<? extends Pair<Integer, ? extends BehaviorControl<? super E>>> tasks, Set<Pair<MemoryModuleType<?>, MemoryStatus>> memoryStatuses) {
        this.addActivityAndRemoveMemoriesWhenStopped(activity, tasks, memoryStatuses, Sets.newHashSet());
    }

    public void addActivityAndRemoveMemoriesWhenStopped(Activity activity, ImmutableList<? extends Pair<Integer, ? extends BehaviorControl<? super E>>> tasks, Set<Pair<MemoryModuleType<?>, MemoryStatus>> memoryStatuses, Set<MemoryModuleType<?>> memoryTypes) {
        this.activityRequirements.put(activity, memoryStatuses);
        if (!memoryTypes.isEmpty()) {
            this.activityMemoriesToEraseWhenStopped.put(activity, memoryTypes);
        }
        for (Pair pair : tasks) {
            this.availableBehaviorsByPriority.computeIfAbsent((Integer)pair.getFirst(), integer -> Maps.newHashMap()).computeIfAbsent(activity, activity1 -> Sets.newLinkedHashSet()).add((BehaviorControl)pair.getSecond());
        }
    }

    @VisibleForTesting
    public void removeAllBehaviors() {
        this.availableBehaviorsByPriority.clear();
    }

    public boolean isActive(Activity activity) {
        return this.activeActivities.contains(activity);
    }

    public Brain<E> copyWithoutBehaviors() {
        Brain<E> brain = new Brain<E>(this.memories.keySet(), this.sensors.keySet(), ImmutableList.of(), this.codec);
        for (Map.Entry<MemoryModuleType<?>, Optional<ExpirableValue<?>>> entry : this.memories.entrySet()) {
            MemoryModuleType<?> memoryModuleType = entry.getKey();
            if (!entry.getValue().isPresent()) continue;
            brain.memories.put(memoryModuleType, entry.getValue());
        }
        return brain;
    }

    public void tick(ServerLevel level, E entity) {
        this.forgetOutdatedMemories();
        this.tickSensors(level, entity);
        this.startEachNonRunningBehavior(level, entity);
        this.tickEachRunningBehavior(level, entity);
    }

    private void tickSensors(ServerLevel level, E brainHolder) {
        for (Sensor<E> sensor : this.sensors.values()) {
            sensor.tick(level, brainHolder);
        }
    }

    private void forgetOutdatedMemories() {
        for (Map.Entry<MemoryModuleType<?>, Optional<ExpirableValue<?>>> entry : this.memories.entrySet()) {
            if (!entry.getValue().isPresent()) continue;
            ExpirableValue<?> expirableValue = entry.getValue().get();
            if (expirableValue.hasExpired()) {
                this.eraseMemory(entry.getKey());
            }
            expirableValue.tick();
        }
    }

    public void stopAll(ServerLevel level, E owner) {
        long gameTime = ((Entity)owner).level().getGameTime();
        for (BehaviorControl<E> behaviorControl : this.getRunningBehaviors()) {
            behaviorControl.doStop(level, owner, gameTime);
        }
    }

    private void startEachNonRunningBehavior(ServerLevel level, E entity) {
        long gameTime = level.getGameTime();
        for (Map<Activity, Set<BehaviorControl<E>>> map : this.availableBehaviorsByPriority.values()) {
            for (Map.Entry<Activity, Set<BehaviorControl<E>>> entry : map.entrySet()) {
                Activity activity = entry.getKey();
                if (!this.activeActivities.contains(activity)) continue;
                for (BehaviorControl<E> behaviorControl : entry.getValue()) {
                    if (behaviorControl.getStatus() != Behavior.Status.STOPPED) continue;
                    behaviorControl.tryStart(level, entity, gameTime);
                }
            }
        }
    }

    private void tickEachRunningBehavior(ServerLevel level, E entity) {
        long gameTime = level.getGameTime();
        for (BehaviorControl<E> behaviorControl : this.getRunningBehaviors()) {
            behaviorControl.tickOrStop(level, entity, gameTime);
        }
    }

    private boolean activityRequirementsAreMet(Activity activity) {
        if (!this.activityRequirements.containsKey(activity)) {
            return false;
        }
        for (Pair<MemoryModuleType<?>, MemoryStatus> pair : this.activityRequirements.get(activity)) {
            MemoryStatus memoryStatus;
            MemoryModuleType memoryModuleType = (MemoryModuleType)pair.getFirst();
            if (this.checkMemory(memoryModuleType, memoryStatus = (MemoryStatus)((Object)pair.getSecond()))) continue;
            return false;
        }
        return true;
    }

    private boolean isEmptyCollection(Object collection) {
        return collection instanceof Collection && ((Collection)collection).isEmpty();
    }

    ImmutableList<? extends Pair<Integer, ? extends BehaviorControl<? super E>>> createPriorityPairs(int priorityStart, ImmutableList<? extends BehaviorControl<? super E>> tasks) {
        int i = priorityStart;
        ImmutableList.Builder builder = ImmutableList.builder();
        for (BehaviorControl behaviorControl : tasks) {
            builder.add((Object)Pair.of((Object)i++, (Object)behaviorControl));
        }
        return builder.build();
    }

    public boolean isBrainDead() {
        return this.memories.isEmpty() && this.sensors.isEmpty() && this.availableBehaviorsByPriority.isEmpty();
    }

    public static final class Provider<E extends LivingEntity> {
        private final Collection<? extends MemoryModuleType<?>> memoryTypes;
        private final Collection<? extends SensorType<? extends Sensor<? super E>>> sensorTypes;
        private final Codec<Brain<E>> codec;

        Provider(Collection<? extends MemoryModuleType<?>> memoryTypes, Collection<? extends SensorType<? extends Sensor<? super E>>> sensorTypes) {
            this.memoryTypes = memoryTypes;
            this.sensorTypes = sensorTypes;
            this.codec = Brain.codec(memoryTypes, sensorTypes);
        }

        public Brain<E> makeBrain(Dynamic<?> ops) {
            return this.codec.parse(ops).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElseGet(() -> new Brain(this.memoryTypes, this.sensorTypes, ImmutableList.of(), () -> this.codec));
        }
    }

    static final class MemoryValue<U> {
        private final MemoryModuleType<U> type;
        private final Optional<? extends ExpirableValue<U>> value;

        static <U> MemoryValue<U> createUnchecked(MemoryModuleType<U> memoryType, Optional<? extends ExpirableValue<?>> memory) {
            return new MemoryValue<U>(memoryType, memory);
        }

        MemoryValue(MemoryModuleType<U> type, Optional<? extends ExpirableValue<U>> value) {
            this.type = type;
            this.value = value;
        }

        void setMemoryInternal(Brain<?> brain) {
            brain.setMemoryInternal(this.type, this.value);
        }

        public <T> void serialize(DynamicOps<T> ops, RecordBuilder<T> builder) {
            this.type.getCodec().ifPresent(codec -> this.value.ifPresent(expirableValue -> builder.add(BuiltInRegistries.MEMORY_MODULE_TYPE.byNameCodec().encodeStart(ops, this.type), codec.encodeStart(ops, expirableValue))));
        }
    }
}

