/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.attributes;

import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;

public class AttributeMap {
    private final Map<Holder<Attribute>, AttributeInstance> attributes = new Object2ObjectOpenHashMap();
    private final Set<AttributeInstance> attributesToSync = new ObjectOpenHashSet();
    private final Set<AttributeInstance> attributesToUpdate = new ObjectOpenHashSet();
    private final AttributeSupplier supplier;
    private final LivingEntity entity;

    public AttributeMap(AttributeSupplier supplier) {
        this(supplier, null);
    }

    public AttributeMap(AttributeSupplier defaultAttributes, LivingEntity entity) {
        this.entity = entity;
        this.supplier = defaultAttributes;
    }

    private void onAttributeModified(AttributeInstance instance) {
        this.attributesToUpdate.add(instance);
        if (instance.getAttribute().value().isClientSyncable() && (this.entity == null || this.entity.shouldSendAttribute(instance.getAttribute().value()))) {
            this.attributesToSync.add(instance);
        }
    }

    public Set<AttributeInstance> getAttributesToSync() {
        return this.attributesToSync;
    }

    public Set<AttributeInstance> getAttributesToUpdate() {
        return this.attributesToUpdate;
    }

    public Collection<AttributeInstance> getSyncableAttributes() {
        return this.attributes.values().stream().filter(instance -> instance.getAttribute().value().isClientSyncable() && (this.entity == null || this.entity.shouldSendAttribute(instance.getAttribute().value()))).collect(Collectors.toList());
    }

    @Nullable
    public AttributeInstance getInstance(Holder<Attribute> attribute) {
        return this.attributes.computeIfAbsent(attribute, holder -> this.supplier.createInstance(this::onAttributeModified, (Holder<Attribute>)holder));
    }

    public boolean hasAttribute(Holder<Attribute> attribute) {
        return this.attributes.get(attribute) != null || this.supplier.hasAttribute(attribute);
    }

    public boolean hasModifier(Holder<Attribute> attribute, ResourceLocation id) {
        AttributeInstance attributeInstance = this.attributes.get(attribute);
        return attributeInstance != null ? attributeInstance.getModifier(id) != null : this.supplier.hasModifier(attribute, id);
    }

    public double getValue(Holder<Attribute> attribute) {
        AttributeInstance attributeInstance = this.attributes.get(attribute);
        return attributeInstance != null ? attributeInstance.getValue() : this.supplier.getValue(attribute);
    }

    public double getBaseValue(Holder<Attribute> attribute) {
        AttributeInstance attributeInstance = this.attributes.get(attribute);
        return attributeInstance != null ? attributeInstance.getBaseValue() : this.supplier.getBaseValue(attribute);
    }

    public double getModifierValue(Holder<Attribute> attribute, ResourceLocation id) {
        AttributeInstance attributeInstance = this.attributes.get(attribute);
        return attributeInstance != null ? attributeInstance.getModifier(id).amount() : this.supplier.getModifierValue(attribute, id);
    }

    public void addTransientAttributeModifiers(Multimap<Holder<Attribute>, AttributeModifier> modifiers) {
        modifiers.forEach((attribute, modifier) -> {
            AttributeInstance instance = this.getInstance((Holder<Attribute>)attribute);
            if (instance != null) {
                instance.removeModifier(modifier.id());
                instance.addTransientModifier((AttributeModifier)modifier);
            }
        });
    }

    public void removeAttributeModifiers(Multimap<Holder<Attribute>, AttributeModifier> modifiers) {
        modifiers.asMap().forEach((holder, collection) -> {
            AttributeInstance attributeInstance = this.attributes.get(holder);
            if (attributeInstance != null) {
                collection.forEach(attributeModifier -> attributeInstance.removeModifier(attributeModifier.id()));
            }
        });
    }

    public void assignAllValues(AttributeMap map) {
        map.attributes.values().forEach(attribute -> {
            AttributeInstance instance = this.getInstance(attribute.getAttribute());
            if (instance != null) {
                instance.replaceFrom((AttributeInstance)attribute);
            }
        });
    }

    public void assignBaseValues(AttributeMap map) {
        map.attributes.values().forEach(attribute -> {
            AttributeInstance instance = this.getInstance(attribute.getAttribute());
            if (instance != null) {
                instance.setBaseValue(attribute.getBaseValue());
            }
        });
    }

    public void assignPermanentModifiers(AttributeMap map) {
        map.attributes.values().forEach(attribute -> {
            AttributeInstance instance = this.getInstance(attribute.getAttribute());
            if (instance != null) {
                instance.addPermanentModifiers(attribute.getPermanentModifiers());
            }
        });
    }

    public boolean resetBaseValue(Holder<Attribute> attribute) {
        if (!this.supplier.hasAttribute(attribute)) {
            return false;
        }
        AttributeInstance attributeInstance = this.attributes.get(attribute);
        if (attributeInstance != null) {
            attributeInstance.setBaseValue(this.supplier.getBaseValue(attribute));
        }
        return true;
    }

    public List<AttributeInstance.Packed> pack() {
        ArrayList<AttributeInstance.Packed> list = new ArrayList<AttributeInstance.Packed>(this.attributes.values().size());
        for (AttributeInstance attributeInstance : this.attributes.values()) {
            list.add(attributeInstance.pack());
        }
        return list;
    }

    public void apply(List<AttributeInstance.Packed> attributes) {
        for (AttributeInstance.Packed packed : attributes) {
            AttributeInstance instance = this.getInstance(packed.attribute());
            if (instance == null) continue;
            instance.apply(packed);
        }
    }

    public void registerAttribute(Holder<Attribute> attributeBase) {
        AttributeInstance attributeModifiable = new AttributeInstance(attributeBase, AttributeInstance::getAttribute);
        this.attributes.put(attributeBase, attributeModifiable);
    }
}

