/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.Applicative;
import java.util.function.Function;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import org.bukkit.craftbukkit.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;

public class BabyFollowAdult {
    public static OneShot<LivingEntity> create(UniformInt followRange, float speedModifier) {
        return BabyFollowAdult.create(followRange, entity -> Float.valueOf(speedModifier), MemoryModuleType.NEAREST_VISIBLE_ADULT, false);
    }

    public static OneShot<LivingEntity> create(UniformInt followRange, Function<LivingEntity, Float> speedModifier, MemoryModuleType<? extends LivingEntity> nearestVisibleAdult, boolean targetEyeHeight) {
        return BehaviorBuilder.create(instance -> instance.group(instance.present(nearestVisibleAdult), instance.registered(MemoryModuleType.LOOK_TARGET), instance.absent(MemoryModuleType.WALK_TARGET)).apply((Applicative)instance, (memoryAccessor, memoryAccessor1, memoryAccessor2) -> (level, entity, gameTime) -> {
            if (!entity.isBaby()) {
                return false;
            }
            LivingEntity livingEntity = (LivingEntity)instance.get(memoryAccessor);
            if (entity.closerThan(livingEntity, followRange.getMaxValue() + 1) && !entity.closerThan(livingEntity, followRange.getMinValue())) {
                EntityTargetLivingEntityEvent event = CraftEventFactory.callEntityTargetLivingEvent(entity, livingEntity, EntityTargetEvent.TargetReason.FOLLOW_LEADER);
                if (event.isCancelled()) {
                    return false;
                }
                if (event.getTarget() == null) {
                    memoryAccessor.erase();
                    return true;
                }
                livingEntity = ((CraftLivingEntity)event.getTarget()).getHandle();
                WalkTarget walkTarget = new WalkTarget(new EntityTracker(livingEntity, targetEyeHeight, targetEyeHeight), ((Float)speedModifier.apply(entity)).floatValue(), followRange.getMinValue() - 1);
                memoryAccessor1.set(new EntityTracker(livingEntity, true, targetEyeHeight));
                memoryAccessor2.set(walkTarget);
                return true;
            }
            return false;
        }));
    }
}

