/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.animal.frog.Frog;

public class Croak
extends Behavior<Frog> {
    private static final int CROAK_TICKS = 60;
    private static final int TIME_OUT_DURATION = 100;
    private int croakCounter;

    public Croak() {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT)), 100);
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel level, Frog owner) {
        return owner.getPose() == Pose.STANDING;
    }

    @Override
    protected boolean canStillUse(ServerLevel level, Frog entity, long gameTime) {
        return this.croakCounter < 60;
    }

    @Override
    protected void start(ServerLevel level, Frog entity, long gameTime) {
        if (!entity.isInLiquid()) {
            entity.setPose(Pose.CROAKING);
            this.croakCounter = 0;
        }
    }

    @Override
    protected void stop(ServerLevel level, Frog entity, long gameTime) {
        entity.setPose(Pose.STANDING);
    }

    @Override
    protected void tick(ServerLevel level, Frog owner, long gameTime) {
        ++this.croakCounter;
    }
}

