/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.Applicative;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;

public class GoToTargetLocation {
    private static BlockPos getNearbyPos(Mob mob, BlockPos pos) {
        RandomSource randomSource = mob.level().random;
        return pos.offset(GoToTargetLocation.getRandomOffset(randomSource), 0, GoToTargetLocation.getRandomOffset(randomSource));
    }

    private static int getRandomOffset(RandomSource random) {
        return random.nextInt(3) - 1;
    }

    public static <E extends Mob> OneShot<E> create(MemoryModuleType<BlockPos> locationMemory, int closeEnoughDist, float speedModifier) {
        return BehaviorBuilder.create(instance -> instance.group(instance.present(locationMemory), instance.absent(MemoryModuleType.ATTACK_TARGET), instance.absent(MemoryModuleType.WALK_TARGET), instance.registered(MemoryModuleType.LOOK_TARGET)).apply((Applicative)instance, (location, attackTarget, walkTarget, lookTarget) -> (level, mob, gameTime) -> {
            BlockPos blockPos = (BlockPos)instance.get(location);
            boolean flag = blockPos.closerThan(mob.blockPosition(), closeEnoughDist);
            if (!flag) {
                BehaviorUtils.setWalkAndLookTargetMemories(mob, GoToTargetLocation.getNearbyPos(mob, blockPos), speedModifier, closeEnoughDist);
            }
            return true;
        }));
    }
}

