/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.Applicative;
import java.util.Collections;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;

public class InsideBrownianWalk {
    public static BehaviorControl<PathfinderMob> create(float speedModifier) {
        return BehaviorBuilder.create(instance -> instance.group(instance.absent(MemoryModuleType.WALK_TARGET)).apply((Applicative)instance, walkTarget -> (level, mob, gameTime) -> {
            if (level.canSeeSky(mob.blockPosition())) {
                return false;
            }
            BlockPos blockPos = mob.blockPosition();
            List list = BlockPos.betweenClosedStream(blockPos.offset(-1, -1, -1), blockPos.offset(1, 1, 1)).map(BlockPos::immutable).collect(Util.toMutableList());
            Collections.shuffle(list);
            list.stream().filter(pos -> !level.canSeeSky((BlockPos)pos)).filter(pos -> level.loadedAndEntityCanStandOn((BlockPos)pos, mob)).filter(pos -> level.noCollision(mob)).findFirst().ifPresent(pos -> walkTarget.set(new WalkTarget((BlockPos)pos, speedModifier, 0)));
            return true;
        }));
    }
}

