/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.kinds.OptionalBox;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.behavior.declarative.MemoryAccessor;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableObject;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.entity.Entity;
import org.bukkit.event.entity.EntityInteractEvent;

public class InteractWithDoor {
    private static final int COOLDOWN_BEFORE_RERUNNING_IN_SAME_NODE = 20;
    private static final double SKIP_CLOSING_DOOR_IF_FURTHER_AWAY_THAN = 3.0;
    private static final double MAX_DISTANCE_TO_HOLD_DOOR_OPEN_FOR_OTHER_MOBS = 2.0;

    public static BehaviorControl<LivingEntity> create() {
        MutableObject mutableObject = new MutableObject(null);
        MutableInt mutableInt = new MutableInt(0);
        return BehaviorBuilder.create(instance -> instance.group(instance.present(MemoryModuleType.PATH), instance.registered(MemoryModuleType.DOORS_TO_CLOSE), instance.registered(MemoryModuleType.NEAREST_LIVING_ENTITIES)).apply((Applicative)instance, (navigationPath, doorsToClose, nearestLivingEntities) -> (level, entity, gameTime) -> {
            Path path = (Path)instance.get(navigationPath);
            Optional<Set<GlobalPos>> optional = instance.tryGet(doorsToClose);
            if (!path.notStarted() && !path.isDone()) {
                DoorBlock doorBlock1;
                BlockPos blockPos1;
                BlockState blockState1;
                if (Objects.equals(mutableObject.getValue(), path.getNextNode())) {
                    mutableInt.setValue(20);
                } else if (mutableInt.decrementAndGet() > 0) {
                    return false;
                }
                mutableObject.setValue((Object)path.getNextNode());
                Node previousNode = path.getPreviousNode();
                Node nextNode = path.getNextNode();
                BlockPos blockPos = previousNode.asBlockPos();
                BlockState blockState = level.getBlockState(blockPos);
                if (blockState.is(BlockTags.MOB_INTERACTABLE_DOORS, state -> state.getBlock() instanceof DoorBlock) && !DoorBlock.requiresRedstone(entity.level(), blockState, blockPos)) {
                    DoorBlock doorBlock = (DoorBlock)blockState.getBlock();
                    if (!doorBlock.isOpen(blockState)) {
                        EntityInteractEvent event = new EntityInteractEvent((Entity)entity.getBukkitEntity(), (Block)CraftBlock.at(entity.level(), blockPos));
                        if (!event.callEvent()) {
                            return false;
                        }
                        doorBlock.setOpen(entity, level, blockState, blockPos, true);
                    }
                    optional = InteractWithDoor.rememberDoorToClose(doorsToClose, optional, level, blockPos);
                }
                if ((blockState1 = level.getBlockState(blockPos1 = nextNode.asBlockPos())).is(BlockTags.MOB_INTERACTABLE_DOORS, state -> state.getBlock() instanceof DoorBlock) && !DoorBlock.requiresRedstone(entity.level(), blockState1, blockPos1) && !(doorBlock1 = (DoorBlock)blockState1.getBlock()).isOpen(blockState1)) {
                    EntityInteractEvent event = new EntityInteractEvent((Entity)entity.getBukkitEntity(), (Block)CraftBlock.at(entity.level(), blockPos1));
                    if (!event.callEvent()) {
                        return false;
                    }
                    doorBlock1.setOpen(entity, level, blockState1, blockPos1, true);
                    optional = InteractWithDoor.rememberDoorToClose(doorsToClose, optional, level, blockPos1);
                }
                optional.ifPresent(doorPositions -> InteractWithDoor.closeDoorsThatIHaveOpenedOrPassedThrough(level, entity, previousNode, nextNode, doorPositions, instance.tryGet(nearestLivingEntities)));
                return true;
            }
            return false;
        }));
    }

    public static void closeDoorsThatIHaveOpenedOrPassedThrough(ServerLevel level, LivingEntity entity, @Nullable Node previous, @Nullable Node next, Set<GlobalPos> doorPositions, Optional<List<LivingEntity>> nearestLivingEntities) {
        Iterator<GlobalPos> iterator = doorPositions.iterator();
        while (iterator.hasNext()) {
            GlobalPos globalPos = iterator.next();
            BlockPos blockPos = globalPos.pos();
            if (previous != null && previous.asBlockPos().equals(blockPos) || next != null && next.asBlockPos().equals(blockPos)) continue;
            if (InteractWithDoor.isDoorTooFarAway(level, entity, globalPos)) {
                iterator.remove();
                continue;
            }
            BlockState blockState = level.getBlockState(blockPos);
            if (!blockState.is(BlockTags.MOB_INTERACTABLE_DOORS, state -> state.getBlock() instanceof DoorBlock) || DoorBlock.requiresRedstone(entity.level(), blockState, blockPos)) {
                iterator.remove();
                continue;
            }
            DoorBlock doorBlock = (DoorBlock)blockState.getBlock();
            if (!doorBlock.isOpen(blockState)) {
                iterator.remove();
                continue;
            }
            if (InteractWithDoor.areOtherMobsComingThroughDoor(entity, blockPos, nearestLivingEntities)) {
                iterator.remove();
                continue;
            }
            doorBlock.setOpen(entity, level, blockState, blockPos, false);
            iterator.remove();
        }
    }

    private static boolean areOtherMobsComingThroughDoor(LivingEntity entity, BlockPos pos, Optional<List<LivingEntity>> nearestLivingEntities) {
        return !nearestLivingEntities.isEmpty() && nearestLivingEntities.get().stream().filter(nearEntity -> nearEntity.getType() == entity.getType()).filter(nearEntity -> pos.closerToCenterThan(nearEntity.position(), 2.0)).anyMatch(nearEntity -> InteractWithDoor.isMobComingThroughDoor(nearEntity.getBrain(), pos));
    }

    private static boolean isMobComingThroughDoor(Brain<?> brain, BlockPos pos) {
        if (!brain.hasMemoryValue(MemoryModuleType.PATH)) {
            return false;
        }
        Path path = brain.getMemory(MemoryModuleType.PATH).get();
        if (path.isDone()) {
            return false;
        }
        Node previousNode = path.getPreviousNode();
        if (previousNode == null) {
            return false;
        }
        Node nextNode = path.getNextNode();
        return pos.equals(previousNode.asBlockPos()) || pos.equals(nextNode.asBlockPos());
    }

    private static boolean isDoorTooFarAway(ServerLevel level, LivingEntity entity, GlobalPos pos) {
        return pos.dimension() != level.dimension() || !pos.pos().closerToCenterThan(entity.position(), 3.0);
    }

    private static Optional<Set<GlobalPos>> rememberDoorToClose(MemoryAccessor<OptionalBox.Mu, Set<GlobalPos>> doorsToClose, Optional<Set<GlobalPos>> doorPositions, ServerLevel level, BlockPos pos) {
        GlobalPos globalPos = GlobalPos.of(level.dimension(), pos);
        return Optional.of(doorPositions.map(set -> {
            set.add(globalPos);
            return set;
        }).orElseGet(() -> {
            HashSet set = Sets.newHashSet((Object[])new GlobalPos[]{globalPos});
            doorsToClose.set(set);
            return set;
        }));
    }
}

