/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.Applicative;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;

public class StayCloseToTarget {
    public static BehaviorControl<LivingEntity> create(Function<LivingEntity, Optional<PositionTracker>> targetPositionGetter, Predicate<LivingEntity> predicate, int closeEnoughDist, int tooClose, float speedModifier) {
        return BehaviorBuilder.create(instance -> instance.group(instance.registered(MemoryModuleType.LOOK_TARGET), instance.registered(MemoryModuleType.WALK_TARGET)).apply((Applicative)instance, (lookTarget, walkTarget) -> (level, entity, gameTime) -> {
            Optional optional = (Optional)targetPositionGetter.apply(entity);
            if (!optional.isEmpty() && predicate.test(entity)) {
                PositionTracker positionTracker = (PositionTracker)optional.get();
                if (entity.position().closerThan(positionTracker.currentPosition(), tooClose)) {
                    return false;
                }
                PositionTracker positionTracker1 = (PositionTracker)optional.get();
                lookTarget.set(positionTracker1);
                walkTarget.set(new WalkTarget(positionTracker1, speedModifier, closeEnoughDist));
                return true;
            }
            return false;
        }));
    }
}

