/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.Applicative;
import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import org.bukkit.craftbukkit.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;

public class StopAttackingIfTargetInvalid {
    private static final int TIMEOUT_TO_GET_WITHIN_ATTACK_RANGE = 200;

    public static <E extends Mob> BehaviorControl<E> create(TargetErasedCallback<E> onStopAttacking) {
        return StopAttackingIfTargetInvalid.create((level, entity) -> false, onStopAttacking, true);
    }

    public static <E extends Mob> BehaviorControl<E> create(StopAttackCondition canStopAttacking) {
        return StopAttackingIfTargetInvalid.create(canStopAttacking, (level, entity, target) -> {}, true);
    }

    public static <E extends Mob> BehaviorControl<E> create() {
        return StopAttackingIfTargetInvalid.create((level, entity) -> false, (level, entity, target) -> {}, true);
    }

    public static <E extends Mob> BehaviorControl<E> create(StopAttackCondition canStopAttacking, TargetErasedCallback<E> onStopAttacking, boolean canGrowTiredOfTryingToReachTarget) {
        return BehaviorBuilder.create((BehaviorBuilder.Instance<E> instance) -> instance.group(instance.present(MemoryModuleType.ATTACK_TARGET), instance.registered(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE)).apply((Applicative)instance, (memoryAccessor, memoryAccessor1) -> (level, entity, l) -> {
            LivingEntity livingEntity = (LivingEntity)instance.get(memoryAccessor);
            if (!(!entity.canAttack(livingEntity) || canGrowTiredOfTryingToReachTarget && StopAttackingIfTargetInvalid.isTiredOfTryingToReachTarget(entity, instance.tryGet(memoryAccessor1)) || !livingEntity.isAlive() || livingEntity.level() != entity.level() || canStopAttacking.test(level, livingEntity))) {
                return true;
            }
            EntityTargetEvent.TargetReason reason = !entity.canAttack(livingEntity) ? EntityTargetEvent.TargetReason.TARGET_INVALID : (canGrowTiredOfTryingToReachTarget && StopAttackingIfTargetInvalid.isTiredOfTryingToReachTarget(entity, instance.tryGet(memoryAccessor1)) ? EntityTargetEvent.TargetReason.FORGOT_TARGET : (!livingEntity.isAlive() ? EntityTargetEvent.TargetReason.TARGET_DIED : (livingEntity.level() != entity.level() ? EntityTargetEvent.TargetReason.TARGET_OTHER_LEVEL : EntityTargetEvent.TargetReason.TARGET_INVALID)));
            EntityTargetLivingEntityEvent event = CraftEventFactory.callEntityTargetLivingEvent(entity, null, reason);
            if (event.isCancelled()) {
                return false;
            }
            if (event.getTarget() != null) {
                entity.getBrain().setMemory(MemoryModuleType.ATTACK_TARGET, ((CraftLivingEntity)event.getTarget()).getHandle());
                return true;
            }
            onStopAttacking.accept(level, entity, livingEntity);
            memoryAccessor.erase();
            return true;
        }));
    }

    private static boolean isTiredOfTryingToReachTarget(LivingEntity entity, Optional<Long> timeSinceInvalidTarget) {
        return timeSinceInvalidTarget.isPresent() && entity.level().getGameTime() - timeSinceInvalidTarget.get() > 200L;
    }

    @FunctionalInterface
    public static interface StopAttackCondition {
        public boolean test(ServerLevel var1, LivingEntity var2);
    }

    @FunctionalInterface
    public static interface TargetErasedCallback<E> {
        public void accept(ServerLevel var1, E var2, LivingEntity var3);
    }
}

