/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.function.TriConsumer;
import org.bukkit.craftbukkit.event.CraftEventFactory;

public class TransportItemsBetweenContainers
extends Behavior<PathfinderMob> {
    public static final int TARGET_INTERACTION_TIME = 60;
    private static final int VISITED_POSITIONS_MEMORY_TIME = 6000;
    private static final int TRANSPORTED_ITEM_MAX_STACK_SIZE = 16;
    private static final int MAX_VISITED_POSITIONS = 10;
    private static final int MAX_UNREACHABLE_POSITIONS = 50;
    private static final int PASSENGER_MOB_TARGET_SEARCH_DISTANCE = 1;
    private static final int IDLE_COOLDOWN = 140;
    private static final double CLOSE_ENOUGH_TO_START_QUEUING_DISTANCE = 3.0;
    private static final double CLOSE_ENOUGH_TO_START_INTERACTING_WITH_TARGET_DISTANCE = 0.5;
    private static final double CLOSE_ENOUGH_TO_START_INTERACTING_WITH_TARGET_PATH_END_DISTANCE = 1.0;
    private static final double CLOSE_ENOUGH_TO_CONTINUE_INTERACTING_WITH_TARGET = 2.0;
    private final float speedModifier;
    private final int horizontalSearchDistance;
    private final int verticalSearchDistance;
    private final Predicate<BlockState> sourceBlockType;
    private final Predicate<BlockState> destinationBlockType;
    private final Predicate<TransportItemTarget> shouldQueueForTarget;
    private final Consumer<PathfinderMob> onStartTravelling;
    private final Map<ContainerInteractionState, OnTargetReachedInteraction> onTargetInteractionActions;
    @Nullable
    private TransportItemTarget target = null;
    private TransportItemState state;
    @Nullable
    private ContainerInteractionState interactionState;
    private int ticksSinceReachingTarget;

    public TransportItemsBetweenContainers(float speedModifier, Predicate<BlockState> sourceBlockType, Predicate<BlockState> destinationBlockType, int horizontalSearchDistance, int verticalSearchDistance, Map<ContainerInteractionState, OnTargetReachedInteraction> onTargetInteractionActions, Consumer<PathfinderMob> onStartTravelling, Predicate<TransportItemTarget> shouldQueueForTarget) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.VISITED_BLOCK_POSITIONS, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.UNREACHABLE_TRANSPORT_BLOCK_POSITIONS, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.TRANSPORT_ITEMS_COOLDOWN_TICKS, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.IS_PANICKING, (Object)((Object)MemoryStatus.VALUE_ABSENT)));
        this.speedModifier = speedModifier;
        this.sourceBlockType = sourceBlockType;
        this.destinationBlockType = destinationBlockType;
        this.horizontalSearchDistance = horizontalSearchDistance;
        this.verticalSearchDistance = verticalSearchDistance;
        this.onStartTravelling = onStartTravelling;
        this.shouldQueueForTarget = shouldQueueForTarget;
        this.onTargetInteractionActions = onTargetInteractionActions;
        this.state = TransportItemState.TRAVELLING;
    }

    @Override
    protected void start(ServerLevel level, PathfinderMob entity, long gameTime) {
        PathNavigation pathNavigation = entity.getNavigation();
        if (pathNavigation instanceof GroundPathNavigation) {
            GroundPathNavigation groundPathNavigation = (GroundPathNavigation)pathNavigation;
            groundPathNavigation.setCanPathToTargetsBelowSurface(true);
        }
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel level, PathfinderMob owner) {
        return !owner.isLeashed();
    }

    @Override
    protected boolean canStillUse(ServerLevel level, PathfinderMob entity, long gameTime) {
        return entity.getBrain().getMemory(MemoryModuleType.TRANSPORT_ITEMS_COOLDOWN_TICKS).isEmpty() && !entity.isPanicking() && !entity.isLeashed();
    }

    @Override
    protected boolean timedOut(long gameTime) {
        return false;
    }

    @Override
    protected void tick(ServerLevel level, PathfinderMob owner, long gameTime) {
        boolean flag = this.updateInvalidTarget(level, owner);
        if (this.target == null) {
            this.stop(level, owner, gameTime);
        } else if (!flag) {
            if (this.state.equals((Object)TransportItemState.QUEUING)) {
                this.onQueuingForTarget(this.target, level, owner);
            }
            if (this.state.equals((Object)TransportItemState.TRAVELLING)) {
                this.onTravelToTarget(this.target, level, owner);
            }
            if (this.state.equals((Object)TransportItemState.INTERACTING)) {
                this.onReachedTarget(this.target, level, owner);
            }
        }
    }

    private boolean updateInvalidTarget(ServerLevel level, PathfinderMob mob) {
        if (!this.hasValidTarget(level, mob)) {
            this.stopTargetingCurrentTarget(mob);
            Optional<TransportItemTarget> transportTarget = this.getTransportTarget(level, mob);
            if (transportTarget.isPresent()) {
                this.target = transportTarget.get();
                this.onStartTravelling(mob);
                this.setVisitedBlockPos(mob, level, this.target.pos);
                return true;
            }
            this.enterCooldownAfterNoMatchingTargetFound(mob);
            return true;
        }
        return false;
    }

    private void onQueuingForTarget(TransportItemTarget target, Level level, PathfinderMob mob) {
        if (!this.isAnotherMobInteractingWithTarget(target, level)) {
            this.resumeTravelling(mob);
        }
    }

    protected void onTravelToTarget(TransportItemTarget target, Level level, PathfinderMob mob) {
        if (this.isWithinTargetDistance(3.0, target, level, mob, this.getCenterPos(mob)) && this.isAnotherMobInteractingWithTarget(target, level)) {
            this.startQueuing(mob);
        } else if (this.isWithinTargetDistance(TransportItemsBetweenContainers.getInteractionRange(mob), target, level, mob, this.getCenterPos(mob))) {
            this.startOnReachedTargetInteraction(target, mob);
        } else {
            this.walkTowardsTarget(mob);
        }
    }

    private Vec3 getCenterPos(PathfinderMob mob) {
        return this.setMiddleYPosition(mob, mob.position());
    }

    protected void onReachedTarget(TransportItemTarget target, Level level, PathfinderMob mob) {
        if (!this.isWithinTargetDistance(2.0, target, level, mob, this.getCenterPos(mob))) {
            this.onStartTravelling(mob);
        } else {
            ++this.ticksSinceReachingTarget;
            this.onTargetInteraction(target, mob);
            if (this.ticksSinceReachingTarget >= 60) {
                this.doReachedTargetInteraction(mob, target.container, this::pickUpItems, (pathfinderMob, container) -> this.stopTargetingCurrentTarget(mob), this::putDownItem, (pathfinderMob, container) -> this.stopTargetingCurrentTarget(mob));
                this.onStartTravelling(mob);
            }
        }
    }

    private void startQueuing(PathfinderMob mob) {
        this.stopInPlace(mob);
        this.setTransportingState(TransportItemState.QUEUING);
    }

    private void resumeTravelling(PathfinderMob mob) {
        this.setTransportingState(TransportItemState.TRAVELLING);
        this.walkTowardsTarget(mob);
    }

    private void walkTowardsTarget(PathfinderMob mob) {
        if (this.target != null) {
            BehaviorUtils.setWalkAndLookTargetMemories((LivingEntity)mob, this.target.pos, this.speedModifier, 0);
        }
    }

    private void startOnReachedTargetInteraction(TransportItemTarget target, PathfinderMob mob) {
        this.doReachedTargetInteraction(mob, target.container, this.onReachedInteraction(ContainerInteractionState.PICKUP_ITEM), this.onReachedInteraction(ContainerInteractionState.PICKUP_NO_ITEM), this.onReachedInteraction(ContainerInteractionState.PLACE_ITEM), this.onReachedInteraction(ContainerInteractionState.PLACE_NO_ITEM));
        this.setTransportingState(TransportItemState.INTERACTING);
    }

    private void onStartTravelling(PathfinderMob mob) {
        this.onStartTravelling.accept(mob);
        this.setTransportingState(TransportItemState.TRAVELLING);
        this.interactionState = null;
        this.ticksSinceReachingTarget = 0;
    }

    private BiConsumer<PathfinderMob, Container> onReachedInteraction(ContainerInteractionState state) {
        return (pathfinderMob, container) -> this.setInteractionState(state);
    }

    private void setTransportingState(TransportItemState state) {
        this.state = state;
    }

    private void setInteractionState(ContainerInteractionState state) {
        this.interactionState = state;
    }

    private void onTargetInteraction(TransportItemTarget target, PathfinderMob mob) {
        mob.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, new BlockPosTracker(target.pos));
        this.stopInPlace(mob);
        if (this.interactionState != null) {
            Optional.ofNullable(this.onTargetInteractionActions.get((Object)this.interactionState)).ifPresent(onTargetReachedInteraction -> onTargetReachedInteraction.accept(mob, target, this.ticksSinceReachingTarget));
        }
    }

    private void doReachedTargetInteraction(PathfinderMob mob, Container container, BiConsumer<PathfinderMob, Container> pickupItem, BiConsumer<PathfinderMob, Container> pickupNoItem, BiConsumer<PathfinderMob, Container> placeItem, BiConsumer<PathfinderMob, Container> placeNoItem) {
        if (TransportItemsBetweenContainers.isPickingUpItems(mob)) {
            if (TransportItemsBetweenContainers.matchesGettingItemsRequirement(container)) {
                pickupItem.accept(mob, container);
            } else {
                pickupNoItem.accept(mob, container);
            }
        } else if (TransportItemsBetweenContainers.matchesLeavingItemsRequirement(mob, container)) {
            placeItem.accept(mob, container);
        } else {
            placeNoItem.accept(mob, container);
        }
    }

    private Optional<TransportItemTarget> getTransportTarget(ServerLevel level, PathfinderMob mob) {
        AABB targetSearchArea = this.getTargetSearchArea(mob);
        Set<GlobalPos> visitedPositions = TransportItemsBetweenContainers.getVisitedPositions(mob);
        Set<GlobalPos> unreachablePositions = TransportItemsBetweenContainers.getUnreachablePositions(mob);
        List<ChunkPos> list = ChunkPos.rangeClosed(new ChunkPos(mob.blockPosition()), Math.floorDiv(this.getHorizontalSearchDistance(mob), 16) + 1).toList();
        TransportItemTarget transportItemTarget = null;
        double d = 3.4028234663852886E38;
        for (ChunkPos chunkPos : list) {
            LevelChunk chunkNow = level.getChunkSource().getChunkNow(chunkPos.x, chunkPos.z);
            if (chunkNow == null) continue;
            for (BlockEntity blockEntity : chunkNow.getBlockEntities().values()) {
                TransportItemTarget transportItemTarget1;
                BaseContainerBlockEntity chestBlockEntity;
                double d1;
                if (!(blockEntity instanceof BaseContainerBlockEntity) || !((d1 = (chestBlockEntity = (BaseContainerBlockEntity)blockEntity).getBlockPos().distToCenterSqr(mob.position())) < d) || (transportItemTarget1 = this.isTargetValidToPick(mob, level, chestBlockEntity, visitedPositions, unreachablePositions, targetSearchArea)) == null) continue;
                transportItemTarget = transportItemTarget1;
                d = d1;
            }
        }
        return transportItemTarget == null ? Optional.empty() : Optional.of(transportItemTarget);
    }

    @Nullable
    private TransportItemTarget isTargetValidToPick(PathfinderMob mob, Level level, BlockEntity blockEntity, Set<GlobalPos> visitedPositions, Set<GlobalPos> unreachablePositions, AABB searchArea) {
        BlockPos blockPos = blockEntity.getBlockPos();
        boolean flag = searchArea.contains(blockPos.getX(), blockPos.getY(), blockPos.getZ());
        if (!flag) {
            return null;
        }
        TransportItemTarget transportItemTarget = TransportItemTarget.tryCreatePossibleTarget(blockEntity, level);
        if (transportItemTarget == null) {
            return null;
        }
        boolean flag1 = this.isWantedBlock(mob, transportItemTarget.state) && !this.isPositionAlreadyVisited(visitedPositions, unreachablePositions, transportItemTarget, level) && !this.isContainerLocked(transportItemTarget) && CraftEventFactory.callTransporterValidateTarget(mob, level, transportItemTarget.pos);
        return flag1 ? transportItemTarget : null;
    }

    private boolean isContainerLocked(TransportItemTarget target) {
        BaseContainerBlockEntity baseContainerBlockEntity;
        BlockEntity blockEntity = target.blockEntity;
        return blockEntity instanceof BaseContainerBlockEntity && (baseContainerBlockEntity = (BaseContainerBlockEntity)blockEntity).isLocked();
    }

    private boolean hasValidTarget(Level level, PathfinderMob mob) {
        boolean flag;
        boolean bl = flag = this.target != null && this.isWantedBlock(mob, this.target.state) && this.targetHasNotChanged(level, this.target);
        if (flag && (mob.level().purpurConfig.copperGolemCanOpenBarrel && this.target.state.is(Blocks.BARREL) || !this.isTargetBlocked(level, this.target))) {
            if (!this.state.equals((Object)TransportItemState.TRAVELLING)) {
                return true;
            }
            if (this.hasValidTravellingPath(level, this.target, mob)) {
                return true;
            }
            this.markVisitedBlockPosAsUnreachable(mob, level, this.target.pos);
        }
        return false;
    }

    private boolean hasValidTravellingPath(Level level, TransportItemTarget target, PathfinderMob mob) {
        Path path = mob.getNavigation().getPath() == null ? mob.getNavigation().createPath(target.pos, 0) : mob.getNavigation().getPath();
        Vec3 positionToReachTargetFrom = this.getPositionToReachTargetFrom(path, mob);
        boolean isWithinTargetDistance = this.isWithinTargetDistance(TransportItemsBetweenContainers.getInteractionRange(mob), target, level, mob, positionToReachTargetFrom);
        boolean flag = path == null && !isWithinTargetDistance;
        return flag || this.targetIsReachableFromPosition(level, isWithinTargetDistance, positionToReachTargetFrom, target, mob);
    }

    private Vec3 getPositionToReachTargetFrom(@Nullable Path path, PathfinderMob mob) {
        boolean flag = path == null || path.getEndNode() == null;
        Vec3 vec3 = flag ? mob.position() : path.getEndNode().asBlockPos().getBottomCenter();
        return this.setMiddleYPosition(mob, vec3);
    }

    private Vec3 setMiddleYPosition(PathfinderMob mob, Vec3 pos) {
        return pos.add(0.0, mob.getBoundingBox().getYsize() / 2.0, 0.0);
    }

    private boolean isTargetBlocked(Level level, TransportItemTarget target) {
        return ChestBlock.isChestBlockedAt(level, target.pos);
    }

    private boolean targetHasNotChanged(Level level, TransportItemTarget target) {
        return target.blockEntity.equals(level.getBlockEntity(target.pos));
    }

    private Stream<TransportItemTarget> getConnectedTargets(TransportItemTarget target, Level level) {
        if (target.state.getValueOrElse(ChestBlock.TYPE, ChestType.SINGLE) != ChestType.SINGLE) {
            TransportItemTarget transportItemTarget = TransportItemTarget.tryCreatePossibleTarget(ChestBlock.getConnectedBlockPos(target.pos, target.state), level);
            return transportItemTarget != null ? Stream.of(target, transportItemTarget) : Stream.of(target);
        }
        return Stream.of(target);
    }

    private AABB getTargetSearchArea(PathfinderMob mob) {
        int horizontalSearchDistance = this.getHorizontalSearchDistance(mob);
        return new AABB(mob.blockPosition()).inflate(horizontalSearchDistance, this.getVerticalSearchDistance(mob), horizontalSearchDistance);
    }

    private int getHorizontalSearchDistance(PathfinderMob mob) {
        return mob.isPassenger() ? 1 : this.horizontalSearchDistance;
    }

    private int getVerticalSearchDistance(PathfinderMob mob) {
        return mob.isPassenger() ? 1 : this.verticalSearchDistance;
    }

    private static Set<GlobalPos> getVisitedPositions(PathfinderMob mob) {
        return mob.getBrain().getMemory(MemoryModuleType.VISITED_BLOCK_POSITIONS).orElse(Set.of());
    }

    private static Set<GlobalPos> getUnreachablePositions(PathfinderMob mob) {
        return mob.getBrain().getMemory(MemoryModuleType.UNREACHABLE_TRANSPORT_BLOCK_POSITIONS).orElse(Set.of());
    }

    private boolean isPositionAlreadyVisited(Set<GlobalPos> visitedPositions, Set<GlobalPos> unreachablePositions, TransportItemTarget target, Level level) {
        return this.getConnectedTargets(target, level).map(transportItemTarget -> new GlobalPos(level.dimension(), transportItemTarget.pos)).anyMatch(globalPos -> visitedPositions.contains(globalPos) || unreachablePositions.contains(globalPos));
    }

    private static boolean hasFinishedPath(PathfinderMob mob) {
        return mob.getNavigation().getPath() != null && mob.getNavigation().getPath().isDone();
    }

    protected void setVisitedBlockPos(PathfinderMob mob, Level level, BlockPos pos) {
        HashSet<GlobalPos> set = new HashSet<GlobalPos>(TransportItemsBetweenContainers.getVisitedPositions(mob));
        set.add(new GlobalPos(level.dimension(), pos));
        if (set.size() > 10) {
            this.enterCooldownAfterNoMatchingTargetFound(mob);
        } else {
            mob.getBrain().setMemoryWithExpiry(MemoryModuleType.VISITED_BLOCK_POSITIONS, set, 6000L);
        }
    }

    protected void markVisitedBlockPosAsUnreachable(PathfinderMob mob, Level level, BlockPos pos) {
        HashSet<GlobalPos> set = new HashSet<GlobalPos>(TransportItemsBetweenContainers.getVisitedPositions(mob));
        set.remove(new GlobalPos(level.dimension(), pos));
        HashSet<GlobalPos> set1 = new HashSet<GlobalPos>(TransportItemsBetweenContainers.getUnreachablePositions(mob));
        set1.add(new GlobalPos(level.dimension(), pos));
        if (set1.size() > 50) {
            this.enterCooldownAfterNoMatchingTargetFound(mob);
        } else {
            mob.getBrain().setMemoryWithExpiry(MemoryModuleType.VISITED_BLOCK_POSITIONS, set, 6000L);
            mob.getBrain().setMemoryWithExpiry(MemoryModuleType.UNREACHABLE_TRANSPORT_BLOCK_POSITIONS, set1, 6000L);
        }
    }

    private boolean isWantedBlock(PathfinderMob mob, BlockState state) {
        return TransportItemsBetweenContainers.isPickingUpItems(mob) ? this.sourceBlockType.test(state) : mob.level().purpurConfig.copperGolemCanOpenBarrel && state.is(Blocks.BARREL) || this.destinationBlockType.test(state);
    }

    private static double getInteractionRange(PathfinderMob mob) {
        return TransportItemsBetweenContainers.hasFinishedPath(mob) ? 1.0 : 0.5;
    }

    private boolean isWithinTargetDistance(double distance, TransportItemTarget target, Level level, PathfinderMob mob, Vec3 pos) {
        AABB boundingBox = mob.getBoundingBox();
        AABB aabb = AABB.ofSize(pos, boundingBox.getXsize(), boundingBox.getYsize(), boundingBox.getZsize());
        return target.state.getCollisionShape(level, target.pos).bounds().inflate(distance, 0.5, distance).move(target.pos).intersects(aabb);
    }

    private boolean targetIsReachableFromPosition(Level level, boolean withinDistance, Vec3 pos, TransportItemTarget target, PathfinderMob mob) {
        return withinDistance && this.canSeeAnyTargetSide(target, level, mob, pos);
    }

    private boolean canSeeAnyTargetSide(TransportItemTarget target, Level level, PathfinderMob mob, Vec3 pos) {
        Vec3 center = target.pos.getCenter();
        return Direction.stream().map(direction -> center.add(0.5 * (double)direction.getStepX(), 0.5 * (double)direction.getStepY(), 0.5 * (double)direction.getStepZ())).map(vec3 -> level.clip(new ClipContext(pos, (Vec3)vec3, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, mob))).anyMatch(blockHitResult -> blockHitResult.getType() == HitResult.Type.BLOCK && blockHitResult.getBlockPos().equals(target.pos));
    }

    private boolean isAnotherMobInteractingWithTarget(TransportItemTarget target, Level level) {
        return this.getConnectedTargets(target, level).anyMatch(this.shouldQueueForTarget);
    }

    private static boolean isPickingUpItems(PathfinderMob mob) {
        return mob.getMainHandItem().isEmpty();
    }

    private static boolean matchesGettingItemsRequirement(Container container) {
        return !container.isEmpty();
    }

    private static boolean matchesLeavingItemsRequirement(PathfinderMob mob, Container container) {
        return container.isEmpty() || TransportItemsBetweenContainers.hasItemMatchingHandItem(mob, container);
    }

    private static boolean hasItemMatchingHandItem(PathfinderMob mob, Container container) {
        ItemStack mainHandItem = mob.getMainHandItem();
        for (ItemStack itemStack : container) {
            if (!ItemStack.isSameItem(itemStack, mainHandItem)) continue;
            return true;
        }
        return false;
    }

    private void pickUpItems(PathfinderMob mob, Container container) {
        mob.setItemSlot(EquipmentSlot.MAINHAND, TransportItemsBetweenContainers.pickupItemFromContainer(container));
        mob.setGuaranteedDrop(EquipmentSlot.MAINHAND);
        container.setChanged();
        this.clearMemoriesAfterMatchingTargetFound(mob);
    }

    private void putDownItem(PathfinderMob mob, Container container) {
        ItemStack itemStack = TransportItemsBetweenContainers.addItemsToContainer(mob, container);
        container.setChanged();
        mob.setItemSlot(EquipmentSlot.MAINHAND, itemStack);
        if (itemStack.isEmpty()) {
            this.clearMemoriesAfterMatchingTargetFound(mob);
        } else {
            this.stopTargetingCurrentTarget(mob);
        }
    }

    private static ItemStack pickupItemFromContainer(Container container) {
        int i = 0;
        for (ItemStack itemStack : container) {
            if (!itemStack.isEmpty()) {
                int min = Math.min(itemStack.getCount(), 16);
                return container.removeItem(i, min);
            }
            ++i;
        }
        return ItemStack.EMPTY;
    }

    private static ItemStack addItemsToContainer(PathfinderMob mob, Container container) {
        int i = 0;
        ItemStack mainHandItem = mob.getMainHandItem();
        for (ItemStack itemStack : container) {
            if (itemStack.isEmpty()) {
                container.setItem(i, mainHandItem);
                return ItemStack.EMPTY;
            }
            if (ItemStack.isSameItemSameComponents(itemStack, mainHandItem) && itemStack.getCount() < itemStack.getMaxStackSize()) {
                int i1 = itemStack.getMaxStackSize() - itemStack.getCount();
                int min = Math.min(i1, mainHandItem.getCount());
                itemStack.setCount(itemStack.getCount() + min);
                mainHandItem.setCount(mainHandItem.getCount() - i1);
                container.setItem(i, itemStack);
                if (mainHandItem.isEmpty()) {
                    return ItemStack.EMPTY;
                }
            }
            ++i;
        }
        return mainHandItem;
    }

    protected void stopTargetingCurrentTarget(PathfinderMob mob) {
        this.ticksSinceReachingTarget = 0;
        this.target = null;
        mob.getNavigation().stop();
        mob.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
    }

    protected void clearMemoriesAfterMatchingTargetFound(PathfinderMob mob) {
        this.stopTargetingCurrentTarget(mob);
        mob.getBrain().eraseMemory(MemoryModuleType.VISITED_BLOCK_POSITIONS);
        mob.getBrain().eraseMemory(MemoryModuleType.UNREACHABLE_TRANSPORT_BLOCK_POSITIONS);
    }

    private void enterCooldownAfterNoMatchingTargetFound(PathfinderMob mob) {
        this.stopTargetingCurrentTarget(mob);
        mob.getBrain().setMemory(MemoryModuleType.TRANSPORT_ITEMS_COOLDOWN_TICKS, 140);
        mob.getBrain().eraseMemory(MemoryModuleType.VISITED_BLOCK_POSITIONS);
        mob.getBrain().eraseMemory(MemoryModuleType.UNREACHABLE_TRANSPORT_BLOCK_POSITIONS);
    }

    @Override
    protected void stop(ServerLevel level, PathfinderMob entity, long gameTime) {
        this.onStartTravelling(entity);
        PathNavigation pathNavigation = entity.getNavigation();
        if (pathNavigation instanceof GroundPathNavigation) {
            GroundPathNavigation groundPathNavigation = (GroundPathNavigation)pathNavigation;
            groundPathNavigation.setCanPathToTargetsBelowSurface(false);
        }
    }

    private void stopInPlace(PathfinderMob entity) {
        entity.getNavigation().stop();
        entity.setXxa(0.0f);
        entity.setYya(0.0f);
        entity.setSpeed(0.0f);
        entity.setDeltaMovement(0.0, entity.getDeltaMovement().y, 0.0);
    }

    public record TransportItemTarget(BlockPos pos, Container container, BlockEntity blockEntity, BlockState state) {
        @Nullable
        public static TransportItemTarget tryCreatePossibleTarget(BlockEntity blockEntity, Level level) {
            BlockPos blockPos = blockEntity.getBlockPos();
            BlockState blockState = blockEntity.getBlockState();
            Container blockEntityContainer = TransportItemTarget.getBlockEntityContainer(blockEntity, blockState, level, blockPos);
            return blockEntityContainer != null ? new TransportItemTarget(blockPos, blockEntityContainer, blockEntity, blockState) : null;
        }

        @Nullable
        public static TransportItemTarget tryCreatePossibleTarget(BlockPos pos, Level level) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            return blockEntity == null ? null : TransportItemTarget.tryCreatePossibleTarget(blockEntity, level);
        }

        @Nullable
        private static Container getBlockEntityContainer(BlockEntity blockEntity, BlockState state, Level level, BlockPos pos) {
            Container container;
            Block block = state.getBlock();
            if (block instanceof ChestBlock) {
                ChestBlock chestBlock = (ChestBlock)block;
                return ChestBlock.getContainer(chestBlock, state, level, pos, false);
            }
            return blockEntity instanceof Container ? (container = (Container)((Object)blockEntity)) : null;
        }
    }

    public static enum TransportItemState {
        TRAVELLING,
        QUEUING,
        INTERACTING;

    }

    public static enum ContainerInteractionState {
        PICKUP_ITEM,
        PICKUP_NO_ITEM,
        PLACE_ITEM,
        PLACE_NO_ITEM;

    }

    @FunctionalInterface
    public static interface OnTargetReachedInteraction
    extends TriConsumer<PathfinderMob, TransportItemTarget, Integer> {
    }
}

