/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior.warden;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.monster.warden.WardenAi;

public class Sniffing<E extends Warden>
extends Behavior<E> {
    private static final double ANGER_FROM_SNIFFING_MAX_DISTANCE_XZ = 6.0;
    private static final double ANGER_FROM_SNIFFING_MAX_DISTANCE_Y = 20.0;

    public Sniffing(int duration) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.IS_SNIFFING, (Object)((Object)MemoryStatus.VALUE_PRESENT), MemoryModuleType.ATTACK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.LOOK_TARGET, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.NEAREST_ATTACKABLE, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.DISTURBANCE_LOCATION, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.SNIFF_COOLDOWN, (Object)((Object)MemoryStatus.REGISTERED)), duration);
    }

    @Override
    protected boolean canStillUse(ServerLevel level, E entity, long gameTime) {
        return true;
    }

    @Override
    protected void start(ServerLevel level, E entity, long gameTime) {
        ((Entity)entity).playSound(SoundEvents.WARDEN_SNIFF, 5.0f, 1.0f);
    }

    @Override
    protected void stop(ServerLevel level, E entity, long gameTime) {
        if (((Entity)entity).hasPose(Pose.SNIFFING)) {
            ((Entity)entity).setPose(Pose.STANDING);
        }
        ((Warden)entity).getBrain().eraseMemory(MemoryModuleType.IS_SNIFFING);
        ((Warden)entity).getBrain().getMemory(MemoryModuleType.NEAREST_ATTACKABLE).filter(arg_0 -> entity.canTargetEntity(arg_0)).ifPresent(livingEntity -> {
            if (entity.closerThan((Entity)livingEntity, 6.0, 20.0)) {
                entity.increaseAngerAt((Entity)livingEntity);
            }
            if (!entity.getBrain().hasMemoryValue(MemoryModuleType.DISTURBANCE_LOCATION)) {
                WardenAi.setDisturbanceLocation(entity, livingEntity.blockPosition());
            }
        });
    }
}

