/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import ca.spottedleaf.concurrentutil.util.IntegerUtil;
import ca.spottedleaf.moonrise.common.set.OptimizedSmallEnumSet;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;

public class GoalSelector {
    private static final WrappedGoal NO_GOAL = new WrappedGoal(Integer.MAX_VALUE, new Goal(){

        @Override
        public boolean canUse() {
            return false;
        }
    }){

        @Override
        public boolean isRunning() {
            return false;
        }
    };
    private final Map<Goal.Flag, WrappedGoal> lockedFlags = new EnumMap<Goal.Flag, WrappedGoal>(Goal.Flag.class);
    private final Set<WrappedGoal> availableGoals = new ObjectLinkedOpenHashSet();
    private static final Goal.Flag[] GOAL_FLAG_VALUES = Goal.Flag.values();
    private final OptimizedSmallEnumSet<Goal.Flag> goalTypes = new OptimizedSmallEnumSet<Goal.Flag>(Goal.Flag.class);
    private int curRate;

    public void addGoal(int priority, Goal goal) {
        this.availableGoals.add(new WrappedGoal(priority, goal));
    }

    public void removeAllGoals(Predicate<Goal> filter) {
        this.availableGoals.removeIf(wrappedGoal -> filter.test(wrappedGoal.getGoal()));
    }

    public boolean inactiveTick() {
        ++this.curRate;
        return this.curRate % 3 == 0;
    }

    public boolean hasTasks() {
        for (WrappedGoal task : this.availableGoals) {
            if (!task.isRunning()) continue;
            return true;
        }
        return false;
    }

    public void removeGoal(Goal goal) {
        for (WrappedGoal wrappedGoal : this.availableGoals) {
            if (wrappedGoal.getGoal() != goal || !wrappedGoal.isRunning()) continue;
            wrappedGoal.stop();
        }
        this.availableGoals.removeIf(wrappedGoal1 -> wrappedGoal1.getGoal() == goal);
    }

    private static boolean goalContainsAnyFlags(WrappedGoal goal, OptimizedSmallEnumSet<Goal.Flag> flags) {
        return goal.getFlags().hasCommonElements(flags);
    }

    private static boolean goalCanBeReplacedForAllFlags(WrappedGoal goal, Map<Goal.Flag, WrappedGoal> flag) {
        long flagIterator = goal.getFlags().getBackingSet();
        int wrappedGoalSize = goal.getFlags().size();
        for (int i = 0; i < wrappedGoalSize; ++i) {
            Goal.Flag flag1 = GOAL_FLAG_VALUES[Long.numberOfTrailingZeros(flagIterator)];
            flagIterator ^= IntegerUtil.getTrailingBit((long)flagIterator);
            if (flag.getOrDefault((Object)flag1, NO_GOAL).canBeReplacedBy(goal)) continue;
            return false;
        }
        return true;
    }

    public void tick() {
        ProfilerFiller profilerFiller = Profiler.get();
        profilerFiller.push("goalCleanup");
        for (WrappedGoal wrappedGoal : this.availableGoals) {
            if (!wrappedGoal.isRunning() || !GoalSelector.goalContainsAnyFlags(wrappedGoal, this.goalTypes) && wrappedGoal.canContinueToUse()) continue;
            wrappedGoal.stop();
        }
        this.lockedFlags.entrySet().removeIf(entry -> !((WrappedGoal)entry.getValue()).isRunning());
        profilerFiller.pop();
        profilerFiller.push("goalUpdate");
        for (WrappedGoal wrappedGoalx : this.availableGoals) {
            if (wrappedGoalx.isRunning() || GoalSelector.goalContainsAnyFlags(wrappedGoalx, this.goalTypes) || !GoalSelector.goalCanBeReplacedForAllFlags(wrappedGoalx, this.lockedFlags) || !wrappedGoalx.canUse()) continue;
            long flagIterator = wrappedGoalx.getFlags().getBackingSet();
            int wrappedGoalSize = wrappedGoalx.getFlags().size();
            for (int i = 0; i < wrappedGoalSize; ++i) {
                Goal.Flag flag = GOAL_FLAG_VALUES[Long.numberOfTrailingZeros(flagIterator)];
                flagIterator ^= IntegerUtil.getTrailingBit((long)flagIterator);
                WrappedGoal wrappedGoal1 = this.lockedFlags.getOrDefault((Object)flag, NO_GOAL);
                wrappedGoal1.stop();
                this.lockedFlags.put(flag, wrappedGoalx);
            }
            wrappedGoalx.start();
        }
        profilerFiller.pop();
        this.tickRunningGoals(true);
    }

    public void tickRunningGoals(boolean tickAllRunning) {
        ProfilerFiller profilerFiller = Profiler.get();
        profilerFiller.push("goalTick");
        for (WrappedGoal wrappedGoal : this.availableGoals) {
            if (!wrappedGoal.isRunning() || !tickAllRunning && !wrappedGoal.requiresUpdateEveryTick()) continue;
            wrappedGoal.tick();
        }
        profilerFiller.pop();
    }

    public Set<WrappedGoal> getAvailableGoals() {
        return this.availableGoals;
    }

    public void disableControlFlag(Goal.Flag flag) {
        this.goalTypes.addUnchecked(flag);
    }

    public void enableControlFlag(Goal.Flag flag) {
        this.goalTypes.removeUnchecked(flag);
    }

    public void setControlFlag(Goal.Flag flag, boolean enabled) {
        if (enabled) {
            this.enableControlFlag(flag);
        } else {
            this.disableControlFlag(flag);
        }
    }
}

