/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.phys.Vec3;

public class MoveBackToVillageGoal
extends RandomStrollGoal {
    private static final int MAX_XZ_DIST = 10;
    private static final int MAX_Y_DIST = 7;

    public MoveBackToVillageGoal(PathfinderMob mob, double speedModifier, boolean checkNoActionTime) {
        super(mob, speedModifier, 10, checkNoActionTime);
    }

    @Override
    public boolean canUse() {
        BlockPos blockPos;
        ServerLevel serverLevel = (ServerLevel)this.mob.level();
        return !serverLevel.isVillage(blockPos = this.mob.blockPosition()) && super.canUse();
    }

    @Override
    @Nullable
    protected Vec3 getPosition() {
        BlockPos blockPos;
        SectionPos sectionPos;
        ServerLevel serverLevel = (ServerLevel)this.mob.level();
        SectionPos sectionPos1 = BehaviorUtils.findSectionClosestToVillage(serverLevel, sectionPos = SectionPos.of(blockPos = this.mob.blockPosition()), 2);
        return sectionPos1 != sectionPos ? DefaultRandomPos.getPosTowards(this.mob, 10, 7, Vec3.atBottomCenterOf(sectionPos1.center()), 1.5707963705062866) : null;
    }
}

