/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal.target;

import javax.annotation.Nullable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.scores.PlayerTeam;
import org.bukkit.event.entity.EntityTargetEvent;

public abstract class TargetGoal
extends Goal {
    private static final int EMPTY_REACH_CACHE = 0;
    private static final int CAN_REACH_CACHE = 1;
    private static final int CANT_REACH_CACHE = 2;
    protected final Mob mob;
    protected final boolean mustSee;
    private final boolean mustReach;
    private int reachCache;
    private int reachCacheTime;
    private int unseenTicks;
    @Nullable
    protected LivingEntity targetMob;
    protected int unseenMemoryTicks = 60;

    public TargetGoal(Mob mob, boolean mustSee) {
        this(mob, mustSee, false);
    }

    public TargetGoal(Mob mob, boolean mustSee, boolean mustReach) {
        this.mob = mob;
        this.mustSee = mustSee;
        this.mustReach = mustReach;
    }

    @Override
    public boolean canContinueToUse() {
        LivingEntity target = this.mob.getTarget();
        if (target == null) {
            target = this.targetMob;
        }
        if (target == null) {
            return false;
        }
        if (!this.mob.canAttack(target)) {
            return false;
        }
        PlayerTeam team = this.mob.getTeam();
        PlayerTeam team1 = target.getTeam();
        if (team != null && team1 == team) {
            return false;
        }
        double followDistance = this.getFollowDistance();
        if (this.mob.distanceToSqr(target) > followDistance * followDistance) {
            return false;
        }
        if (this.mustSee) {
            if (this.mob.getSensing().hasLineOfSight(target)) {
                this.unseenTicks = 0;
            } else if (++this.unseenTicks > TargetGoal.reducedTickDelay(this.unseenMemoryTicks)) {
                return false;
            }
        }
        this.mob.setTarget(target, EntityTargetEvent.TargetReason.CLOSEST_ENTITY);
        return true;
    }

    protected double getFollowDistance() {
        return this.mob.getAttributeValue(Attributes.FOLLOW_RANGE);
    }

    @Override
    public void start() {
        this.reachCache = 0;
        this.reachCacheTime = 0;
        this.unseenTicks = 0;
    }

    @Override
    public void stop() {
        this.mob.setTarget(null, EntityTargetEvent.TargetReason.FORGOT_TARGET);
        this.targetMob = null;
    }

    protected boolean canAttack(@Nullable LivingEntity potentialTarget, TargetingConditions targetPredicate) {
        if (potentialTarget == null) {
            return false;
        }
        if (!targetPredicate.test(TargetGoal.getServerLevel(this.mob), this.mob, potentialTarget)) {
            return false;
        }
        if (!this.mob.isWithinHome(potentialTarget.blockPosition())) {
            return false;
        }
        if (this.mustReach) {
            if (--this.reachCacheTime <= 0) {
                this.reachCache = 0;
            }
            if (this.reachCache == 0) {
                int n = this.reachCache = this.canReach(potentialTarget) ? 1 : 2;
            }
            if (this.reachCache == 2) {
                return false;
            }
        }
        return true;
    }

    private boolean canReach(LivingEntity target) {
        int i1;
        this.reachCacheTime = TargetGoal.reducedTickDelay(10 + this.mob.getRandom().nextInt(5));
        Path path = this.mob.getNavigation().createPath(target, 0);
        if (path == null) {
            return false;
        }
        Node endNode = path.getEndNode();
        if (endNode == null) {
            return false;
        }
        int i = endNode.x - target.getBlockX();
        return (double)(i * i + (i1 = endNode.z - target.getBlockZ()) * i1) <= 2.25;
    }

    public TargetGoal setUnseenMemoryTicks(int unseenMemoryTicks) {
        this.unseenMemoryTicks = unseenMemoryTicks;
        return this;
    }
}

