/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ambient;

import java.time.LocalDate;
import java.time.temporal.ChronoField;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.ambient.AmbientCreature;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.purpurmc.purpur.controller.FlyingWithSpacebarMoveControllerWASD;

public class Bat
extends AmbientCreature {
    public static final float FLAP_LENGTH_SECONDS = 0.5f;
    public static final float TICKS_PER_FLAP = 10.0f;
    private static final EntityDataAccessor<Byte> DATA_ID_FLAGS = SynchedEntityData.defineId(Bat.class, EntityDataSerializers.BYTE);
    private static final int FLAG_RESTING = 1;
    private static final TargetingConditions BAT_RESTING_TARGETING = TargetingConditions.forNonCombat().range(4.0);
    private static final byte DEFAULT_FLAGS = 0;
    public final AnimationState flyAnimationState = new AnimationState();
    public final AnimationState restAnimationState = new AnimationState();
    @Nullable
    public BlockPos targetPosition;

    public Bat(EntityType<? extends Bat> type, Level level) {
        super((EntityType<? extends AmbientCreature>)type, level);
        this.moveControl = new FlyingWithSpacebarMoveControllerWASD((Mob)this, 0.075f);
        if (!level.isClientSide()) {
            this.setResting(true);
        }
    }

    @Override
    public boolean shouldSendAttribute(Attribute attribute) {
        return attribute != Attributes.FLYING_SPEED.value();
    }

    @Override
    public boolean isRidable() {
        return this.level().purpurConfig.batRidable;
    }

    @Override
    public boolean dismountsUnderwater() {
        return this.level().purpurConfig.useDismountsUnderwaterTag ? super.dismountsUnderwater() : !this.level().purpurConfig.batRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.level().purpurConfig.batControllable;
    }

    @Override
    public double getMaxY() {
        return this.level().purpurConfig.batMaxY;
    }

    @Override
    public void onMount(Player rider) {
        super.onMount(rider);
        if (this.isResting()) {
            this.setResting(false);
            this.level().levelEvent(null, 1025, new BlockPos(this).above(), 0);
        }
    }

    @Override
    public void travel(Vec3 vec3) {
        super.travel(vec3);
        if (this.getRider() != null && this.isControllable() && !this.onGround) {
            float speed = (float)this.getAttributeValue(Attributes.FLYING_SPEED) * 2.0f;
            this.setSpeed(speed);
            Vec3 mot = this.getDeltaMovement();
            this.move(MoverType.SELF, mot.multiply(speed, 0.25, speed));
            this.setDeltaMovement(mot.scale(0.9));
        }
    }

    @Override
    public void initAttributes() {
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(this.level().purpurConfig.batMaxHealth);
        this.getAttribute(Attributes.SCALE).setBaseValue(this.level().purpurConfig.batScale);
        this.getAttribute(Attributes.FOLLOW_RANGE).setBaseValue(this.level().purpurConfig.batFollowRange);
        this.getAttribute(Attributes.KNOCKBACK_RESISTANCE).setBaseValue(this.level().purpurConfig.batKnockbackResistance);
        this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(this.level().purpurConfig.batMovementSpeed);
        this.getAttribute(Attributes.FLYING_SPEED).setBaseValue(this.level().purpurConfig.batFlyingSpeed);
        this.getAttribute(Attributes.ARMOR).setBaseValue(this.level().purpurConfig.batArmor);
        this.getAttribute(Attributes.ARMOR_TOUGHNESS).setBaseValue(this.level().purpurConfig.batArmorToughness);
        this.getAttribute(Attributes.ATTACK_KNOCKBACK).setBaseValue(this.level().purpurConfig.batAttackKnockback);
    }

    @Override
    public boolean isSensitiveToWater() {
        return this.level().purpurConfig.batTakeDamageFromWater;
    }

    @Override
    protected boolean isAlwaysExperienceDropper() {
        return this.level().purpurConfig.batAlwaysDropExp;
    }

    @Override
    public boolean isFlapping() {
        return !this.isResting() && (float)this.tickCount % 10.0f == 0.0f;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_ID_FLAGS, (byte)0);
    }

    @Override
    public float getSoundVolume() {
        return 0.1f;
    }

    @Override
    public float getVoicePitch() {
        return super.getVoicePitch() * 0.95f;
    }

    @Override
    @Nullable
    public SoundEvent getAmbientSound() {
        return this.isResting() && this.random.nextInt(4) != 0 ? null : SoundEvents.BAT_AMBIENT;
    }

    @Override
    public SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.BAT_HURT;
    }

    @Override
    public SoundEvent getDeathSound() {
        return SoundEvents.BAT_DEATH;
    }

    @Override
    public boolean isCollidable(boolean ignoreClimbing) {
        return false;
    }

    @Override
    protected void doPush(Entity entity) {
    }

    @Override
    protected void pushEntities() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 6.0).add(Attributes.FLYING_SPEED, 0.6);
    }

    public boolean isResting() {
        return (this.entityData.get(DATA_ID_FLAGS) & 1) != 0;
    }

    public void setResting(boolean isResting) {
        byte b = this.entityData.get(DATA_ID_FLAGS);
        if (isResting) {
            this.entityData.set(DATA_ID_FLAGS, (byte)(b | 1));
        } else {
            this.entityData.set(DATA_ID_FLAGS, (byte)(b & 0xFFFFFFFE));
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.isResting()) {
            this.setDeltaMovement(Vec3.ZERO);
            this.setPosRaw(this.getX(), (double)Mth.floor(this.getY()) + 1.0 - (double)this.getBbHeight(), this.getZ());
        } else {
            this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, 0.6, 1.0));
        }
        this.setupAnimationStates();
    }

    @Override
    protected void customServerAiStep(ServerLevel level) {
        if (this.getRider() != null && this.isControllable()) {
            Vec3 mot = this.getDeltaMovement();
            this.setDeltaMovement(mot.x(), mot.y() + (this.getVerticalMot() > 0.0f ? 0.07 : 0.0), mot.z());
            return;
        }
        super.customServerAiStep(level);
        BlockPos blockPos = this.blockPosition();
        BlockPos blockPos1 = blockPos.above();
        if (this.isResting()) {
            boolean isSilent = this.isSilent();
            if (level.getBlockState(blockPos1).isRedstoneConductor(level, blockPos)) {
                if (this.random.nextInt(200) == 0) {
                    this.yHeadRot = this.random.nextInt(360);
                }
                if (level.getNearestPlayer(BAT_RESTING_TARGETING, this) != null && CraftEventFactory.handleBatToggleSleepEvent(this, true)) {
                    this.setResting(false);
                    if (!isSilent) {
                        level.levelEvent(null, 1025, blockPos, 0);
                    }
                }
            } else if (CraftEventFactory.handleBatToggleSleepEvent(this, true)) {
                this.setResting(false);
                if (!isSilent) {
                    level.levelEvent(null, 1025, blockPos, 0);
                }
            }
        } else {
            if (!(this.targetPosition == null || level.isEmptyBlock(this.targetPosition) && this.targetPosition.getY() > level.getMinY())) {
                this.targetPosition = null;
            }
            if (this.targetPosition == null || this.random.nextInt(30) == 0 || this.targetPosition.closerToCenterThan(this.position(), 2.0)) {
                this.targetPosition = BlockPos.containing(this.getX() + (double)this.random.nextInt(7) - (double)this.random.nextInt(7), this.getY() + (double)this.random.nextInt(6) - 2.0, this.getZ() + (double)this.random.nextInt(7) - (double)this.random.nextInt(7));
            }
            double d = (double)this.targetPosition.getX() + 0.5 - this.getX();
            double d1 = (double)this.targetPosition.getY() + 0.1 - this.getY();
            double d2 = (double)this.targetPosition.getZ() + 0.5 - this.getZ();
            Vec3 deltaMovement = this.getDeltaMovement();
            Vec3 vec3 = deltaMovement.add((Math.signum(d) * 0.5 - deltaMovement.x) * (double)0.1f, (Math.signum(d1) * (double)0.7f - deltaMovement.y) * (double)0.1f, (Math.signum(d2) * 0.5 - deltaMovement.z) * (double)0.1f);
            this.setDeltaMovement(vec3);
            float f = (float)(Mth.atan2(vec3.z, vec3.x) * 180.0 / 3.1415927410125732) - 90.0f;
            float f1 = Mth.wrapDegrees(f - this.getYRot());
            this.zza = 0.5f;
            this.setYRot(this.getYRot() + f1);
            if (this.random.nextInt(100) == 0 && level.getBlockState(blockPos1).isRedstoneConductor(level, blockPos1) && CraftEventFactory.handleBatToggleSleepEvent(this, false)) {
                this.setResting(true);
            }
        }
    }

    @Override
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.EVENTS;
    }

    @Override
    protected void checkFallDamage(double y, boolean onGround, BlockState state, BlockPos pos) {
    }

    @Override
    public boolean isIgnoringBlockTriggers() {
        return true;
    }

    @Override
    public boolean hurtServer(ServerLevel level, DamageSource damageSource, float amount) {
        if (this.isInvulnerableTo(level, damageSource)) {
            return false;
        }
        if (this.isResting() && CraftEventFactory.handleBatToggleSleepEvent(this, true)) {
            this.setResting(false);
        }
        return super.hurtServer(level, damageSource, amount);
    }

    @Override
    protected void readAdditionalSaveData(ValueInput input) {
        super.readAdditionalSaveData(input);
        this.entityData.set(DATA_ID_FLAGS, input.getByteOr("BatFlags", (byte)0));
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput output) {
        super.addAdditionalSaveData(output);
        output.putByte("BatFlags", this.entityData.get(DATA_ID_FLAGS));
    }

    public static boolean checkBatSpawnRules(EntityType<Bat> entityType, LevelAccessor level, EntitySpawnReason spawnReason, BlockPos pos, RandomSource randomSource) {
        if (pos.getY() >= level.getHeightmapPos(Heightmap.Types.WORLD_SURFACE, pos).getY()) {
            return false;
        }
        int maxLocalRawBrightness = level.getMaxLocalRawBrightness(pos);
        int i = 4;
        if (Bat.isHalloweenSeason(level.getMinecraftWorld())) {
            i = 7;
        } else if (randomSource.nextBoolean()) {
            return false;
        }
        return maxLocalRawBrightness <= randomSource.nextInt(i) && level.getBlockState(pos.below()).is(BlockTags.BATS_SPAWNABLE_ON) && Bat.checkMobSpawnRules(entityType, level, spawnReason, pos, randomSource);
    }

    public static boolean isHalloweenSeason(Level level) {
        return level.purpurConfig.forceHalloweenSeason || Bat.isHalloween();
    }

    private static boolean isHalloween() {
        LocalDate localDate = LocalDate.now();
        int i = localDate.get(ChronoField.DAY_OF_MONTH);
        int i1 = localDate.get(ChronoField.MONTH_OF_YEAR);
        return i1 == 10 && i >= 20 || i1 == 11 && i <= 3;
    }

    private void setupAnimationStates() {
        if (this.isResting()) {
            this.flyAnimationState.stop();
            this.restAnimationState.startIfStopped(this.tickCount);
        } else {
            this.restAnimationState.stop();
            this.flyAnimationState.startIfStopped(this.tickCount);
        }
    }
}

