/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SpellParticleOption;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.AbstractCow;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.SuspiciousStewEffects;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SuspiciousEffectHolder;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.player.PlayerShearEntityEvent;

public class MushroomCow
extends AbstractCow
implements Shearable {
    private static final EntityDataAccessor<Integer> DATA_TYPE = SynchedEntityData.defineId(MushroomCow.class, EntityDataSerializers.INT);
    private static final int MUTATE_CHANCE = 1024;
    private static final String TAG_STEW_EFFECTS = "stew_effects";
    @Nullable
    public SuspiciousStewEffects stewEffects;
    @Nullable
    private UUID lastLightningBoltUUID;

    public MushroomCow(EntityType<? extends MushroomCow> type, Level level) {
        super((EntityType<? extends AbstractCow>)type, level);
    }

    @Override
    public boolean isRidable() {
        return this.level().purpurConfig.mooshroomRidable;
    }

    @Override
    public boolean dismountsUnderwater() {
        return this.level().purpurConfig.useDismountsUnderwaterTag ? super.dismountsUnderwater() : !this.level().purpurConfig.mooshroomRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.level().purpurConfig.mooshroomControllable;
    }

    @Override
    public void initAttributes() {
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(this.level().purpurConfig.mooshroomMaxHealth);
    }

    @Override
    public int getPurpurBreedTime() {
        return this.level().purpurConfig.mooshroomBreedingTicks;
    }

    @Override
    public boolean isSensitiveToWater() {
        return this.level().purpurConfig.mooshroomTakeDamageFromWater;
    }

    @Override
    protected boolean isAlwaysExperienceDropper() {
        return this.level().purpurConfig.mooshroomAlwaysDropExp;
    }

    @Override
    public float getWalkTargetValue(BlockPos pos, LevelReader level) {
        return level.getBlockState(pos.below()).is(Blocks.MYCELIUM) ? 10.0f : level.getPathfindingCostFromLightLevels(pos);
    }

    public static boolean checkMushroomSpawnRules(EntityType<MushroomCow> entityType, LevelAccessor level, EntitySpawnReason spawnReason, BlockPos pos, RandomSource random) {
        return level.getBlockState(pos.below()).is(BlockTags.MOOSHROOMS_SPAWNABLE_ON) && MushroomCow.isBrightEnoughToSpawn(level, pos);
    }

    @Override
    public void thunderHit(ServerLevel level, LightningBolt lightning) {
        UUID uuid = lightning.getUUID();
        if (!uuid.equals(this.lastLightningBoltUUID)) {
            this.setVariant(this.getVariant() == Variant.RED ? Variant.BROWN : Variant.RED);
            this.lastLightningBoltUUID = uuid;
            this.playSound(SoundEvents.MOOSHROOM_CONVERT, 2.0f, 1.0f);
        }
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_TYPE, Variant.DEFAULT.id);
    }

    @Override
    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemInHand = player.getItemInHand(hand);
        if (itemInHand.is(Items.BOWL) && !this.isBaby()) {
            ItemStack itemStack;
            boolean flag = false;
            if (this.stewEffects != null) {
                flag = true;
                itemStack = new ItemStack(Items.SUSPICIOUS_STEW);
                itemStack.set(DataComponents.SUSPICIOUS_STEW_EFFECTS, this.stewEffects);
                this.stewEffects = null;
            } else {
                itemStack = new ItemStack(Items.MUSHROOM_STEW);
            }
            ItemStack itemStack1 = ItemUtils.createFilledResult(itemInHand, player, itemStack, false);
            player.setItemInHand(hand, itemStack1);
            SoundEvent soundEvent = flag ? SoundEvents.MOOSHROOM_MILK_SUSPICIOUSLY : SoundEvents.MOOSHROOM_MILK;
            this.playSound(soundEvent, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (itemInHand.is(Items.SHEARS) && this.readyForShearing()) {
            Level itemStack = this.level();
            if (itemStack instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)itemStack;
                List<ItemStack> drops = this.generateDefaultDrops(serverLevel, itemInHand);
                PlayerShearEntityEvent event = CraftEventFactory.handlePlayerShearEntityEvent(player, this, itemInHand, hand, drops);
                if (event != null) {
                    if (event.isCancelled()) {
                        return this.tryRide(player, hand);
                    }
                    drops = CraftItemStack.asNMSCopy(event.getDrops());
                }
                this.shear(serverLevel, SoundSource.PLAYERS, itemInHand, drops);
                this.gameEvent(GameEvent.SHEAR, player);
                itemInHand.hurtAndBreak(1, (LivingEntity)player, hand.asEquipmentSlot());
            }
            return InteractionResult.SUCCESS;
        }
        if (this.getVariant() == Variant.BROWN) {
            Optional<SuspiciousStewEffects> effectsFromItemStack = this.getEffectsFromItemStack(itemInHand);
            if (effectsFromItemStack.isEmpty()) {
                return super.mobInteract(player, hand);
            }
            if (this.stewEffects != null) {
                for (int i = 0; i < 2; ++i) {
                    this.level().addParticle(ParticleTypes.SMOKE, this.getX() + this.random.nextDouble() / 2.0, this.getY(0.5), this.getZ() + this.random.nextDouble() / 2.0, 0.0, this.random.nextDouble() / 5.0, 0.0);
                }
            } else {
                itemInHand.consume(1, player);
                SpellParticleOption spellParticleOption = SpellParticleOption.create(ParticleTypes.EFFECT, -1, 1.0f);
                for (int i1 = 0; i1 < 4; ++i1) {
                    this.level().addParticle(spellParticleOption, this.getX() + this.random.nextDouble() / 2.0, this.getY(0.5), this.getZ() + this.random.nextDouble() / 2.0, 0.0, this.random.nextDouble() / 5.0, 0.0);
                }
                this.stewEffects = effectsFromItemStack.get();
                this.playSound(SoundEvents.MOOSHROOM_EAT, 2.0f, 1.0f);
            }
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    @Override
    public void shear(ServerLevel level, SoundSource source, ItemStack shears) {
        this.shear(level, source, shears, this.generateDefaultDrops(level, shears));
    }

    @Override
    public List<ItemStack> generateDefaultDrops(ServerLevel level, ItemStack shears) {
        ObjectArrayList drops = new ObjectArrayList();
        this.dropFromShearingLootTable(level, BuiltInLootTables.SHEAR_MOOSHROOM, shears, (arg_0, arg_1) -> MushroomCow.lambda$generateDefaultDrops$0((List)drops, arg_0, arg_1));
        return drops;
    }

    @Override
    public void shear(ServerLevel level, SoundSource source, ItemStack shears, List<ItemStack> drops) {
        level.playSound(null, this, SoundEvents.MOOSHROOM_SHEAR, source, 1.0f, 1.0f);
        this.convertTo(EntityType.COW, ConversionParams.single(this, false, false), (T cow) -> {
            level.sendParticles(ParticleTypes.EXPLOSION, this.getX(), this.getY(0.5), this.getZ(), 1, 0.0, 0.0, 0.0, 0.0);
            cow.copyPosition(this);
            cow.yBodyRot = this.yBodyRot;
            cow.setYHeadRot(this.getYHeadRot());
            cow.yRotO = this.yRotO;
            cow.xRotO = this.xRotO;
            drops.forEach(drop -> this.spawnAtLocation(level, new ItemEntity(this.level(), this.getX(), this.getY(1.0), this.getZ(), (ItemStack)drop)));
        }, EntityTransformEvent.TransformReason.SHEARED, CreatureSpawnEvent.SpawnReason.SHEARED);
    }

    @Override
    public boolean readyForShearing() {
        return this.isAlive() && !this.isBaby();
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput output) {
        super.addAdditionalSaveData(output);
        output.store("Type", Variant.CODEC, this.getVariant());
        output.storeNullable(TAG_STEW_EFFECTS, SuspiciousStewEffects.CODEC, this.stewEffects);
    }

    @Override
    protected void readAdditionalSaveData(ValueInput input) {
        super.readAdditionalSaveData(input);
        this.setVariant(input.read("Type", Variant.CODEC).orElse(Variant.DEFAULT));
        this.stewEffects = input.read(TAG_STEW_EFFECTS, SuspiciousStewEffects.CODEC).orElse(null);
    }

    private Optional<SuspiciousStewEffects> getEffectsFromItemStack(ItemStack stack) {
        SuspiciousEffectHolder suspiciousEffectHolder = SuspiciousEffectHolder.tryGet(stack.getItem());
        return suspiciousEffectHolder != null ? Optional.of(suspiciousEffectHolder.getSuspiciousEffects()) : Optional.empty();
    }

    public void setVariant(Variant variant) {
        this.entityData.set(DATA_TYPE, variant.id);
    }

    public Variant getVariant() {
        return Variant.byId(this.entityData.get(DATA_TYPE));
    }

    @Override
    @Nullable
    public <T> T get(DataComponentType<? extends T> component) {
        return component == DataComponents.MOOSHROOM_VARIANT ? MushroomCow.castComponentValue(component, this.getVariant()) : super.get(component);
    }

    @Override
    protected void applyImplicitComponents(DataComponentGetter componentGetter) {
        this.applyImplicitComponentIfPresent(componentGetter, DataComponents.MOOSHROOM_VARIANT);
        super.applyImplicitComponents(componentGetter);
    }

    @Override
    protected <T> boolean applyImplicitComponent(DataComponentType<T> component, T value) {
        if (component == DataComponents.MOOSHROOM_VARIANT) {
            this.setVariant(MushroomCow.castComponentValue(DataComponents.MOOSHROOM_VARIANT, value));
            return true;
        }
        return super.applyImplicitComponent(component, value);
    }

    @Override
    @Nullable
    public MushroomCow getBreedOffspring(ServerLevel level, AgeableMob partner) {
        MushroomCow mushroomCow = EntityType.MOOSHROOM.create(level, EntitySpawnReason.BREEDING);
        if (mushroomCow != null) {
            mushroomCow.setVariant(this.getOffspringVariant((MushroomCow)partner));
        }
        return mushroomCow;
    }

    private Variant getOffspringVariant(MushroomCow partner) {
        Variant variant1;
        Variant variant = this.getVariant();
        Variant variant2 = variant == (variant1 = partner.getVariant()) && this.random.nextInt(1024) == 0 ? (variant == Variant.BROWN ? Variant.RED : Variant.BROWN) : (this.random.nextBoolean() ? variant : variant1);
        return variant2;
    }

    private static /* synthetic */ void lambda$generateDefaultDrops$0(List drops, ServerLevel ignored, ItemStack stack) {
        for (int i = 0; i < stack.getCount(); ++i) {
            drops.add(stack.copyWithCount(1));
        }
    }

    public static enum Variant implements StringRepresentable
    {
        RED("red", 0, Blocks.RED_MUSHROOM.defaultBlockState()),
        BROWN("brown", 1, Blocks.BROWN_MUSHROOM.defaultBlockState());

        public static final Variant DEFAULT;
        public static final Codec<Variant> CODEC;
        private static final IntFunction<Variant> BY_ID;
        public static final StreamCodec<ByteBuf, Variant> STREAM_CODEC;
        private final String type;
        final int id;
        private final BlockState blockState;

        private Variant(String type, int id, BlockState blockState) {
            this.type = type;
            this.id = id;
            this.blockState = blockState;
        }

        public BlockState getBlockState() {
            return this.blockState;
        }

        @Override
        public String getSerializedName() {
            return this.type;
        }

        private int id() {
            return this.id;
        }

        static Variant byId(int id) {
            return BY_ID.apply(id);
        }

        static {
            DEFAULT = RED;
            CODEC = StringRepresentable.fromEnum(Variant::values);
            BY_ID = ByIdMap.continuous(Variant::id, Variant.values(), ByIdMap.OutOfBoundsStrategy.CLAMP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Variant::id);
        }
    }
}

