/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerShearEntityEvent;
import org.purpurmc.purpur.entity.ai.HasRider;

public class SnowGolem
extends AbstractGolem
implements Shearable,
RangedAttackMob {
    private static final EntityDataAccessor<Byte> DATA_PUMPKIN_ID = SynchedEntityData.defineId(SnowGolem.class, EntityDataSerializers.BYTE);
    private static final byte PUMPKIN_FLAG = 16;
    private static final boolean DEFAULT_PUMPKIN = true;
    @Nullable
    private UUID summoner;

    public SnowGolem(EntityType<? extends SnowGolem> type, Level level) {
        super((EntityType<? extends AbstractGolem>)type, level);
    }

    @Nullable
    public UUID getSummoner() {
        return this.summoner;
    }

    public void setSummoner(@Nullable UUID summoner) {
        this.summoner = summoner;
    }

    @Override
    public boolean isRidable() {
        return this.level().purpurConfig.snowGolemRidable;
    }

    @Override
    public boolean dismountsUnderwater() {
        return this.level().purpurConfig.useDismountsUnderwaterTag ? super.dismountsUnderwater() : !this.level().purpurConfig.snowGolemRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.level().purpurConfig.snowGolemControllable;
    }

    @Override
    public void initAttributes() {
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(this.level().purpurConfig.snowGolemMaxHealth);
        this.getAttribute(Attributes.SCALE).setBaseValue(this.level().purpurConfig.snowGolemScale);
    }

    @Override
    protected boolean isAlwaysExperienceDropper() {
        return this.level().purpurConfig.snowGolemAlwaysDropExp;
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(0, new HasRider(this));
        this.goalSelector.addGoal(1, new RangedAttackGoal(this, this.level().purpurConfig.snowGolemAttackDistance, this.level().purpurConfig.snowGolemSnowBallMin, this.level().purpurConfig.snowGolemSnowBallMax, this.level().purpurConfig.snowGolemSnowBallModifier));
        this.goalSelector.addGoal(2, new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 1.0000001E-5f));
        this.goalSelector.addGoal(3, new LookAtPlayerGoal(this, Player.class, 6.0f));
        this.goalSelector.addGoal(4, new RandomLookAroundGoal(this));
        this.targetSelector.addGoal(0, new HasRider(this));
        this.targetSelector.addGoal(1, new NearestAttackableTargetGoal<Mob>(this, Mob.class, 10, true, false, (entity, level) -> entity instanceof Enemy));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 4.0).add(Attributes.MOVEMENT_SPEED, 0.2f);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_PUMPKIN_ID, (byte)16);
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput output) {
        super.addAdditionalSaveData(output);
        output.putBoolean("Pumpkin", this.hasPumpkin());
        output.storeNullable("Purpur.Summoner", UUIDUtil.CODEC, this.getSummoner());
    }

    @Override
    protected void readAdditionalSaveData(ValueInput input) {
        super.readAdditionalSaveData(input);
        this.setPumpkin(input.getBooleanOr("Pumpkin", true));
        this.setSummoner(input.read("Purpur.Summoner", UUIDUtil.CODEC).orElse(null));
    }

    @Override
    public boolean isSensitiveToWater() {
        return this.level().purpurConfig.snowGolemTakeDamageFromWater;
    }

    @Override
    public void aiStep() {
        super.aiStep();
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.level().getBiome(this.blockPosition()).is(BiomeTags.SNOW_GOLEM_MELTS)) {
                this.hurtServer(serverLevel, this.damageSources().onFire().knownCause(EntityDamageEvent.DamageCause.MELTING), 1.0f);
            }
            if (!serverLevel.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING, serverLevel.purpurConfig.snowGolemMobGriefingOverride)) {
                return;
            }
            if (this.getRider() != null && this.isControllable() && !this.level().purpurConfig.snowGolemLeaveTrailWhenRidden) {
                return;
            }
            BlockState blockState = Blocks.SNOW.defaultBlockState();
            for (int i = 0; i < 4; ++i) {
                int floor = Mth.floor(this.getX() + (double)((float)(i % 2 * 2 - 1) * 0.25f));
                int floor1 = Mth.floor(this.getY());
                int floor2 = Mth.floor(this.getZ() + (double)((float)(i / 2 % 2 * 2 - 1) * 0.25f));
                BlockPos blockPos = new BlockPos(floor, floor1, floor2);
                if (!this.level().getBlockState(blockPos).isAir() || !blockState.canSurvive(this.level(), blockPos) || !CraftEventFactory.handleBlockFormEvent(this.level(), blockPos, blockState, 3, this)) continue;
                this.level().gameEvent(GameEvent.BLOCK_PLACE, blockPos, GameEvent.Context.of(this, blockState));
            }
        }
    }

    @Override
    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        double d = target.getX() - this.getX();
        double d1 = target.getEyeY() - (double)1.1f;
        double d2 = target.getZ() - this.getZ();
        double d3 = Math.sqrt(d * d + d2 * d2) * (double)0.2f;
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ItemStack itemStack = new ItemStack(Items.SNOWBALL);
            Projectile.spawnProjectile(new Snowball(serverLevel, this, itemStack), serverLevel, itemStack, snowball -> snowball.shoot(d, d1 + d3 - snowball.getY(), d2, 1.6f, 12.0f));
        }
        this.playSound(SoundEvents.SNOW_GOLEM_SHOOT, 1.0f, 0.4f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
    }

    @Override
    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemInHand = player.getItemInHand(hand);
        if (itemInHand.is(Items.SHEARS) && this.readyForShearing()) {
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                List<ItemStack> drops = this.generateDefaultDrops(serverLevel, itemInHand);
                PlayerShearEntityEvent event = CraftEventFactory.handlePlayerShearEntityEvent(player, this, itemInHand, hand, drops);
                if (event != null) {
                    if (event.isCancelled()) {
                        return this.tryRide(player, hand);
                    }
                    drops = CraftItemStack.asNMSCopy(event.getDrops());
                }
                this.shear(serverLevel, SoundSource.PLAYERS, itemInHand, drops);
                this.gameEvent(GameEvent.SHEAR, player);
                itemInHand.hurtAndBreak(1, (LivingEntity)player, hand.asEquipmentSlot());
            }
            return InteractionResult.SUCCESS;
        }
        if (this.level().purpurConfig.snowGolemPutPumpkinBack && !this.hasPumpkin() && itemInHand.getItem() == Blocks.CARVED_PUMPKIN.asItem()) {
            this.setPumpkin(true);
            if (!player.getAbilities().instabuild) {
                itemInHand.shrink(1);
            }
            return InteractionResult.SUCCESS;
        }
        return this.tryRide(player, hand);
    }

    @Override
    public void shear(ServerLevel level, SoundSource source, ItemStack shears) {
        this.shear(level, source, shears, this.generateDefaultDrops(level, shears));
    }

    @Override
    public List<ItemStack> generateDefaultDrops(ServerLevel level, ItemStack shears) {
        ObjectArrayList drops = new ObjectArrayList();
        this.dropFromShearingLootTable(level, BuiltInLootTables.SHEAR_SNOW_GOLEM, shears, (arg_0, arg_1) -> SnowGolem.lambda$generateDefaultDrops$2((List)drops, arg_0, arg_1));
        return drops;
    }

    @Override
    public void shear(ServerLevel level, SoundSource source, ItemStack shears, List<ItemStack> drops) {
        level.playSound(null, this, SoundEvents.SNOW_GOLEM_SHEAR, source, 1.0f, 1.0f);
        this.setPumpkin(false);
        drops.forEach(itemStack -> {
            this.forceDrops = true;
            this.spawnAtLocation(level, (ItemStack)itemStack, this.getEyeHeight());
            this.forceDrops = false;
        });
    }

    @Override
    public boolean readyForShearing() {
        return this.isAlive() && this.hasPumpkin();
    }

    public boolean hasPumpkin() {
        return (this.entityData.get(DATA_PUMPKIN_ID) & 0x10) != 0;
    }

    public void setPumpkin(boolean pumpkinEquipped) {
        byte b = this.entityData.get(DATA_PUMPKIN_ID);
        if (pumpkinEquipped) {
            this.entityData.set(DATA_PUMPKIN_ID, (byte)(b | 0x10));
        } else {
            this.entityData.set(DATA_PUMPKIN_ID, (byte)(b & 0xFFFFFFEF));
        }
    }

    @Override
    @Nullable
    public SoundEvent getAmbientSound() {
        return SoundEvents.SNOW_GOLEM_AMBIENT;
    }

    @Override
    @Nullable
    public SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.SNOW_GOLEM_HURT;
    }

    @Override
    @Nullable
    public SoundEvent getDeathSound() {
        return SoundEvents.SNOW_GOLEM_DEATH;
    }

    @Override
    public Vec3 getLeashOffset() {
        return new Vec3(0.0, 0.75f * this.getEyeHeight(), this.getBbWidth() * 0.4f);
    }

    private static /* synthetic */ void lambda$generateDefaultDrops$2(List drops, ServerLevel ignored, ItemStack stack) {
        drops.add(stack);
    }
}

