/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.wolf;

import io.papermc.paper.event.entity.EntityDyeEvent;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Crackiness;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BegGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.animal.wolf.WolfSoundVariant;
import net.minecraft.world.entity.animal.wolf.WolfSoundVariants;
import net.minecraft.world.entity.animal.wolf.WolfVariant;
import net.minecraft.world.entity.animal.wolf.WolfVariants;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.variant.SpawnContext;
import net.minecraft.world.entity.variant.VariantUtils;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.purpurmc.purpur.entity.ai.HasRider;

public class Wolf
extends TamableAnimal
implements NeutralMob {
    private static final EntityDataAccessor<Boolean> DATA_INTERESTED_ID = SynchedEntityData.defineId(Wolf.class, EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> DATA_COLLAR_COLOR = SynchedEntityData.defineId(Wolf.class, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_REMAINING_ANGER_TIME = SynchedEntityData.defineId(Wolf.class, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Holder<WolfVariant>> DATA_VARIANT_ID = SynchedEntityData.defineId(Wolf.class, EntityDataSerializers.WOLF_VARIANT);
    private static final EntityDataAccessor<Holder<WolfSoundVariant>> DATA_SOUND_VARIANT_ID = SynchedEntityData.defineId(Wolf.class, EntityDataSerializers.WOLF_SOUND_VARIANT);
    public static final TargetingConditions.Selector PREY_SELECTOR = (entity, level) -> {
        EntityType<?> type = entity.getType();
        return type == EntityType.SHEEP || type == EntityType.RABBIT || type == EntityType.FOX;
    };
    private boolean isRabid = false;
    private static final TargetingConditions.Selector RABID_PREDICATE = (entity, ignored) -> entity instanceof ServerPlayer || entity instanceof Mob;
    private final Goal PATHFINDER_VANILLA = new NonTameRandomTargetGoal<Animal>(this, Animal.class, false, PREY_SELECTOR);
    private final Goal PATHFINDER_RABID = new NonTameRandomTargetGoal<LivingEntity>(this, LivingEntity.class, false, RABID_PREDICATE);
    private static final float START_HEALTH = 8.0f;
    private static final float TAME_HEALTH = 40.0f;
    private static final float ARMOR_REPAIR_UNIT = 0.125f;
    public static final float DEFAULT_TAIL_ANGLE = 0.62831855f;
    private static final DyeColor DEFAULT_COLLAR_COLOR = DyeColor.RED;
    private float interestedAngle;
    private float interestedAngleO;
    public boolean isWet;
    private boolean isShaking;
    private float shakeAnim;
    private float shakeAnimO;
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.rangeOfSeconds(20, 39);
    @Nullable
    private UUID persistentAngerTarget;

    public Wolf(EntityType<? extends Wolf> type, Level level) {
        super((EntityType<? extends TamableAnimal>)type, level);
        this.setTame(false, false);
        this.setPathfindingMalus(PathType.POWDER_SNOW, -1.0f);
        this.setPathfindingMalus(PathType.DANGER_POWDER_SNOW, -1.0f);
    }

    public boolean isRabid() {
        return this.isRabid;
    }

    public void setRabid(boolean isRabid) {
        this.isRabid = isRabid;
        this.updatePathfinders(true);
    }

    public void updatePathfinders(boolean modifyEffects) {
        this.targetSelector.removeGoal(this.PATHFINDER_VANILLA);
        this.targetSelector.removeGoal(this.PATHFINDER_RABID);
        if (this.isRabid) {
            this.setOwnerReference(null);
            this.setTame(false, true);
            this.targetSelector.addGoal(5, this.PATHFINDER_RABID);
            if (modifyEffects) {
                this.addEffect(new MobEffectInstance(MobEffects.NAUSEA, 1200));
            }
        } else {
            this.targetSelector.addGoal(5, this.PATHFINDER_VANILLA);
            this.stopBeingAngry();
            if (modifyEffects) {
                this.removeEffect(MobEffects.NAUSEA);
            }
        }
    }

    @Override
    public void tame(Player player) {
        this.setCollarColor(this.level().purpurConfig.wolfDefaultCollarColor);
        super.tame(player);
    }

    @Override
    public boolean isRidable() {
        return this.level().purpurConfig.wolfRidable;
    }

    @Override
    public boolean dismountsUnderwater() {
        return this.level().purpurConfig.useDismountsUnderwaterTag ? super.dismountsUnderwater() : !this.level().purpurConfig.wolfRidableInWater;
    }

    @Override
    public void onMount(Player rider) {
        super.onMount(rider);
        this.setInSittingPose(false);
    }

    @Override
    public boolean isControllable() {
        return this.level().purpurConfig.wolfControllable;
    }

    @Override
    public void initAttributes() {
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(this.level().purpurConfig.wolfMaxHealth);
        this.getAttribute(Attributes.SCALE).setBaseValue(this.level().purpurConfig.wolfScale);
    }

    @Override
    public int getPurpurBreedTime() {
        return this.level().purpurConfig.wolfBreedingTicks;
    }

    @Override
    public boolean isSensitiveToWater() {
        return this.level().purpurConfig.wolfTakeDamageFromWater;
    }

    @Override
    protected boolean isAlwaysExperienceDropper() {
        return this.level().purpurConfig.wolfAlwaysDropExp;
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(1, new FloatGoal(this));
        this.goalSelector.addGoal(1, new HasRider(this));
        this.goalSelector.addGoal(1, new TamableAnimal.TamableAnimalPanicGoal(this, 1.5, DamageTypeTags.PANIC_ENVIRONMENTAL_CAUSES));
        this.goalSelector.addGoal(2, new SitWhenOrderedToGoal(this));
        this.goalSelector.addGoal(3, new WolfAvoidEntityGoal<Llama>(this, Llama.class, 24.0f, 1.5, 1.5));
        this.goalSelector.addGoal(3, new AvoidRabidWolfGoal(this, 24.0f, 1.5, 1.5));
        this.goalSelector.addGoal(4, new LeapAtTargetGoal(this, 0.4f));
        this.goalSelector.addGoal(5, new MeleeAttackGoal(this, 1.0, true));
        this.goalSelector.addGoal(6, new FollowOwnerGoal(this, 1.0, 10.0f, 2.0f));
        this.goalSelector.addGoal(7, new BreedGoal(this, 1.0));
        this.goalSelector.addGoal(8, new WaterAvoidingRandomStrollGoal(this, 1.0));
        this.goalSelector.addGoal(9, new BegGoal(this, 8.0f));
        this.goalSelector.addGoal(10, new LookAtPlayerGoal(this, Player.class, 8.0f));
        this.goalSelector.addGoal(10, new RandomLookAroundGoal(this));
        this.targetSelector.addGoal(0, new HasRider(this));
        this.targetSelector.addGoal(1, new OwnerHurtByTargetGoal(this));
        this.targetSelector.addGoal(2, new OwnerHurtTargetGoal(this));
        this.targetSelector.addGoal(3, new HurtByTargetGoal(this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(4, new NearestAttackableTargetGoal<Player>(this, Player.class, 10, true, false, this::isAngryAt));
        this.targetSelector.addGoal(6, new NonTameRandomTargetGoal<Turtle>(this, Turtle.class, false, Turtle.BABY_ON_LAND_SELECTOR));
        this.targetSelector.addGoal(7, new NearestAttackableTargetGoal<AbstractSkeleton>((Mob)this, AbstractSkeleton.class, false));
        this.targetSelector.addGoal(8, new ResetUniversalAngerTargetGoal<Wolf>(this, true));
    }

    public ResourceLocation getTexture() {
        WolfVariant wolfVariant = this.getVariant().value();
        if (this.isTame()) {
            return wolfVariant.assetInfo().tame().texturePath();
        }
        return this.isAngry() ? wolfVariant.assetInfo().angry().texturePath() : wolfVariant.assetInfo().wild().texturePath();
    }

    public Holder<WolfVariant> getVariant() {
        return this.entityData.get(DATA_VARIANT_ID);
    }

    public void setVariant(Holder<WolfVariant> variant) {
        this.entityData.set(DATA_VARIANT_ID, variant);
    }

    public Holder<WolfSoundVariant> getSoundVariant() {
        return this.entityData.get(DATA_SOUND_VARIANT_ID);
    }

    public void setSoundVariant(Holder<WolfSoundVariant> soundVariant) {
        this.entityData.set(DATA_SOUND_VARIANT_ID, soundVariant);
    }

    @Override
    @Nullable
    public <T> T get(DataComponentType<? extends T> component) {
        if (component == DataComponents.WOLF_VARIANT) {
            return Wolf.castComponentValue(component, this.getVariant());
        }
        if (component == DataComponents.WOLF_SOUND_VARIANT) {
            return Wolf.castComponentValue(component, this.getSoundVariant());
        }
        return component == DataComponents.WOLF_COLLAR ? Wolf.castComponentValue(component, this.getCollarColor()) : super.get(component);
    }

    @Override
    protected void applyImplicitComponents(DataComponentGetter componentGetter) {
        this.applyImplicitComponentIfPresent(componentGetter, DataComponents.WOLF_VARIANT);
        this.applyImplicitComponentIfPresent(componentGetter, DataComponents.WOLF_SOUND_VARIANT);
        this.applyImplicitComponentIfPresent(componentGetter, DataComponents.WOLF_COLLAR);
        super.applyImplicitComponents(componentGetter);
    }

    @Override
    protected <T> boolean applyImplicitComponent(DataComponentType<T> component, T value) {
        if (component == DataComponents.WOLF_VARIANT) {
            this.setVariant(Wolf.castComponentValue(DataComponents.WOLF_VARIANT, value));
            return true;
        }
        if (component == DataComponents.WOLF_SOUND_VARIANT) {
            this.setSoundVariant(Wolf.castComponentValue(DataComponents.WOLF_SOUND_VARIANT, value));
            return true;
        }
        if (component == DataComponents.WOLF_COLLAR) {
            this.setCollarColor(Wolf.castComponentValue(DataComponents.WOLF_COLLAR, value));
            return true;
        }
        return super.applyImplicitComponent(component, value);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createAnimalAttributes().add(Attributes.MOVEMENT_SPEED, 0.3f).add(Attributes.MAX_HEALTH, 8.0).add(Attributes.ATTACK_DAMAGE, 4.0);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        HolderLookup.RegistryLookup registry = this.registryAccess().lookupOrThrow(Registries.WOLF_SOUND_VARIANT);
        builder.define(DATA_VARIANT_ID, VariantUtils.getDefaultOrAny(this.registryAccess(), WolfVariants.DEFAULT));
        builder.define(DATA_SOUND_VARIANT_ID, (Holder)registry.get(WolfSoundVariants.CLASSIC).or(((Registry)registry)::getAny).orElseThrow());
        builder.define(DATA_INTERESTED_ID, false);
        builder.define(DATA_COLLAR_COLOR, DEFAULT_COLLAR_COLOR.getId());
        builder.define(DATA_REMAINING_ANGER_TIME, 0);
    }

    @Override
    protected void playStepSound(BlockPos pos, BlockState state) {
        this.playSound(SoundEvents.WOLF_STEP, 0.15f, 1.0f);
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput output) {
        super.addAdditionalSaveData(output);
        output.store("CollarColor", DyeColor.LEGACY_ID_CODEC, this.getCollarColor());
        output.putBoolean("Purpur.IsRabid", this.isRabid);
        VariantUtils.writeVariant(output, this.getVariant());
        this.addPersistentAngerSaveData(output);
        this.getSoundVariant().unwrapKey().ifPresent(resourceKey -> output.store("sound_variant", ResourceKey.codec(Registries.WOLF_SOUND_VARIANT), resourceKey));
    }

    @Override
    protected void readAdditionalSaveData(ValueInput input) {
        super.readAdditionalSaveData(input);
        VariantUtils.readVariant(input, Registries.WOLF_VARIANT).ifPresent(this::setVariant);
        this.setCollarColor(input.read("CollarColor", DyeColor.LEGACY_ID_CODEC).orElse(DEFAULT_COLLAR_COLOR));
        this.isRabid = input.getBooleanOr("Purpur.IsRabid", false);
        this.updatePathfinders(false);
        this.readPersistentAngerSaveData(this.level(), input);
        input.read("sound_variant", ResourceKey.codec(Registries.WOLF_SOUND_VARIANT)).flatMap(resourceKey -> this.registryAccess().lookupOrThrow(Registries.WOLF_SOUND_VARIANT).get((ResourceKey)resourceKey)).ifPresent(this::setSoundVariant);
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, EntitySpawnReason spawnReason, @Nullable SpawnGroupData spawnGroupData) {
        if (spawnGroupData instanceof WolfPackData) {
            WolfPackData wolfPackData = (WolfPackData)spawnGroupData;
            this.setVariant(wolfPackData.type);
        } else {
            Optional optional = VariantUtils.selectVariantToSpawn(SpawnContext.create(level, this.blockPosition()), Registries.WOLF_VARIANT);
            if (optional.isPresent()) {
                this.setVariant(optional.get());
                spawnGroupData = new WolfPackData(optional.get());
            }
        }
        this.setSoundVariant(WolfSoundVariants.pickRandomSoundVariant(this.registryAccess(), level.getRandom()));
        this.isRabid = level.getLevel().purpurConfig.wolfNaturalRabid > 0.0 && this.random.nextDouble() <= level.getLevel().purpurConfig.wolfNaturalRabid;
        this.updatePathfinders(false);
        return super.finalizeSpawn(level, difficulty, spawnReason, spawnGroupData);
    }

    @Override
    public SoundEvent getAmbientSound() {
        if (this.isAngry()) {
            return this.getSoundVariant().value().growlSound().value();
        }
        if (this.random.nextInt(3) == 0) {
            return this.isTame() && this.getHealth() < 20.0f ? this.getSoundVariant().value().whineSound().value() : this.getSoundVariant().value().pantSound().value();
        }
        return this.getSoundVariant().value().ambientSound().value();
    }

    @Override
    public SoundEvent getHurtSound(DamageSource damageSource) {
        return this.canArmorAbsorb(damageSource) ? SoundEvents.WOLF_ARMOR_DAMAGE : this.getSoundVariant().value().hurtSound().value();
    }

    @Override
    public SoundEvent getDeathSound() {
        return this.getSoundVariant().value().deathSound().value();
    }

    @Override
    public float getSoundVolume() {
        return 0.4f;
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide() && this.isWet && !this.isShaking && !this.isPathFinding() && this.onGround()) {
            this.isShaking = true;
            this.shakeAnim = 0.0f;
            this.shakeAnimO = 0.0f;
            this.level().broadcastEntityEvent(this, (byte)8);
        }
        if (!this.level().isClientSide()) {
            this.updatePersistentAnger((ServerLevel)this.level(), true);
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.isAlive()) {
            if (this.age % 300 == 0 && this.isRabid()) {
                this.addEffect(new MobEffectInstance(MobEffects.NAUSEA, 400));
            }
            this.interestedAngleO = this.interestedAngle;
            this.interestedAngle = this.isInterested() ? (this.interestedAngle += (1.0f - this.interestedAngle) * 0.4f) : (this.interestedAngle += (0.0f - this.interestedAngle) * 0.4f);
            if (this.isInWaterOrRain()) {
                this.isWet = true;
                if (this.isShaking && !this.level().isClientSide()) {
                    this.level().broadcastEntityEvent(this, (byte)56);
                    this.cancelShake();
                }
            } else if ((this.isWet || this.isShaking) && this.isShaking) {
                if (this.shakeAnim == 0.0f) {
                    this.playSound(SoundEvents.WOLF_SHAKE, this.getSoundVolume(), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
                    this.gameEvent(GameEvent.ENTITY_ACTION);
                }
                this.shakeAnimO = this.shakeAnim;
                this.shakeAnim += 0.05f;
                if (this.shakeAnimO >= 2.0f) {
                    this.isWet = false;
                    this.isShaking = false;
                    this.shakeAnimO = 0.0f;
                    this.shakeAnim = 0.0f;
                }
                if (this.shakeAnim > 0.4f) {
                    float f = (float)this.getY();
                    int i = (int)(Mth.sin((this.shakeAnim - 0.4f) * (float)Math.PI) * 7.0f);
                    Vec3 deltaMovement = this.getDeltaMovement();
                    for (int i1 = 0; i1 < i; ++i1) {
                        float f1 = (this.random.nextFloat() * 2.0f - 1.0f) * this.getBbWidth() * 0.5f;
                        float f2 = (this.random.nextFloat() * 2.0f - 1.0f) * this.getBbWidth() * 0.5f;
                        this.level().addParticle(ParticleTypes.SPLASH, this.getX() + (double)f1, f + 0.8f, this.getZ() + (double)f2, deltaMovement.x, deltaMovement.y, deltaMovement.z);
                    }
                }
            }
        }
    }

    private void cancelShake() {
        this.isShaking = false;
        this.shakeAnim = 0.0f;
        this.shakeAnimO = 0.0f;
    }

    @Override
    public void die(DamageSource damageSource) {
        this.isWet = false;
        this.isShaking = false;
        this.shakeAnimO = 0.0f;
        this.shakeAnim = 0.0f;
        super.die(damageSource);
    }

    public float getWetShade(float partialTick) {
        return !this.isWet ? 1.0f : Math.min(0.75f + Mth.lerp(partialTick, this.shakeAnimO, this.shakeAnim) / 2.0f * 0.25f, 1.0f);
    }

    public float getShakeAnim(float partialTick) {
        return Mth.lerp(partialTick, this.shakeAnimO, this.shakeAnim);
    }

    public float getHeadRollAngle(float partialTick) {
        return Mth.lerp(partialTick, this.interestedAngleO, this.interestedAngle) * 0.15f * (float)Math.PI;
    }

    @Override
    public int getMaxHeadXRot() {
        return this.isInSittingPose() ? 20 : super.getMaxHeadXRot();
    }

    @Override
    public boolean hurtServer(ServerLevel level, DamageSource damageSource, float amount) {
        if (this.isInvulnerableTo(level, damageSource)) {
            return false;
        }
        if (!super.hurtServer(level, damageSource, amount)) {
            return false;
        }
        this.setOrderedToSit(false);
        return true;
    }

    @Override
    public boolean actuallyHurt(ServerLevel level, DamageSource damageSource, float amount, EntityDamageEvent event) {
        if (!this.canArmorAbsorb(damageSource)) {
            return super.actuallyHurt(level, damageSource, amount, event);
        }
        if (event.isCancelled()) {
            return false;
        }
        ItemStack bodyArmorItem = this.getBodyArmorItem();
        int damageValue = bodyArmorItem.getDamageValue();
        int maxDamage = bodyArmorItem.getMaxDamage();
        bodyArmorItem.hurtAndBreak(Mth.ceil(amount), (LivingEntity)this, EquipmentSlot.BODY);
        if (Crackiness.WOLF_ARMOR.byDamage(damageValue, maxDamage) != Crackiness.WOLF_ARMOR.byDamage(this.getBodyArmorItem())) {
            this.playSound(SoundEvents.WOLF_ARMOR_CRACK);
            level.sendParticles(new ItemParticleOption(ParticleTypes.ITEM, Items.ARMADILLO_SCUTE.getDefaultInstance()), this.getX(), this.getY() + 1.0, this.getZ(), 20, 0.2, 0.1, 0.2, 0.1);
        }
        return true;
    }

    private boolean canArmorAbsorb(DamageSource damageSource) {
        return this.getBodyArmorItem().is(Items.WOLF_ARMOR) && !damageSource.is(DamageTypeTags.BYPASSES_WOLF_ARMOR);
    }

    @Override
    protected void applyTamingSideEffects() {
        if (this.isTame()) {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(40.0);
            this.setHealth(this.getMaxHealth());
        } else {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(8.0);
        }
    }

    @Override
    protected void hurtArmor(DamageSource damageSource, float damageAmount) {
        this.doHurtEquipment(damageSource, damageAmount, EquipmentSlot.BODY);
    }

    @Override
    protected boolean canShearEquipment(Player player) {
        return this.isOwnedBy(player);
    }

    @Override
    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        block17: {
            ItemStack itemInHand;
            block14: {
                DyeItem dyeItem;
                block16: {
                    block15: {
                        itemInHand = player.getItemInHand(hand);
                        Item item = itemInHand.getItem();
                        if (!this.isTame()) break block14;
                        if (this.isFood(itemInHand) && this.getHealth() < this.getMaxHealth()) {
                            this.usePlayerItem(player, hand, itemInHand);
                            FoodProperties foodProperties = itemInHand.get(DataComponents.FOOD);
                            float f = foodProperties != null ? (float)foodProperties.nutrition() : 1.0f;
                            this.heal(2.0f * f, EntityRegainHealthEvent.RegainReason.EATING);
                            return InteractionResult.SUCCESS;
                        }
                        if (!(item instanceof DyeItem)) break block15;
                        dyeItem = (DyeItem)item;
                        if (this.isOwnedBy(player)) break block16;
                    }
                    if (this.isEquippableInSlot(itemInHand, EquipmentSlot.BODY) && !this.isWearingBodyArmor() && this.isOwnedBy(player) && !this.isBaby()) {
                        this.setBodyArmorItem(itemInHand.copyWithCount(1));
                        itemInHand.consume(1, player);
                        return InteractionResult.SUCCESS;
                    }
                    if (this.isInSittingPose() && this.isWearingBodyArmor() && this.isOwnedBy(player) && this.getBodyArmorItem().isDamaged() && this.getBodyArmorItem().isValidRepairItem(itemInHand)) {
                        itemInHand.shrink(1);
                        this.playSound(SoundEvents.WOLF_ARMOR_REPAIR);
                        ItemStack bodyArmorItem = this.getBodyArmorItem();
                        int i = (int)((float)bodyArmorItem.getMaxDamage() * 0.125f);
                        bodyArmorItem.setDamageValue(Math.max(0, bodyArmorItem.getDamageValue() - i));
                        return InteractionResult.SUCCESS;
                    }
                    InteractionResult interactionResult = super.mobInteract(player, hand);
                    if (!interactionResult.consumesAction() && this.isOwnedBy(player)) {
                        this.setOrderedToSit(!this.isOrderedToSit());
                        this.jumping = false;
                        this.navigation.stop();
                        this.setTarget(null, EntityTargetEvent.TargetReason.FORGOT_TARGET);
                        return InteractionResult.SUCCESS.withoutItem();
                    }
                    return interactionResult;
                }
                DyeColor dyeColor = dyeItem.getDyeColor();
                if (dyeColor != this.getCollarColor()) {
                    EntityDyeEvent event = new EntityDyeEvent((Entity)this.getBukkitEntity(), org.bukkit.DyeColor.getByWoolData((byte)((byte)dyeColor.getId())), (org.bukkit.entity.Player)player.getBukkitEntity());
                    if (!event.callEvent()) {
                        return InteractionResult.FAIL;
                    }
                    dyeColor = DyeColor.byId(event.getColor().getWoolData());
                    this.setCollarColor(dyeColor);
                    itemInHand.consume(1, player);
                    return InteractionResult.SUCCESS;
                }
                break block17;
            }
            if (!this.level().isClientSide() && itemInHand.is(Items.BONE) && !this.isAngry()) {
                itemInHand.consume(1, player);
                this.tryToTame(player);
                return InteractionResult.SUCCESS_SERVER;
            }
            if (this.level().purpurConfig.wolfMilkCuresRabies && itemInHand.getItem() == Items.MILK_BUCKET && this.isRabid()) {
                if (!player.isCreative()) {
                    player.setItemInHand(hand, new ItemStack(Items.BUCKET));
                }
                this.setRabid(false);
                for (int i = 0; i < 10; ++i) {
                    ((ServerLevel)this.level()).sendParticlesSource(((ServerLevel)this.level()).players(), null, ParticleTypes.HAPPY_VILLAGER, false, true, this.getX() + (double)this.random.nextFloat(), this.getY() + (double)this.random.nextFloat() * 1.5, this.getZ() + (double)this.random.nextFloat(), 1, this.random.nextGaussian() * 0.05, this.random.nextGaussian() * 0.05, this.random.nextGaussian() * 0.05, 0.0);
                }
                return InteractionResult.SUCCESS_SERVER;
            }
        }
        return super.mobInteract(player, hand);
    }

    private void tryToTame(Player player) {
        if ((this.level().purpurConfig.alwaysTameInCreative && player.hasInfiniteMaterials() || this.random.nextInt(3) == 0) && !CraftEventFactory.callEntityTameEvent(this, player).isCancelled()) {
            this.tame(player);
            this.navigation.stop();
            this.setTarget(null);
            this.setOrderedToSit(true);
            this.level().broadcastEntityEvent(this, (byte)7);
        } else {
            this.level().broadcastEntityEvent(this, (byte)6);
        }
    }

    @Override
    public void handleEntityEvent(byte id) {
        if (id == 8) {
            this.isShaking = true;
            this.shakeAnim = 0.0f;
            this.shakeAnimO = 0.0f;
        } else if (id == 56) {
            this.cancelShake();
        } else {
            super.handleEntityEvent(id);
        }
    }

    public float getTailAngle() {
        if (this.isAngry()) {
            return 1.5393804f;
        }
        if (this.isTame()) {
            float maxHealth = this.getMaxHealth();
            float f = (maxHealth - this.getHealth()) / maxHealth;
            return (0.55f - f * 0.4f) * (float)Math.PI;
        }
        return 0.62831855f;
    }

    @Override
    public boolean isFood(ItemStack stack) {
        return stack.is(ItemTags.WOLF_FOOD);
    }

    @Override
    public int getMaxSpawnClusterSize() {
        return 8;
    }

    @Override
    public int getRemainingPersistentAngerTime() {
        return this.entityData.get(DATA_REMAINING_ANGER_TIME);
    }

    @Override
    public void setRemainingPersistentAngerTime(int remainingPersistentAngerTime) {
        this.entityData.set(DATA_REMAINING_ANGER_TIME, remainingPersistentAngerTime);
    }

    @Override
    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(PERSISTENT_ANGER_TIME.sample(this.random));
    }

    @Override
    @Nullable
    public UUID getPersistentAngerTarget() {
        return this.persistentAngerTarget;
    }

    @Override
    public void setPersistentAngerTarget(@Nullable UUID persistentAngerTarget) {
        this.persistentAngerTarget = persistentAngerTarget;
    }

    public DyeColor getCollarColor() {
        return DyeColor.byId(this.entityData.get(DATA_COLLAR_COLOR));
    }

    public void setCollarColor(DyeColor color) {
        this.entityData.set(DATA_COLLAR_COLOR, color.getId());
    }

    @Override
    @Nullable
    public Wolf getBreedOffspring(ServerLevel level, AgeableMob partner) {
        Wolf wolf = EntityType.WOLF.create(level, EntitySpawnReason.BREEDING);
        if (wolf != null && partner instanceof Wolf) {
            Wolf wolf1 = (Wolf)partner;
            if (this.random.nextBoolean()) {
                wolf.setVariant(this.getVariant());
            } else {
                wolf.setVariant(wolf1.getVariant());
            }
            if (this.isTame()) {
                wolf.setOwnerReference(this.getOwnerReference());
                wolf.setTame(true, true);
                DyeColor collarColor = this.getCollarColor();
                DyeColor collarColor1 = wolf1.getCollarColor();
                wolf.setCollarColor(DyeColor.getMixedColor(level, collarColor, collarColor1));
            }
            wolf.setSoundVariant(WolfSoundVariants.pickRandomSoundVariant(this.registryAccess(), this.random));
        }
        return wolf;
    }

    public void setIsInterested(boolean isInterested) {
        this.entityData.set(DATA_INTERESTED_ID, isInterested);
    }

    @Override
    public boolean canMate(Animal otherAnimal) {
        Wolf wolf;
        return otherAnimal != this && this.isTame() && otherAnimal instanceof Wolf && (wolf = (Wolf)otherAnimal).isTame() && !wolf.isInSittingPose() && this.isInLove() && wolf.isInLove();
    }

    public boolean isInterested() {
        return this.entityData.get(DATA_INTERESTED_ID);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean wantsToAttack(LivingEntity target, LivingEntity owner) {
        if (target instanceof Creeper) return false;
        if (target instanceof Ghast) return false;
        if (target instanceof ArmorStand) {
            return false;
        }
        if (target instanceof Wolf) {
            Wolf wolf = (Wolf)target;
            if (!wolf.isTame()) return true;
            if (wolf.getOwner() == owner) return false;
            return true;
        }
        if (target instanceof Player) {
            Player player = (Player)target;
            if (owner instanceof Player) {
                Player player1 = (Player)owner;
                if (!player1.canHarmPlayer(player)) return false;
            }
        }
        if (target instanceof AbstractHorse) {
            AbstractHorse abstractHorse = (AbstractHorse)target;
            if (abstractHorse.isTamed()) return false;
        }
        if (!(target instanceof TamableAnimal)) return true;
        TamableAnimal tamableAnimal = (TamableAnimal)target;
        if (tamableAnimal.isTame()) return false;
        return true;
    }

    @Override
    public boolean canBeLeashed() {
        return !this.isAngry();
    }

    @Override
    public Vec3 getLeashOffset() {
        return new Vec3(0.0, 0.6f * this.getEyeHeight(), this.getBbWidth() * 0.4f);
    }

    public static boolean checkWolfSpawnRules(EntityType<Wolf> entityType, LevelAccessor level, EntitySpawnReason spawnReason, BlockPos pos, RandomSource random) {
        return level.getBlockState(pos.below()).is(BlockTags.WOLVES_SPAWNABLE_ON) && Wolf.isBrightEnoughToSpawn(level, pos);
    }

    class WolfAvoidEntityGoal<T extends LivingEntity>
    extends AvoidEntityGoal<T> {
        private final Wolf wolf;

        public WolfAvoidEntityGoal(Wolf wolf, Class<T> avoidClass, float maxDistance, double walkSpeedModifier, double sprintSpeedModifier) {
            super(wolf, avoidClass, maxDistance, walkSpeedModifier, sprintSpeedModifier);
            this.wolf = wolf;
        }

        @Override
        public boolean canUse() {
            return super.canUse() && this.toAvoid instanceof Llama && !this.wolf.isTame() && this.avoidLlama((Llama)this.toAvoid);
        }

        private boolean avoidLlama(Llama llama) {
            return llama.getStrength() >= Wolf.this.random.nextInt(5);
        }

        @Override
        public void start() {
            Wolf.this.setTarget(null);
            super.start();
        }

        @Override
        public void tick() {
            Wolf.this.setTarget(null);
            super.tick();
        }
    }

    private static final class AvoidRabidWolfGoal
    extends AvoidEntityGoal<Wolf> {
        private final Wolf wolf;

        public AvoidRabidWolfGoal(Wolf wolf, float distance, double minSpeed, double maxSpeed) {
            super(wolf, Wolf.class, distance, minSpeed, maxSpeed);
            this.wolf = wolf;
        }

        @Override
        public boolean canUse() {
            return super.canUse() && !this.wolf.isRabid() && this.toAvoid != null && ((Wolf)this.toAvoid).isRabid();
        }

        @Override
        public void start() {
            this.wolf.setTarget(null);
            super.start();
        }

        @Override
        public void tick() {
            this.wolf.setTarget(null);
            super.tick();
        }
    }

    public static class WolfPackData
    extends AgeableMob.AgeableMobGroupData {
        public final Holder<WolfVariant> type;

        public WolfPackData(Holder<WolfVariant> type) {
            super(false);
            this.type = type;
        }
    }
}

