/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.wither;

import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundLevelEventPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.WitherSkull;
import net.minecraft.world.entity.projectile.windcharge.WindCharge;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;
import org.purpurmc.purpur.controller.FlyingWithSpacebarMoveControllerWASD;
import org.purpurmc.purpur.entity.ai.HasRider;

public class WitherBoss
extends Monster
implements RangedAttackMob {
    private static final EntityDataAccessor<Integer> DATA_TARGET_A = SynchedEntityData.defineId(WitherBoss.class, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_TARGET_B = SynchedEntityData.defineId(WitherBoss.class, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_TARGET_C = SynchedEntityData.defineId(WitherBoss.class, EntityDataSerializers.INT);
    private static final List<EntityDataAccessor<Integer>> DATA_TARGETS = ImmutableList.of(DATA_TARGET_A, DATA_TARGET_B, DATA_TARGET_C);
    private static final EntityDataAccessor<Integer> DATA_ID_INV = SynchedEntityData.defineId(WitherBoss.class, EntityDataSerializers.INT);
    private static final int INVULNERABLE_TICKS = 220;
    private static final int DEFAULT_INVULNERABLE_TICKS = 0;
    private final float[] xRotHeads = new float[2];
    private final float[] yRotHeads = new float[2];
    private final float[] xRotOHeads = new float[2];
    private final float[] yRotOHeads = new float[2];
    private final int[] nextHeadUpdate = new int[2];
    private final int[] idleHeadUpdates = new int[2];
    private int destroyBlocksTick;
    private int shootCooldown = 0;
    private boolean canPortal = false;
    public final ServerBossEvent bossEvent = (ServerBossEvent)new ServerBossEvent(this.getDisplayName(), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.PROGRESS).setDarkenScreen(true);
    private static final TargetingConditions.Selector LIVING_ENTITY_SELECTOR = (entity, level) -> !entity.getType().is(EntityTypeTags.WITHER_FRIENDS) && entity.attackable();
    private static final TargetingConditions TARGETING_CONDITIONS = TargetingConditions.forCombat().range(20.0).selector(LIVING_ENTITY_SELECTOR);
    @Nullable
    private UUID summoner;
    private FlyingWithSpacebarMoveControllerWASD purpurController = new FlyingWithSpacebarMoveControllerWASD((Mob)this, 0.1f);

    public WitherBoss(EntityType<? extends WitherBoss> type, Level level) {
        super((EntityType<? extends Monster>)type, level);
        this.moveControl = new FlyingMoveControl(this, 10, false){

            @Override
            public void tick() {
                if (this.mob.getRider() != null && this.mob.isControllable()) {
                    WitherBoss.this.purpurController.purpurTick(this.mob.getRider());
                } else {
                    super.tick();
                }
            }
        };
        this.moveControl = new FlyingMoveControl(this, 10, false);
        this.setHealth(this.getMaxHealth());
        this.xpReward = 50;
    }

    @Nullable
    public UUID getSummoner() {
        return this.summoner;
    }

    public void setSummoner(@Nullable UUID summoner) {
        this.summoner = summoner;
    }

    @Override
    public boolean isRidable() {
        return this.level().purpurConfig.witherRidable;
    }

    @Override
    public boolean dismountsUnderwater() {
        return this.level().purpurConfig.useDismountsUnderwaterTag ? super.dismountsUnderwater() : !this.level().purpurConfig.witherRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.level().purpurConfig.witherControllable;
    }

    @Override
    public double getMaxY() {
        return this.level().purpurConfig.witherMaxY;
    }

    @Override
    public void travel(Vec3 vec3) {
        super.travel(vec3);
        if (this.getRider() != null && this.isControllable() && !this.onGround) {
            float speed = (float)this.getAttributeValue(Attributes.FLYING_SPEED) * 5.0f;
            this.setSpeed(speed);
            Vec3 mot = this.getDeltaMovement();
            this.move(MoverType.SELF, mot.multiply(speed, 0.5, speed));
            this.setDeltaMovement(mot.scale(0.9));
        }
    }

    @Override
    public void onMount(Player rider) {
        super.onMount(rider);
        this.entityData.set(DATA_TARGETS.get(0), 0);
        this.entityData.set(DATA_TARGETS.get(1), 0);
        this.entityData.set(DATA_TARGETS.get(2), 0);
        this.getNavigation().stop();
        this.shootCooldown = 20;
    }

    @Override
    public boolean onClick(InteractionHand hand) {
        int[] nArray;
        Player player = this.getRider();
        if (hand == InteractionHand.MAIN_HAND) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 1;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 2;
        }
        return this.shoot(player, nArray);
    }

    public boolean shoot(@Nullable Player rider, int[] heads) {
        Vec3 loc;
        if (this.shootCooldown > 0) {
            return false;
        }
        this.shootCooldown = 20;
        if (rider == null) {
            return false;
        }
        CraftHumanEntity player = rider.getBukkitEntity();
        if (!player.hasPermission("allow.special.wither")) {
            return false;
        }
        HitResult rayTrace = this.getRayTrace(120, ClipContext.Fluid.NONE);
        if (rayTrace == null) {
            return false;
        }
        if (rayTrace.getType() == HitResult.Type.BLOCK) {
            BlockPos pos = ((BlockHitResult)rayTrace).getBlockPos();
            loc = new Vec3((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
        } else if (rayTrace.getType() == HitResult.Type.ENTITY) {
            Entity target = ((EntityHitResult)rayTrace).getEntity();
            loc = new Vec3(target.getX(), target.getY() + (double)(target.getEyeHeight() / 2.0f), target.getZ());
        } else {
            Block block = player.getTargetBlock(null, 120);
            loc = new Vec3((double)block.getX() + 0.5, (double)block.getY() + 0.5, (double)block.getZ() + 0.5);
        }
        for (int head : heads) {
            this.shoot(head, loc.x(), loc.y(), loc.z(), rider);
        }
        return true;
    }

    public void shoot(int head, double x, double y, double z, Player rider) {
        this.level().levelEvent(null, 1024, this.blockPosition(), 0);
        double headX = this.getHeadX(head);
        double headY = this.getHeadY(head);
        double headZ = this.getHeadZ(head);
        Vec3 vec3d = new Vec3(x - headX, y - headY, z - headZ);
        WitherSkull skull = new WitherSkull(this.level(), this, vec3d.normalize());
        skull.setPosRaw(headX, headY, headZ);
        this.level().addFreshEntity(skull);
    }

    @Override
    public void initAttributes() {
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(this.level().purpurConfig.witherMaxHealth);
        this.getAttribute(Attributes.SCALE).setBaseValue(this.level().purpurConfig.witherScale);
    }

    @Override
    public boolean isSensitiveToWater() {
        return this.level().purpurConfig.witherTakeDamageFromWater;
    }

    @Override
    protected boolean isAlwaysExperienceDropper() {
        return this.level().purpurConfig.witherAlwaysDropExp;
    }

    @Override
    protected PathNavigation createNavigation(Level level) {
        FlyingPathNavigation flyingPathNavigation = new FlyingPathNavigation(this, level);
        flyingPathNavigation.setCanOpenDoors(false);
        flyingPathNavigation.setCanFloat(true);
        return flyingPathNavigation;
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(0, new HasRider(this));
        this.goalSelector.addGoal(0, new WitherDoNothingGoal());
        this.goalSelector.addGoal(2, new RangedAttackGoal(this, 1.0, 40, 20.0f));
        this.goalSelector.addGoal(5, new WaterAvoidingRandomFlyingGoal(this, 1.0));
        this.goalSelector.addGoal(6, new LookAtPlayerGoal(this, Player.class, 8.0f));
        this.goalSelector.addGoal(7, new RandomLookAroundGoal(this));
        this.targetSelector.addGoal(0, new HasRider(this));
        this.targetSelector.addGoal(1, new HurtByTargetGoal(this, new Class[0]));
        this.targetSelector.addGoal(2, new NearestAttackableTargetGoal<LivingEntity>(this, LivingEntity.class, 0, false, false, LIVING_ENTITY_SELECTOR));
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_TARGET_A, 0);
        builder.define(DATA_TARGET_B, 0);
        builder.define(DATA_TARGET_C, 0);
        builder.define(DATA_ID_INV, 0);
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput output) {
        super.addAdditionalSaveData(output);
        output.putInt("Invul", this.getInvulnerableTicks());
        output.storeNullable("Purpur.Summoner", UUIDUtil.CODEC, this.getSummoner());
    }

    @Override
    protected void readAdditionalSaveData(ValueInput input) {
        super.readAdditionalSaveData(input);
        this.setInvulnerableTicks(input.getIntOr("Invul", 0));
        if (this.hasCustomName()) {
            this.bossEvent.setName(this.getDisplayName());
        }
        this.setSummoner(input.read("Purpur.Summoner", UUIDUtil.CODEC).orElse(null));
    }

    @Override
    public void setCustomName(@Nullable Component name) {
        super.setCustomName(name);
        this.bossEvent.setName(this.getDisplayName());
    }

    @Override
    public SoundEvent getAmbientSound() {
        return SoundEvents.WITHER_AMBIENT;
    }

    @Override
    public SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.WITHER_HURT;
    }

    @Override
    public SoundEvent getDeathSound() {
        return SoundEvents.WITHER_DEATH;
    }

    @Override
    public void aiStep() {
        int i;
        Entity entity;
        Vec3 vec3 = this.getDeltaMovement().multiply(1.0, 0.6, 1.0);
        if (!this.level().isClientSide() && this.getAlternativeTarget(0) > 0 && (entity = this.level().getEntity(this.getAlternativeTarget(0))) != null) {
            double d = vec3.y;
            if (this.getY() < entity.getY() || !this.isPowered() && this.getY() < entity.getY() + 5.0) {
                d = Math.max(0.0, d);
                d += 0.3 - d * (double)0.6f;
            }
            vec3 = new Vec3(vec3.x, d, vec3.z);
            Vec3 vec31 = new Vec3(entity.getX() - this.getX(), 0.0, entity.getZ() - this.getZ());
            if (vec31.horizontalDistanceSqr() > 9.0) {
                Vec3 vec32 = vec31.normalize();
                vec3 = vec3.add(vec32.x * 0.3 - vec3.x * 0.6, 0.0, vec32.z * 0.3 - vec3.z * 0.6);
            }
        }
        this.setDeltaMovement(vec3);
        if (vec3.horizontalDistanceSqr() > 0.05) {
            this.setYRot((float)Mth.atan2(vec3.z, vec3.x) * 57.295776f - 90.0f);
        }
        super.aiStep();
        for (i = 0; i < 2; ++i) {
            this.yRotOHeads[i] = this.yRotHeads[i];
            this.xRotOHeads[i] = this.xRotHeads[i];
        }
        for (i = 0; i < 2; ++i) {
            int alternativeTarget = this.getAlternativeTarget(i + 1);
            Entity entity1 = null;
            if (alternativeTarget > 0) {
                entity1 = this.level().getEntity(alternativeTarget);
            }
            if (entity1 != null) {
                double headX = this.getHeadX(i + 1);
                double headY = this.getHeadY(i + 1);
                double headZ = this.getHeadZ(i + 1);
                double d1 = entity1.getX() - headX;
                double d2 = entity1.getEyeY() - headY;
                double d3 = entity1.getZ() - headZ;
                double squareRoot = Math.sqrt(d1 * d1 + d3 * d3);
                float f = (float)(Mth.atan2(d3, d1) * 180.0 / 3.1415927410125732) - 90.0f;
                float f1 = (float)(-(Mth.atan2(d2, squareRoot) * 180.0 / 3.1415927410125732));
                this.xRotHeads[i] = this.rotlerp(this.xRotHeads[i], f1, 40.0f);
                this.yRotHeads[i] = this.rotlerp(this.yRotHeads[i], f, 10.0f);
                continue;
            }
            this.yRotHeads[i] = this.rotlerp(this.yRotHeads[i], this.yBodyRot, 10.0f);
        }
        boolean isPowered = this.isPowered();
        for (int alternativeTargetx = 0; alternativeTargetx < 3; ++alternativeTargetx) {
            double headX1 = this.getHeadX(alternativeTargetx);
            double headY1 = this.getHeadY(alternativeTargetx);
            double headZ1 = this.getHeadZ(alternativeTargetx);
            float f2 = 0.3f * this.getScale();
            this.level().addParticle(ParticleTypes.SMOKE, headX1 + this.random.nextGaussian() * (double)f2, headY1 + this.random.nextGaussian() * (double)f2, headZ1 + this.random.nextGaussian() * (double)f2, 0.0, 0.0, 0.0);
            if (!isPowered || this.level().random.nextInt(4) != 0) continue;
            this.level().addParticle(ColorParticleOption.create(ParticleTypes.ENTITY_EFFECT, 0.7f, 0.7f, 0.5f), headX1 + this.random.nextGaussian() * (double)f2, headY1 + this.random.nextGaussian() * (double)f2, headZ1 + this.random.nextGaussian() * (double)f2, 0.0, 0.0, 0.0);
        }
        if (this.getInvulnerableTicks() > 0) {
            float f3 = 3.3f * this.getScale();
            for (int i1 = 0; i1 < 3; ++i1) {
                this.level().addParticle(ColorParticleOption.create(ParticleTypes.ENTITY_EFFECT, 0.7f, 0.7f, 0.9f), this.getX() + this.random.nextGaussian(), this.getY() + (double)(this.random.nextFloat() * f3), this.getZ() + this.random.nextGaussian(), 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    protected void customServerAiStep(ServerLevel level) {
        if (this.getRider() != null && this.isControllable()) {
            Vec3 mot = this.getDeltaMovement();
            this.setDeltaMovement(mot.x(), mot.y() + (this.getVerticalMot() > 0.0f ? 0.07 : 0.0), mot.z());
        }
        if (this.shootCooldown > 0) {
            --this.shootCooldown;
        }
        if (this.getInvulnerableTicks() > 0) {
            int i = this.getInvulnerableTicks() - 1;
            this.bossEvent.setProgress(1.0f - (float)i / 220.0f);
            if (i <= 0) {
                ExplosionPrimeEvent event = new ExplosionPrimeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), 7.0f, false);
                level.getCraftServer().getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    level.explode((Entity)this, this.getX(), this.getEyeY(), this.getZ(), event.getRadius(), event.getFire(), Level.ExplosionInteraction.MOB);
                }
                if (!this.isSilent() && level.purpurConfig.witherPlaySpawnSound) {
                    int viewDistance = level.getCraftServer().getViewDistance() * 16;
                    for (ServerPlayer player : level.getPlayersForGlobalSoundGamerule()) {
                        double deltaX = this.getX() - player.getX();
                        double deltaZ = this.getZ() - player.getZ();
                        double distanceSquared = Mth.square(deltaX) + Mth.square(deltaZ);
                        double soundRadiusSquared = level.getGlobalSoundRangeSquared(config -> config.witherSpawnSoundRadius);
                        if (!level.getGameRules().getBoolean(GameRules.RULE_GLOBAL_SOUND_EVENTS) && distanceSquared > soundRadiusSquared) continue;
                        if (distanceSquared > (double)Mth.square(viewDistance)) {
                            double deltaLength = Math.sqrt(distanceSquared);
                            double relativeX = player.getX() + deltaX / deltaLength * (double)viewDistance;
                            double relativeZ = player.getZ() + deltaZ / deltaLength * (double)viewDistance;
                            player.connection.send(new ClientboundLevelEventPacket(1023, new BlockPos((int)relativeX, (int)this.getY(), (int)relativeZ), 0, true));
                            continue;
                        }
                        player.connection.send(new ClientboundLevelEventPacket(1023, this.blockPosition(), 0, true));
                    }
                }
            }
            this.setInvulnerableTicks(i);
            if (this.tickCount % 10 == 0) {
                this.heal(this.getMaxHealth() / 30.0f, EntityRegainHealthEvent.RegainReason.WITHER_SPAWN);
            }
        } else {
            int alternativeTarget;
            super.customServerAiStep(level);
            for (int ix = 1; ix < 3; ++ix) {
                LivingEntity livingEntity1;
                if (this.tickCount < this.nextHeadUpdate[ix - 1]) continue;
                this.nextHeadUpdate[ix - 1] = this.tickCount + 10 + this.random.nextInt(10);
                if (level.getDifficulty() == Difficulty.NORMAL || level.getDifficulty() == Difficulty.HARD) {
                    int n = ix - 1;
                    int n2 = this.idleHeadUpdates[n];
                    this.idleHeadUpdates[n] = n2 + 1;
                    if (n2 > 15) {
                        float f = 10.0f;
                        float f1 = 5.0f;
                        double randomDouble = Mth.nextDouble(this.random, this.getX() - 10.0, this.getX() + 10.0);
                        double randomDouble1 = Mth.nextDouble(this.random, this.getY() - 5.0, this.getY() + 5.0);
                        double randomDouble2 = Mth.nextDouble(this.random, this.getZ() - 10.0, this.getZ() + 10.0);
                        this.performRangedAttack(ix + 1, randomDouble, randomDouble1, randomDouble2, true);
                        this.idleHeadUpdates[ix - 1] = 0;
                    }
                }
                if ((alternativeTarget = this.getAlternativeTarget(ix)) > 0) {
                    LivingEntity livingEntity = (LivingEntity)level.getEntity(alternativeTarget);
                    if (livingEntity != null && this.canAttack(livingEntity) && !(this.distanceToSqr(livingEntity) > 900.0) && this.hasLineOfSight(livingEntity)) {
                        this.performRangedAttack(ix + 1, livingEntity);
                        this.nextHeadUpdate[ix - 1] = this.tickCount + 40 + this.random.nextInt(20);
                        this.idleHeadUpdates[ix - 1] = 0;
                        continue;
                    }
                    this.setAlternativeTarget(ix, 0);
                    continue;
                }
                List<LivingEntity> nearbyEntities = level.getNearbyEntities(LivingEntity.class, TARGETING_CONDITIONS, this, this.getBoundingBox().inflate(20.0, 8.0, 20.0));
                if (nearbyEntities.isEmpty() || CraftEventFactory.callEntityTargetLivingEvent(this, livingEntity1 = nearbyEntities.get(this.random.nextInt(nearbyEntities.size())), EntityTargetEvent.TargetReason.CLOSEST_ENTITY).isCancelled()) continue;
                this.setAlternativeTarget(ix, livingEntity1.getId());
            }
            if (this.getTarget() != null) {
                this.setAlternativeTarget(0, this.getTarget().getId());
            } else {
                this.setAlternativeTarget(0, 0);
            }
            if (this.destroyBlocksTick > 0) {
                --this.destroyBlocksTick;
                if (this.destroyBlocksTick == 0 && level.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING, level.purpurConfig.witherMobGriefingOverride)) {
                    boolean flag = false;
                    alternativeTarget = Mth.floor(this.getBbWidth() / 2.0f + 1.0f);
                    int floor = Mth.floor(this.getBbHeight());
                    for (BlockPos blockPos : BlockPos.betweenClosed(this.getBlockX() - alternativeTarget, this.getBlockY(), this.getBlockZ() - alternativeTarget, this.getBlockX() + alternativeTarget, this.getBlockY() + floor, this.getBlockZ() + alternativeTarget)) {
                        BlockState blockState = level.getBlockState(blockPos);
                        if (!WitherBoss.canDestroy(blockState) || !CraftEventFactory.callEntityChangeBlockEvent(this, blockPos, blockState.getFluidState().createLegacyBlock())) continue;
                        flag = level.destroyBlock(blockPos, true, this) || flag;
                    }
                    if (flag) {
                        level.levelEvent(null, 1022, this.blockPosition(), 0);
                    }
                }
            }
            if (this.tickCount % this.level().purpurConfig.witherHealthRegenDelay == 0) {
                this.heal(this.level().purpurConfig.witherHealthRegenAmount, EntityRegainHealthEvent.RegainReason.REGEN);
            }
            this.bossEvent.setProgress(this.getHealth() / this.getMaxHealth());
        }
    }

    public static boolean canDestroy(BlockState state) {
        return !state.isAir() && !state.is(BlockTags.WITHER_IMMUNE);
    }

    public void makeInvulnerable() {
        this.setInvulnerableTicks(220);
        this.bossEvent.setProgress(0.0f);
        this.setHealth(this.getMaxHealth() / 3.0f);
    }

    @Override
    public void makeStuckInBlock(BlockState state, Vec3 motionMultiplier) {
    }

    @Override
    public void startSeenByPlayer(ServerPlayer player) {
        super.startSeenByPlayer(player);
        this.bossEvent.addPlayer(player);
    }

    @Override
    public void stopSeenByPlayer(ServerPlayer player) {
        super.stopSeenByPlayer(player);
        this.bossEvent.removePlayer(player);
    }

    private double getHeadX(int head) {
        if (head <= 0) {
            return this.getX();
        }
        float f = (this.yBodyRot + (float)(180 * (head - 1))) * ((float)Math.PI / 180);
        float cos = Mth.cos(f);
        return this.getX() + (double)cos * 1.3 * (double)this.getScale();
    }

    private double getHeadY(int head) {
        float f = head <= 0 ? 3.0f : 2.2f;
        return this.getY() + (double)(f * this.getScale());
    }

    private double getHeadZ(int head) {
        if (head <= 0) {
            return this.getZ();
        }
        float f = (this.yBodyRot + (float)(180 * (head - 1))) * ((float)Math.PI / 180);
        float sin = Mth.sin(f);
        return this.getZ() + (double)sin * 1.3 * (double)this.getScale();
    }

    private float rotlerp(float angle, float targetAngle, float max) {
        float f = Mth.wrapDegrees(targetAngle - angle);
        if (f > max) {
            f = max;
        }
        if (f < -max) {
            f = -max;
        }
        return angle + f;
    }

    private void performRangedAttack(int head, LivingEntity target) {
        this.performRangedAttack(head, target.getX(), target.getY() + (double)target.getEyeHeight() * 0.5, target.getZ(), head == 0 && this.random.nextFloat() < 0.001f);
    }

    private void performRangedAttack(int head, double x, double y, double z, boolean isDangerous) {
        if (!this.isSilent()) {
            this.level().levelEvent(null, 1024, this.blockPosition(), 0);
        }
        double headX = this.getHeadX(head);
        double headY = this.getHeadY(head);
        double headZ = this.getHeadZ(head);
        double d = x - headX;
        double d1 = y - headY;
        double d2 = z - headZ;
        Vec3 vec3 = new Vec3(d, d1, d2);
        WitherSkull witherSkull = new WitherSkull(this.level(), this, vec3.normalize());
        witherSkull.setOwner(this);
        if (isDangerous) {
            witherSkull.setDangerous(true);
        }
        witherSkull.setPos(headX, headY, headZ);
        this.level().addFreshEntity(witherSkull);
    }

    @Override
    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        this.performRangedAttack(0, target);
    }

    @Override
    public boolean hurtServer(ServerLevel level, DamageSource damageSource, float amount) {
        Entity directEntity;
        if (this.isInvulnerableTo(level, damageSource)) {
            return false;
        }
        if (damageSource.is(DamageTypeTags.WITHER_IMMUNE_TO) || damageSource.getEntity() instanceof WitherBoss) {
            return false;
        }
        if (this.getInvulnerableTicks() > 0 && !damageSource.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return false;
        }
        if (this.isPowered() && ((directEntity = damageSource.getDirectEntity()) instanceof AbstractArrow || directEntity instanceof WindCharge)) {
            return false;
        }
        directEntity = damageSource.getEntity();
        if (directEntity != null && directEntity.getType().is(EntityTypeTags.WITHER_FRIENDS)) {
            return false;
        }
        if (this.destroyBlocksTick <= 0) {
            this.destroyBlocksTick = 20;
        }
        for (int i = 0; i < this.idleHeadUpdates.length; ++i) {
            this.idleHeadUpdates[i] = this.idleHeadUpdates[i] + 3;
        }
        return super.hurtServer(level, damageSource, amount);
    }

    @Override
    protected void dropCustomDeathLoot(ServerLevel level, DamageSource damageSource, boolean recentlyHit) {
        super.dropCustomDeathLoot(level, damageSource, recentlyHit);
        ItemEntity itemEntity = this.spawnAtLocation(level, new ItemStack(Items.NETHER_STAR), Vec3.ZERO, ItemEntity::setExtendedLifetime);
        if (itemEntity != null) {
            itemEntity.setExtendedLifetime();
        }
    }

    @Override
    public void checkDespawn() {
        if (this.level().getDifficulty() == Difficulty.PEACEFUL && this.shouldDespawnInPeaceful()) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else {
            this.noActionTime = 0;
        }
    }

    @Override
    public boolean addEffect(MobEffectInstance effectInstance, @Nullable Entity entity) {
        return false;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 300.0).add(Attributes.MOVEMENT_SPEED, 0.6f).add(Attributes.FLYING_SPEED, 0.6f).add(Attributes.FOLLOW_RANGE, 40.0).add(Attributes.ARMOR, 4.0);
    }

    public float[] getHeadYRots() {
        return this.yRotHeads;
    }

    public float[] getHeadXRots() {
        return this.xRotHeads;
    }

    public int getInvulnerableTicks() {
        return this.entityData.get(DATA_ID_INV);
    }

    public void setInvulnerableTicks(int invulnerableTicks) {
        this.entityData.set(DATA_ID_INV, invulnerableTicks);
    }

    public int getAlternativeTarget(int head) {
        return this.getRider() != null && this.isControllable() ? 0 : this.entityData.get(DATA_TARGETS.get(head));
    }

    public void setAlternativeTarget(int targetOffset, int newId) {
        if (this.getRider() == null || !this.isControllable()) {
            this.entityData.set(DATA_TARGETS.get(targetOffset), newId);
        }
    }

    public boolean isPowered() {
        return this.getHealth() <= this.getMaxHealth() / 2.0f;
    }

    @Override
    protected boolean canRide(Entity entity) {
        if (this.level().purpurConfig.witherCanRideVehicles) {
            return this.boardingCooldown <= 0;
        }
        return false;
    }

    @Override
    public boolean canUsePortal(boolean allowPassengers) {
        return this.canPortal;
    }

    public void setCanTravelThroughPortals(boolean canPortal) {
        this.canPortal = canPortal;
    }

    @Override
    public boolean canBeAffected(MobEffectInstance effectInstance) {
        return (!effectInstance.is(MobEffects.WITHER) || !this.level().paperConfig().entities.mobEffects.immuneToWitherEffect.wither) && super.canBeAffected(effectInstance);
    }

    class WitherDoNothingGoal
    extends Goal {
        public WitherDoNothingGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        @Override
        public boolean canUse() {
            return WitherBoss.this.getInvulnerableTicks() > 0;
        }
    }
}

