/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.StructureTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.phys.AABB;

public class CatSpawner
implements CustomSpawner {
    private static final int TICK_DELAY = 1200;
    private int nextTick;

    @Override
    public void tick(ServerLevel level, boolean spawnEnemies) {
        --this.nextTick;
        if (this.nextTick <= 0) {
            this.nextTick = level.purpurConfig.catSpawnDelay;
            ServerPlayer randomPlayer = level.getRandomPlayer();
            if (randomPlayer != null) {
                RandomSource randomSource = level.random;
                int i = (8 + randomSource.nextInt(24)) * (randomSource.nextBoolean() ? -1 : 1);
                int i1 = (8 + randomSource.nextInt(24)) * (randomSource.nextBoolean() ? -1 : 1);
                BlockPos blockPos = randomPlayer.blockPosition().offset(i, 0, i1);
                int i2 = 10;
                if (level.hasChunksAt(blockPos.getX() - 10, blockPos.getZ() - 10, blockPos.getX() + 10, blockPos.getZ() + 10) && SpawnPlacements.isSpawnPositionOk(EntityType.CAT, level, blockPos)) {
                    if (level.isCloseToVillage(blockPos, 2)) {
                        this.spawnInVillage(level, blockPos);
                    } else if (level.structureManager().getStructureWithPieceAt(blockPos, StructureTags.CATS_SPAWN_IN).isValid()) {
                        this.spawnInHut(level, blockPos);
                    }
                }
            }
        }
    }

    private void spawnInVillage(ServerLevel level, BlockPos pos) {
        List<Cat> entitiesOfClass;
        int range = level.purpurConfig.catSpawnVillageScanRange;
        if (range <= 0) {
            return;
        }
        if (level.getPoiManager().getCountInRange(holder -> holder.is(PoiTypes.HOME), pos, range, PoiManager.Occupancy.IS_OCCUPIED) > 4L && (entitiesOfClass = level.getEntitiesOfClass(Cat.class, new AABB(pos).inflate(range, 8.0, range))).size() < 5) {
            this.spawnCat(pos, level, false);
        }
    }

    private void spawnInHut(ServerLevel level, BlockPos pos) {
        int range = level.purpurConfig.catSpawnSwampHutScanRange;
        if (range <= 0) {
            return;
        }
        List<Cat> entitiesOfClass = level.getEntitiesOfClass(Cat.class, new AABB(pos).inflate(range, 8.0, range));
        if (entitiesOfClass.isEmpty()) {
            this.spawnCat(pos, level, true);
        }
    }

    private void spawnCat(BlockPos pos, ServerLevel level, boolean persistent) {
        Cat cat = EntityType.CAT.create(level, EntitySpawnReason.NATURAL);
        if (cat != null) {
            cat.snapTo(pos, 0.0f, 0.0f);
            cat.finalizeSpawn(level, level.getCurrentDifficultyAt(pos), EntitySpawnReason.NATURAL, null);
            if (persistent) {
                cat.setPersistenceRequired();
            }
            level.addFreshEntityWithPassengers(cat);
        }
    }
}

