/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.mojang.logging.LogUtils;
import io.papermc.paper.annotation.DoNotUse;
import io.papermc.paper.event.entity.FishHookStateChangeEvent;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.InterpolationHandler;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.CraftEquipmentSlot;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.FishHook;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.slf4j.Logger;

public class FishingHook
extends Projectile {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final RandomSource syncronizedRandom = RandomSource.create();
    private boolean biting;
    public int outOfWaterTime;
    private static final int MAX_OUT_OF_WATER_TIME = 10;
    public static final EntityDataAccessor<Integer> DATA_HOOKED_ENTITY = SynchedEntityData.defineId(FishingHook.class, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> DATA_BITING = SynchedEntityData.defineId(FishingHook.class, EntityDataSerializers.BOOLEAN);
    private int life;
    private int nibble;
    public int timeUntilLured;
    public int timeUntilHooked;
    public float fishAngle;
    private boolean openWater = true;
    @Nullable
    public Entity hookedIn;
    public FishHookState currentState = FishHookState.FLYING;
    private final int luck;
    private final int lureSpeed;
    private final InterpolationHandler interpolationHandler = new InterpolationHandler(this);
    public int minWaitTime = 100;
    public int maxWaitTime = 600;
    public int minLureTime = 20;
    public int maxLureTime = 80;
    public float minLureAngle = 0.0f;
    public float maxLureAngle = 360.0f;
    public boolean applyLure = true;
    public boolean rainInfluenced = true;
    public boolean skyInfluenced = true;

    private FishingHook(EntityType<? extends FishingHook> type, Level level, int luck, int lureSpeed) {
        super((EntityType<? extends Projectile>)type, level);
        this.luck = Math.max(0, luck);
        this.lureSpeed = Math.max(0, lureSpeed);
        this.minWaitTime = level.paperConfig().fishingTimeRange.minimum;
        this.maxWaitTime = level.paperConfig().fishingTimeRange.maximum;
    }

    public FishingHook(EntityType<? extends FishingHook> type, Level level) {
        this(type, level, 0, 0);
    }

    public FishingHook(Player owner, Level level, int luck, int lureSpeed) {
        this(EntityType.FISHING_BOBBER, level, luck, lureSpeed);
        this.setOwner(owner);
        float xRot = owner.getXRot();
        float yRot = owner.getYRot();
        float cos = Mth.cos(-yRot * ((float)Math.PI / 180) - (float)Math.PI);
        float sin = Mth.sin(-yRot * ((float)Math.PI / 180) - (float)Math.PI);
        float f = -Mth.cos(-xRot * ((float)Math.PI / 180));
        float sin1 = Mth.sin(-xRot * ((float)Math.PI / 180));
        double d = owner.getX() - (double)sin * 0.3;
        double eyeY = owner.getEyeY();
        double d1 = owner.getZ() - (double)cos * 0.3;
        this.snapTo(d, eyeY, d1, yRot, xRot);
        Vec3 vec3 = new Vec3(-sin, Mth.clamp(-(sin1 / f), -5.0f, 5.0f), -cos);
        double len = vec3.length();
        vec3 = vec3.multiply(0.6 / len + this.random.triangle(0.5, 0.0103365), 0.6 / len + this.random.triangle(0.5, 0.0103365), 0.6 / len + this.random.triangle(0.5, 0.0103365));
        this.setDeltaMovement(vec3);
        this.setYRot((float)(Mth.atan2(vec3.x, vec3.z) * 180.0 / 3.1415927410125732));
        this.setXRot((float)(Mth.atan2(vec3.y, vec3.horizontalDistance()) * 180.0 / 3.1415927410125732));
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
    }

    @Override
    @Nonnull
    public InterpolationHandler getInterpolation() {
        return this.interpolationHandler;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_HOOKED_ENTITY, 0);
        builder.define(DATA_BITING, false);
    }

    @Override
    protected boolean shouldBounceOnWorldBorder() {
        return true;
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        if (DATA_HOOKED_ENTITY.equals(key)) {
            int i = this.getEntityData().get(DATA_HOOKED_ENTITY);
            Entity entity = this.hookedIn = i > 0 ? this.level().getEntity(i - 1) : null;
        }
        if (DATA_BITING.equals(key)) {
            this.biting = this.getEntityData().get(DATA_BITING);
            if (this.biting) {
                this.setDeltaMovement(this.getDeltaMovement().x, -0.4f * Mth.nextFloat(this.syncronizedRandom, 0.6f, 1.0f), this.getDeltaMovement().z);
            }
        }
        super.onSyncedDataUpdated(key);
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double distance) {
        double d = 64.0;
        return distance < 4096.0;
    }

    @Override
    public void tick() {
        this.syncronizedRandom.setSeed(this.getUUID().getLeastSignificantBits() ^ this.level().getGameTime());
        this.getInterpolation().interpolate();
        super.tick();
        Player playerOwner = this.getPlayerOwner();
        if (playerOwner == null) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else if (this.level().isClientSide() || !this.shouldStopFishing(playerOwner)) {
            boolean flag;
            if (this.onGround()) {
                ++this.life;
                if (this.life >= 1200) {
                    this.discard(EntityRemoveEvent.Cause.DESPAWN);
                    return;
                }
            } else {
                this.life = 0;
            }
            float f = 0.0f;
            BlockPos blockPos = this.blockPosition();
            FluidState fluidState = this.level().getFluidState(blockPos);
            if (fluidState.is(FluidTags.WATER)) {
                f = fluidState.getHeight(this.level(), blockPos);
            }
            boolean bl = flag = f > 0.0f;
            if (this.currentState == FishHookState.FLYING) {
                if (this.hookedIn != null) {
                    this.setDeltaMovement(Vec3.ZERO);
                    new FishHookStateChangeEvent((FishHook)this.getBukkitEntity(), FishHook.HookState.HOOKED_ENTITY).callEvent();
                    this.currentState = FishHookState.HOOKED_IN_ENTITY;
                    return;
                }
                if (flag) {
                    this.setDeltaMovement(this.getDeltaMovement().multiply(0.3, 0.2, 0.3));
                    new FishHookStateChangeEvent((FishHook)this.getBukkitEntity(), FishHook.HookState.BOBBING).callEvent();
                    this.currentState = FishHookState.BOBBING;
                    return;
                }
                this.checkCollision();
            } else {
                if (this.currentState == FishHookState.HOOKED_IN_ENTITY) {
                    if (this.hookedIn != null) {
                        if (!this.hookedIn.isRemoved() && this.hookedIn.canInteractWithLevel() && this.hookedIn.level().dimension() == this.level().dimension()) {
                            this.setPos(this.hookedIn.getX(), this.hookedIn.getY(0.8), this.hookedIn.getZ());
                        } else {
                            this.setHookedEntity(null);
                            new FishHookStateChangeEvent((FishHook)this.getBukkitEntity(), FishHook.HookState.UNHOOKED).callEvent();
                            this.currentState = FishHookState.FLYING;
                        }
                    }
                    return;
                }
                if (this.currentState == FishHookState.BOBBING) {
                    Vec3 deltaMovement = this.getDeltaMovement();
                    double d = this.getY() + deltaMovement.y - (double)blockPos.getY() - (double)f;
                    if (Math.abs(d) < 0.01) {
                        d += Math.signum(d) * 0.1;
                    }
                    this.setDeltaMovement(deltaMovement.x * 0.9, deltaMovement.y - d * (double)this.random.nextFloat() * 0.2, deltaMovement.z * 0.9);
                    if (this.nibble <= 0 && this.timeUntilHooked <= 0) {
                        this.openWater = true;
                    } else {
                        boolean bl2 = this.openWater = this.openWater && this.outOfWaterTime < 10 && this.calculateOpenWater(blockPos);
                    }
                    if (flag) {
                        this.outOfWaterTime = Math.max(0, this.outOfWaterTime - 1);
                        if (this.biting) {
                            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.1 * (double)this.syncronizedRandom.nextFloat() * (double)this.syncronizedRandom.nextFloat(), 0.0));
                        }
                        if (!this.level().isClientSide()) {
                            this.catchingFish(blockPos);
                        }
                    } else {
                        this.outOfWaterTime = Math.min(10, this.outOfWaterTime + 1);
                    }
                }
            }
            if (!fluidState.is(FluidTags.WATER) && !this.onGround() && this.hookedIn == null) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.03, 0.0));
            }
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.applyEffectsFromBlocks();
            this.updateRotation();
            if (this.currentState == FishHookState.FLYING && (this.onGround() || this.horizontalCollision)) {
                this.setDeltaMovement(Vec3.ZERO);
            }
            double d1 = 0.92;
            this.setDeltaMovement(this.getDeltaMovement().scale(0.92));
            this.reapplyPosition();
        }
    }

    private boolean shouldStopFishing(Player player) {
        if (player.canInteractWithLevel()) {
            ItemStack mainHandItem = player.getMainHandItem();
            ItemStack offhandItem = player.getOffhandItem();
            boolean isFishingRod = mainHandItem.is(Items.FISHING_ROD);
            boolean isFishingRod1 = offhandItem.is(Items.FISHING_ROD);
            if ((isFishingRod || isFishingRod1) && this.distanceToSqr(player) <= 1024.0) {
                return false;
            }
        }
        this.discard(EntityRemoveEvent.Cause.DESPAWN);
        return true;
    }

    private void checkCollision() {
        HitResult hitResultOnMoveVector = ProjectileUtil.getHitResultOnMoveVector(this, this::canHitEntity);
        this.preHitTargetOrDeflectSelf(hitResultOnMoveVector);
    }

    @Override
    protected boolean canHitEntity(Entity target) {
        return super.canHitEntity(target) || target.isAlive() && target instanceof ItemEntity;
    }

    @Override
    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        if (!this.level().isClientSide()) {
            this.setHookedEntity(result.getEntity());
        }
    }

    @Override
    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        this.setDeltaMovement(this.getDeltaMovement().normalize().scale(result.distanceTo(this)));
    }

    public void setHookedEntity(@Nullable Entity hookedEntity) {
        this.hookedIn = hookedEntity;
        this.getEntityData().set(DATA_HOOKED_ENTITY, hookedEntity == null ? 0 : hookedEntity.getId() + 1);
    }

    private void catchingFish(BlockPos pos) {
        ServerLevel serverLevel = (ServerLevel)this.level();
        int i = 1;
        BlockPos blockPos = pos.above();
        if (this.rainInfluenced && this.random.nextFloat() < 0.25f && this.level().isRainingAt(blockPos)) {
            ++i;
        }
        if (this.skyInfluenced && this.random.nextFloat() < 0.5f && !this.level().canSeeSky(blockPos)) {
            --i;
        }
        if (this.nibble > 0) {
            --this.nibble;
            if (this.nibble <= 0) {
                this.timeUntilLured = 0;
                this.timeUntilHooked = 0;
                this.getEntityData().set(DATA_BITING, false);
                PlayerFishEvent playerFishEvent = new PlayerFishEvent((org.bukkit.entity.Player)this.getPlayerOwner().getBukkitEntity(), null, (FishHook)this.getBukkitEntity(), PlayerFishEvent.State.FAILED_ATTEMPT);
                playerFishEvent.callEvent();
            }
        } else if (this.timeUntilHooked > 0) {
            this.timeUntilHooked -= i;
            if (this.timeUntilHooked > 0) {
                double d2;
                double d1;
                this.fishAngle += (float)this.random.triangle(0.0, 9.188);
                float f = this.fishAngle * ((float)Math.PI / 180);
                float sin = Mth.sin(f);
                float cos = Mth.cos(f);
                double d = this.getX() + (double)(sin * (float)this.timeUntilHooked * 0.1f);
                BlockState blockState = serverLevel.getBlockState(BlockPos.containing(d, (d1 = (double)((float)Mth.floor(this.getY()) + 1.0f)) - 1.0, d2 = this.getZ() + (double)(cos * (float)this.timeUntilHooked * 0.1f)));
                if (blockState.is(Blocks.WATER)) {
                    if (this.random.nextFloat() < 0.15f) {
                        serverLevel.sendParticles(ParticleTypes.BUBBLE, d, d1 - (double)0.1f, d2, 1, sin, 0.1, cos, 0.0);
                    }
                    float f1 = sin * 0.04f;
                    float f2 = cos * 0.04f;
                    serverLevel.sendParticles(ParticleTypes.FISHING, d, d1, d2, 0, f2, 0.01, -f1, 1.0);
                    serverLevel.sendParticles(ParticleTypes.FISHING, d, d1, d2, 0, -f2, 0.01, f1, 1.0);
                }
            } else {
                PlayerFishEvent playerFishEvent = new PlayerFishEvent((org.bukkit.entity.Player)this.getPlayerOwner().getBukkitEntity(), null, (FishHook)this.getBukkitEntity(), PlayerFishEvent.State.BITE);
                if (!playerFishEvent.callEvent()) {
                    return;
                }
                this.playSound(SoundEvents.FISHING_BOBBER_SPLASH, 0.25f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
                double d3 = this.getY() + 0.5;
                serverLevel.sendParticles(ParticleTypes.BUBBLE, this.getX(), d3, this.getZ(), (int)(1.0f + this.getBbWidth() * 20.0f), this.getBbWidth(), 0.0, this.getBbWidth(), 0.2f);
                serverLevel.sendParticles(ParticleTypes.FISHING, this.getX(), d3, this.getZ(), (int)(1.0f + this.getBbWidth() * 20.0f), this.getBbWidth(), 0.0, this.getBbWidth(), 0.2f);
                this.nibble = Mth.nextInt(this.random, 20, 40);
                this.getEntityData().set(DATA_BITING, true);
            }
        } else if (this.timeUntilLured > 0) {
            this.timeUntilLured -= i;
            float f = 0.15f;
            if (this.timeUntilLured < 20) {
                f += (float)(20 - this.timeUntilLured) * 0.05f;
            } else if (this.timeUntilLured < 40) {
                f += (float)(40 - this.timeUntilLured) * 0.02f;
            } else if (this.timeUntilLured < 60) {
                f += (float)(60 - this.timeUntilLured) * 0.01f;
            }
            if (this.random.nextFloat() < f) {
                double d2;
                double d1;
                float sin = Mth.nextFloat(this.random, 0.0f, 360.0f) * ((float)Math.PI / 180);
                float cos = Mth.nextFloat(this.random, 25.0f, 60.0f);
                double d = this.getX() + (double)(Mth.sin(sin) * cos) * 0.1;
                BlockState blockState = serverLevel.getBlockState(BlockPos.containing(d, (d1 = (double)((float)Mth.floor(this.getY()) + 1.0f)) - 1.0, d2 = this.getZ() + (double)(Mth.cos(sin) * cos) * 0.1));
                if (blockState.is(Blocks.WATER)) {
                    serverLevel.sendParticles(ParticleTypes.SPLASH, d, d1, d2, 2 + this.random.nextInt(2), 0.1f, 0.0, 0.1f, 0.0);
                }
            }
            if (this.timeUntilLured <= 0) {
                PlayerFishEvent playerFishEvent;
                this.fishAngle = Mth.nextFloat(this.random, this.minLureAngle, this.maxLureAngle);
                this.timeUntilHooked = Mth.nextInt(this.random, this.minLureTime, this.maxLureTime);
                if (this.getPlayerOwner() != null && !(playerFishEvent = new PlayerFishEvent((org.bukkit.entity.Player)this.getPlayerOwner().getBukkitEntity(), null, (FishHook)this.getBukkitEntity(), PlayerFishEvent.State.LURED)).callEvent()) {
                    this.timeUntilHooked = 0;
                    return;
                }
            }
        } else {
            this.resetTimeUntilLured();
        }
    }

    public void resetTimeUntilLured() {
        this.timeUntilLured = Mth.nextInt(this.random, this.minWaitTime, this.maxWaitTime);
        this.timeUntilLured -= this.applyLure ? (this.lureSpeed >= this.maxWaitTime ? this.timeUntilLured - 1 : this.lureSpeed) : 0;
    }

    public boolean calculateOpenWater(BlockPos pos) {
        OpenWaterType openWaterType = OpenWaterType.INVALID;
        for (int i = -1; i <= 2; ++i) {
            OpenWaterType openWaterTypeForArea = this.getOpenWaterTypeForArea(pos.offset(-2, i, -2), pos.offset(2, i, 2));
            switch (openWaterTypeForArea.ordinal()) {
                case 0: {
                    if (openWaterType != OpenWaterType.INVALID) break;
                    return false;
                }
                case 1: {
                    if (openWaterType != OpenWaterType.ABOVE_WATER) break;
                    return false;
                }
                case 2: {
                    return false;
                }
            }
            openWaterType = openWaterTypeForArea;
        }
        return true;
    }

    private OpenWaterType getOpenWaterTypeForArea(BlockPos pos1, BlockPos pos2) {
        return BlockPos.betweenClosedStream(pos1, pos2).map(this::getOpenWaterTypeForBlock).reduce((type1, type2) -> type1 == type2 ? type1 : OpenWaterType.INVALID).orElse(OpenWaterType.INVALID);
    }

    private OpenWaterType getOpenWaterTypeForBlock(BlockPos pos) {
        BlockState blockState = this.level().getBlockState(pos);
        if (!blockState.isAir() && !blockState.is(Blocks.LILY_PAD)) {
            FluidState fluidState = blockState.getFluidState();
            return fluidState.is(FluidTags.WATER) && fluidState.isSource() && blockState.getCollisionShape(this.level(), pos).isEmpty() ? OpenWaterType.INSIDE_WATER : OpenWaterType.INVALID;
        }
        return OpenWaterType.ABOVE_WATER;
    }

    public boolean isOpenWaterFishing() {
        return this.openWater;
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput output) {
    }

    @Override
    protected void readAdditionalSaveData(ValueInput input) {
    }

    @Deprecated
    @DoNotUse
    public int retrieve(ItemStack stack) {
        return this.retrieve(stack, InteractionHand.MAIN_HAND);
    }

    public int retrieve(ItemStack stack, InteractionHand hand) {
        Player playerOwner = this.getPlayerOwner();
        if (!this.level().isClientSide() && playerOwner != null && !this.shouldStopFishing(playerOwner)) {
            PlayerFishEvent playerFishEvent;
            int i = 0;
            if (this.hookedIn != null) {
                playerFishEvent = new PlayerFishEvent((org.bukkit.entity.Player)playerOwner.getBukkitEntity(), (org.bukkit.entity.Entity)this.hookedIn.getBukkitEntity(), (FishHook)this.getBukkitEntity(), CraftEquipmentSlot.getHand(hand), PlayerFishEvent.State.CAUGHT_ENTITY);
                if (!playerFishEvent.callEvent()) {
                    return 0;
                }
                if (this.hookedIn != null) {
                    this.pullEntity(this.hookedIn);
                    CriteriaTriggers.FISHING_ROD_HOOKED.trigger((ServerPlayer)playerOwner, stack, this, Collections.emptyList());
                    this.level().broadcastEntityEvent(this, (byte)31);
                    i = this.hookedIn instanceof ItemEntity ? 3 : 5;
                }
            } else if (this.nibble > 0) {
                LootParams lootParams = new LootParams.Builder((ServerLevel)this.level()).withParameter(LootContextParams.ORIGIN, this.position()).withParameter(LootContextParams.TOOL, stack).withParameter(LootContextParams.THIS_ENTITY, this).withLuck((float)this.luck + playerOwner.getLuck()).create(LootContextParamSets.FISHING);
                LootTable lootTable = this.level().getServer().reloadableRegistries().getLootTable(BuiltInLootTables.FISHING);
                ObjectArrayList<ItemStack> randomItems = lootTable.getRandomItems(lootParams);
                CriteriaTriggers.FISHING_ROD_HOOKED.trigger((ServerPlayer)playerOwner, stack, this, (Collection<ItemStack>)randomItems);
                for (ItemStack itemStack : randomItems) {
                    ItemEntity itemEntity = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), itemStack);
                    PlayerFishEvent playerFishEvent2 = new PlayerFishEvent((org.bukkit.entity.Player)playerOwner.getBukkitEntity(), (org.bukkit.entity.Entity)itemEntity.getBukkitEntity(), (FishHook)this.getBukkitEntity(), CraftEquipmentSlot.getHand(hand), PlayerFishEvent.State.CAUGHT_FISH);
                    playerFishEvent2.setExpToDrop(this.random.nextInt(6) + 1);
                    if (!playerFishEvent2.callEvent()) {
                        return 0;
                    }
                    double d = playerOwner.getX() - this.getX();
                    double d1 = playerOwner.getY() - this.getY();
                    double d2 = playerOwner.getZ() - this.getZ();
                    double d3 = 0.1;
                    itemEntity.setDeltaMovement(d * 0.1, d1 * 0.1 + Math.sqrt(Math.sqrt(d * d + d1 * d1 + d2 * d2)) * 0.08, d2 * 0.1);
                    this.level().addFreshEntity(itemEntity);
                    if (playerFishEvent2.getExpToDrop() > 0) {
                        playerOwner.level().addFreshEntity(new ExperienceOrb(playerOwner.level(), new Vec3(playerOwner.getX(), playerOwner.getY() + 0.5, playerOwner.getZ() + 0.5), Vec3.ZERO, playerFishEvent2.getExpToDrop(), ExperienceOrb.SpawnReason.FISHING, this.getPlayerOwner(), this));
                    }
                    if (!itemStack.is(ItemTags.FISHES)) continue;
                    playerOwner.awardStat(Stats.FISH_CAUGHT, 1);
                }
                i = 1;
            }
            if (this.onGround()) {
                playerFishEvent = new PlayerFishEvent((org.bukkit.entity.Player)playerOwner.getBukkitEntity(), null, (FishHook)this.getBukkitEntity(), CraftEquipmentSlot.getHand(hand), PlayerFishEvent.State.IN_GROUND);
                if (!playerFishEvent.callEvent()) {
                    return 0;
                }
                i = 2;
            }
            if (i == 0 && !(playerFishEvent = new PlayerFishEvent((org.bukkit.entity.Player)playerOwner.getBukkitEntity(), null, (FishHook)this.getBukkitEntity(), CraftEquipmentSlot.getHand(hand), PlayerFishEvent.State.REEL_IN)).callEvent()) {
                return 0;
            }
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
            return i;
        }
        return 0;
    }

    @Override
    public void handleEntityEvent(byte id) {
        Player player;
        Entity entity;
        if (id == 31 && this.level().isClientSide() && (entity = this.hookedIn) instanceof Player && (player = (Player)entity).isLocalPlayer()) {
            this.pullEntity(this.hookedIn);
        }
        super.handleEntityEvent(id);
    }

    public void pullEntity(Entity entity) {
        Entity owner = this.getOwner();
        if (owner != null) {
            Vec3 vec3 = new Vec3(owner.getX() - this.getX(), owner.getY() - this.getY(), owner.getZ() - this.getZ()).scale(0.1);
            entity.setDeltaMovement(entity.getDeltaMovement().add(vec3));
        }
    }

    @Override
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    @Override
    public void remove(Entity.RemovalReason reason, @Nullable EntityRemoveEvent.Cause cause) {
        this.updateOwnerInfo(null);
        super.remove(reason, cause);
    }

    @Override
    public void onClientRemoval() {
        this.updateOwnerInfo(null);
    }

    @Override
    public void setOwner(@Nullable Entity owner) {
        super.setOwner(owner);
        this.updateOwnerInfo(this);
    }

    private void updateOwnerInfo(@Nullable FishingHook fishingHook) {
        Player playerOwner = this.getPlayerOwner();
        if (playerOwner != null) {
            playerOwner.fishing = fishingHook;
        }
    }

    @Nullable
    public Player getPlayerOwner() {
        Player player;
        Entity entity = this.getOwner();
        return entity instanceof Player ? (player = (Player)entity) : null;
    }

    @Nullable
    public Entity getHookedIn() {
        return this.hookedIn;
    }

    @Override
    public boolean canUsePortal(boolean allowPassengers) {
        return false;
    }

    @Override
    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity entity) {
        Entity owner = this.getOwner();
        return new ClientboundAddEntityPacket((Entity)this, entity, owner == null ? this.getId() : owner.getId());
    }

    @Override
    public void recreateFromPacket(ClientboundAddEntityPacket packet) {
        super.recreateFromPacket(packet);
        if (this.getPlayerOwner() == null) {
            int data = packet.getData();
            LOGGER.error("Failed to recreate fishing hook on client. {} (id: {}) is not a valid owner.", (Object)this.level().getEntity(data), (Object)data);
            this.discard(null);
        }
    }

    public static enum FishHookState {
        FLYING,
        HOOKED_IN_ENTITY,
        BOBBING;

    }

    static enum OpenWaterType {
        ABOVE_WATER,
        INSIDE_WATER,
        INVALID;

    }
}

