/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.destroystokyo.paper.event.entity.ThrownEggHatchEvent;
import java.util.Optional;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.entity.CraftEntityType;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Egg;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerEggThrowEvent;

public class ThrownEgg
extends ThrowableItemProjectile {
    private static final EntityDimensions ZERO_SIZED_DIMENSIONS = EntityDimensions.fixed(0.0f, 0.0f);

    public ThrownEgg(EntityType<? extends ThrownEgg> type, Level level) {
        super((EntityType<? extends ThrowableItemProjectile>)type, level);
    }

    public ThrownEgg(Level level, LivingEntity owner, ItemStack item) {
        super(EntityType.EGG, owner, level, item);
    }

    public ThrownEgg(Level level, double x, double y, double z, ItemStack item) {
        super(EntityType.EGG, x, y, z, level, item);
    }

    @Override
    public void handleEntityEvent(byte id) {
        if (id == 3) {
            double d = 0.08;
            for (int i = 0; i < 8; ++i) {
                this.level().addParticle(new ItemParticleOption(ParticleTypes.ITEM, this.getItem()), this.getX(), this.getY(), this.getZ(), ((double)this.random.nextFloat() - 0.5) * 0.08, ((double)this.random.nextFloat() - 0.5) * 0.08, ((double)this.random.nextFloat() - 0.5) * 0.08);
            }
        }
    }

    @Override
    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        result.getEntity().hurt(this.damageSources().thrown(this, this.getOwner()), 0.0f);
    }

    @Override
    protected void onHit(HitResult result) {
        super.onHit(result);
        if (!this.level().isClientSide()) {
            ThrownEggHatchEvent event;
            boolean hatching = this.random.nextInt(8) == 0;
            int i = 1;
            if (this.random.nextInt(32) == 0) {
                i = 4;
            }
            if (!hatching) {
                i = 0;
            }
            Entity shooter = this.getOwner();
            org.bukkit.entity.EntityType hatchingType = org.bukkit.entity.EntityType.CHICKEN;
            if (shooter instanceof ServerPlayer) {
                event = new PlayerEggThrowEvent((Player)shooter.getBukkitEntity(), (Egg)this.getBukkitEntity(), hatching, (byte)i, hatchingType);
                event.callEvent();
                hatching = event.isHatching();
                i = hatching ? event.getNumHatches() : (byte)0;
                hatchingType = event.getHatchingType();
            }
            event = new ThrownEggHatchEvent((Egg)this.getBukkitEntity(), hatching, (byte)i, hatchingType);
            event.callEvent();
            hatching = event.isHatching();
            i = hatching ? event.getNumHatches() : (byte)0;
            hatchingType = event.getHatchingType();
            EntityType<?> newEntityType = CraftEntityType.bukkitToMinecraft(hatchingType);
            for (int i1 = 0; i1 < i; ++i1) {
                Object chicken = newEntityType.create(this.level(), EntitySpawnReason.TRIGGERED);
                if (chicken == null) continue;
                CraftEntity craftEntity = ((Entity)chicken).getBukkitEntity();
                if (craftEntity instanceof Ageable) {
                    Ageable ageable = (Ageable)craftEntity;
                    ageable.setBaby();
                }
                ((Entity)chicken).snapTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), 0.0f);
                if (chicken instanceof Chicken) {
                    Chicken realChicken = (Chicken)chicken;
                    Optional.ofNullable(this.getItem().get(DataComponents.CHICKEN_VARIANT)).flatMap(eitherHolder -> eitherHolder.unwrap(this.registryAccess())).ifPresent(realChicken::setVariant);
                }
                if (!((Entity)chicken).fudgePositionAfterSizeChange(ZERO_SIZED_DIMENSIONS)) break;
                this.level().addFreshEntity((Entity)chicken, CreatureSpawnEvent.SpawnReason.EGG);
            }
            this.level().broadcastEntityEvent(this, (byte)3);
            this.discard(EntityRemoveEvent.Cause.HIT);
        }
    }

    @Override
    public Item getDefaultItem() {
        return Items.EGG;
    }
}

