/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.ExpBottleEvent;

public class ThrownExperienceBottle
extends ThrowableItemProjectile {
    public ThrownExperienceBottle(EntityType<? extends ThrownExperienceBottle> type, Level level) {
        super((EntityType<? extends ThrowableItemProjectile>)type, level);
    }

    public ThrownExperienceBottle(Level level, LivingEntity owner, ItemStack item) {
        super(EntityType.EXPERIENCE_BOTTLE, owner, level, item);
    }

    public ThrownExperienceBottle(Level level, double x, double y, double z, ItemStack item) {
        super(EntityType.EXPERIENCE_BOTTLE, x, y, z, level, item);
    }

    @Override
    public Item getDefaultItem() {
        return Items.EXPERIENCE_BOTTLE;
    }

    @Override
    protected double getDefaultGravity() {
        return 0.07;
    }

    @Override
    protected void onHit(HitResult result) {
        super.onHit(result);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            int i = 3 + serverLevel.random.nextInt(5) + serverLevel.random.nextInt(5);
            ExpBottleEvent event = CraftEventFactory.callExpBottleEvent(this, result, i);
            i = event.getExperience();
            if (result instanceof BlockHitResult) {
                BlockHitResult blockHitResult = (BlockHitResult)result;
                Vec3 unitVec3 = blockHitResult.getDirection().getUnitVec3();
                ExperienceOrb.awardWithDirection(serverLevel, result.getLocation(), unitVec3, i, ExperienceOrb.SpawnReason.EXP_BOTTLE, this.getOwner(), this);
            } else {
                ExperienceOrb.awardWithDirection(serverLevel, result.getLocation(), this.getDeltaMovement().scale(-1.0), i, ExperienceOrb.SpawnReason.EXP_BOTTLE, this.getOwner(), this);
            }
            if (event.getShowEffect()) {
                this.level().levelEvent(2002, this.blockPosition(), -13083194);
            }
            this.discard(EntityRemoveEvent.Cause.HIT);
        }
    }
}

