/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.schedule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.Int2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectSortedMap;
import java.util.Collection;
import java.util.List;
import net.minecraft.world.entity.schedule.Keyframe;

public class Timeline {
    private final List<Keyframe> keyframes = Lists.newArrayList();
    private int previousIndex;

    public ImmutableList<Keyframe> getKeyframes() {
        return ImmutableList.copyOf(this.keyframes);
    }

    public Timeline addKeyframe(int duration, float active) {
        this.keyframes.add(new Keyframe(duration, active));
        this.sortAndDeduplicateKeyframes();
        return this;
    }

    public Timeline addKeyframes(Collection<Keyframe> frames) {
        this.keyframes.addAll(frames);
        this.sortAndDeduplicateKeyframes();
        return this;
    }

    private void sortAndDeduplicateKeyframes() {
        Int2ObjectAVLTreeMap map = new Int2ObjectAVLTreeMap();
        this.keyframes.forEach(arg_0 -> Timeline.lambda$sortAndDeduplicateKeyframes$0((Int2ObjectSortedMap)map, arg_0));
        this.keyframes.clear();
        this.keyframes.addAll((Collection<Keyframe>)map.values());
        this.previousIndex = 0;
    }

    public float getValueAt(int dayTime) {
        Keyframe keyframe2;
        if (this.keyframes.size() <= 0) {
            return 0.0f;
        }
        Keyframe keyframe = this.keyframes.get(this.previousIndex);
        Keyframe keyframe1 = this.keyframes.get(this.keyframes.size() - 1);
        boolean flag = dayTime < keyframe.getTimeStamp();
        int i = flag ? 0 : this.previousIndex;
        float f = flag ? keyframe1.getValue() : keyframe.getValue();
        int i1 = i;
        while (i1 < this.keyframes.size() && (keyframe2 = this.keyframes.get(i1)).getTimeStamp() <= dayTime) {
            this.previousIndex = i1++;
            f = keyframe2.getValue();
        }
        return f;
    }

    private static /* synthetic */ void lambda$sortAndDeduplicateKeyframes$0(Int2ObjectSortedMap map, Keyframe keyframe) {
        map.put(keyframe.getTimeStamp(), (Object)keyframe);
    }
}

