/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import com.destroystokyo.paper.event.block.AnvilDamagedEvent;
import com.mojang.logging.LogUtils;
import io.papermc.paper.adventure.PaperAdventure;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.protocol.game.ClientboundContainerSetDataPacket;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.inventory.ItemCombinerMenuSlotDefinition;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.bukkit.ChatColor;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.block.data.CraftBlockData;
import org.bukkit.craftbukkit.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.craftbukkit.inventory.CraftInventoryAnvil;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.inventory.view.CraftAnvilView;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.purpurmc.purpur.PurpurConfig;
import org.purpurmc.purpur.event.inventory.AnvilTakeResultEvent;
import org.purpurmc.purpur.event.inventory.AnvilUpdateResultEvent;
import org.slf4j.Logger;

public class AnvilMenu
extends ItemCombinerMenu {
    public static final int INPUT_SLOT = 0;
    public static final int ADDITIONAL_SLOT = 1;
    public static final int RESULT_SLOT = 2;
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final boolean DEBUG_COST = false;
    public static final int MAX_NAME_LENGTH = 50;
    public int repairItemCountCost;
    @Nullable
    public String itemName;
    public final DataSlot cost = DataSlot.standalone();
    private boolean onlyRenaming = false;
    private static final int COST_FAIL = 0;
    private static final int COST_BASE = 1;
    private static final int COST_ADDED_BASE = 1;
    private static final int COST_REPAIR_MATERIAL = 1;
    private static final int COST_REPAIR_SACRIFICE = 2;
    private static final int COST_INCOMPATIBLE_PENALTY = 1;
    private static final int COST_RENAME = 1;
    private static final int INPUT_SLOT_X_PLACEMENT = 27;
    private static final int ADDITIONAL_SLOT_X_PLACEMENT = 76;
    private static final int RESULT_SLOT_X_PLACEMENT = 134;
    private static final int SLOT_Y_PLACEMENT = 47;
    public static final int DEFAULT_DENIED_COST = -1;
    public int maximumRepairCost = 40;
    private CraftAnvilView bukkitEntity;
    public boolean bypassEnchantmentLevelRestriction = false;
    public boolean bypassCost = false;
    public boolean canDoUnsafeEnchants = false;

    public AnvilMenu(int containerId, Inventory playerInventory) {
        this(containerId, playerInventory, ContainerLevelAccess.NULL);
    }

    public AnvilMenu(int containerId, Inventory playerInventory, ContainerLevelAccess access) {
        super(MenuType.ANVIL, containerId, playerInventory, access, AnvilMenu.createInputSlotDefinitions());
        this.addDataSlot(this.cost);
    }

    private static ItemCombinerMenuSlotDefinition createInputSlotDefinitions() {
        return ItemCombinerMenuSlotDefinition.create().withSlot(0, 27, 47, itemStack -> true).withSlot(1, 76, 47, itemStack -> true).withResultSlot(2, 134, 47).build();
    }

    @Override
    protected boolean isValidBlock(BlockState state) {
        return state.is(BlockTags.ANVIL);
    }

    @Override
    protected boolean mayPickup(Player player, boolean hasStack) {
        return !(!player.hasInfiniteMaterials() && player.experienceLevel < this.cost.get() || !this.bypassCost && this.cost.get() <= -1 || !hasStack);
    }

    @Override
    protected void onTake(Player player, net.minecraft.world.item.ItemStack stack) {
        net.minecraft.world.item.ItemStack itemstack;
        net.minecraft.world.item.ItemStack itemStack = itemstack = this.activeQuickItem != null ? this.activeQuickItem : stack;
        if (AnvilTakeResultEvent.getHandlerList().getRegisteredListeners().length > 0) {
            new AnvilTakeResultEvent((HumanEntity)player.getBukkitEntity(), (InventoryView)this.getBukkitView(), (ItemStack)CraftItemStack.asCraftMirror(itemstack)).callEvent();
        }
        if (!player.hasInfiniteMaterials()) {
            if (this.bypassCost) {
                ((ServerPlayer)player).lastSentExp = -1;
            } else {
                player.giveExperienceLevels(-this.cost.get());
            }
        }
        if (this.repairItemCountCost > 0) {
            net.minecraft.world.item.ItemStack item = this.inputSlots.getItem(1);
            if (!item.isEmpty() && item.getCount() > this.repairItemCountCost) {
                item.shrink(this.repairItemCountCost);
                this.inputSlots.setItem(1, item);
            } else {
                this.inputSlots.setItem(1, net.minecraft.world.item.ItemStack.EMPTY);
            }
        } else if (!this.onlyRenaming) {
            this.inputSlots.setItem(1, net.minecraft.world.item.ItemStack.EMPTY);
        }
        this.cost.set(-1);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (!StringUtil.isBlank(this.itemName) && !this.inputSlots.getItem(0).getHoverName().getString().equals(this.itemName)) {
                serverPlayer.getTextFilter().processStreamMessage(this.itemName);
            }
        }
        this.inputSlots.setItem(0, net.minecraft.world.item.ItemStack.EMPTY);
        this.access.execute((level, blockPos) -> {
            BlockState blockState = level.getBlockState((BlockPos)blockPos);
            if (!player.hasInfiniteMaterials() && blockState.is(BlockTags.ANVIL) && player.getRandom().nextFloat() < 0.12f) {
                BlockState blockState1 = AnvilBlock.damage(blockState);
                AnvilDamagedEvent event = new AnvilDamagedEvent((InventoryView)this.getBukkitView(), (BlockData)(blockState1 != null ? CraftBlockData.fromData(blockState1) : null));
                if (!event.callEvent()) {
                    return;
                }
                blockState1 = event.getDamageState() == AnvilDamagedEvent.DamageState.BROKEN ? null : (BlockState)((CraftBlockData)event.getDamageState().getMaterial().createBlockData()).getState().setValue(AnvilBlock.FACING, blockState.getValue(AnvilBlock.FACING));
                if (blockState1 == null) {
                    level.removeBlock((BlockPos)blockPos, false);
                    level.levelEvent(1029, (BlockPos)blockPos, 0);
                } else {
                    level.setBlock((BlockPos)blockPos, blockState1, 2);
                    level.levelEvent(1030, (BlockPos)blockPos, 0);
                }
            } else {
                level.levelEvent(1030, (BlockPos)blockPos, 0);
            }
        });
    }

    @Override
    public void createResult() {
        this.bypassCost = false;
        this.canDoUnsafeEnchants = false;
        if (AnvilUpdateResultEvent.getHandlerList().getRegisteredListeners().length > 0) {
            new AnvilUpdateResultEvent((InventoryView)this.getBukkitView()).callEvent();
        }
        net.minecraft.world.item.ItemStack item = this.inputSlots.getItem(0);
        this.onlyRenaming = false;
        this.cost.set(1);
        int i = 0;
        long l = 0L;
        int i1 = 0;
        if (!item.isEmpty() && this.canDoUnsafeEnchants || EnchantmentHelper.canStoreEnchantments(item)) {
            net.minecraft.world.item.ItemStack itemStack = item.copy();
            net.minecraft.world.item.ItemStack item1 = this.inputSlots.getItem(1);
            ItemEnchantments.Mutable mutable = new ItemEnchantments.Mutable(EnchantmentHelper.getEnchantmentsForCrafting(itemStack));
            l += (long)item.getOrDefault(DataComponents.REPAIR_COST, 0).intValue() + (long)item1.getOrDefault(DataComponents.REPAIR_COST, 0).intValue();
            this.repairItemCountCost = 0;
            if (!item1.isEmpty()) {
                boolean hasStoredEnchantments = item1.has(DataComponents.STORED_ENCHANTMENTS);
                if (itemStack.isDamageableItem() && item.isValidRepairItem(item1)) {
                    int min = Math.min(itemStack.getDamageValue(), itemStack.getMaxDamage() / 4);
                    if (min <= 0) {
                        CraftEventFactory.callPrepareAnvilEvent(this.getBukkitView(), net.minecraft.world.item.ItemStack.EMPTY);
                        this.cost.set(-1);
                        return;
                    }
                    for (i2 = 0; min > 0 && i2 < item1.getCount(); ++i2) {
                        i3 = itemStack.getDamageValue() - min;
                        itemStack.setDamageValue(i3);
                        ++i;
                        min = Math.min(itemStack.getDamageValue(), itemStack.getMaxDamage() / 4);
                    }
                    this.repairItemCountCost = i2;
                } else {
                    if (!(hasStoredEnchantments || itemStack.is(item1.getItem()) && itemStack.isDamageableItem())) {
                        CraftEventFactory.callPrepareAnvilEvent(this.getBukkitView(), net.minecraft.world.item.ItemStack.EMPTY);
                        this.cost.set(-1);
                        return;
                    }
                    if (itemStack.isDamageableItem() && !hasStoredEnchantments) {
                        int minx = item.getMaxDamage() - item.getDamageValue();
                        i2 = item1.getMaxDamage() - item1.getDamageValue();
                        i3 = i2 + itemStack.getMaxDamage() * 12 / 100;
                        int i4 = minx + i3;
                        int i5 = itemStack.getMaxDamage() - i4;
                        if (i5 < 0) {
                            i5 = 0;
                        }
                        if (i5 < itemStack.getDamageValue()) {
                            itemStack.setDamageValue(i5);
                            i += 2;
                        }
                    }
                    ItemEnchantments enchantmentsForCrafting = EnchantmentHelper.getEnchantmentsForCrafting(item1);
                    boolean flag = false;
                    boolean flag1 = false;
                    for (Object2IntMap.Entry<Holder<Enchantment>> entry : enchantmentsForCrafting.entrySet()) {
                        int intValue;
                        Holder holder = (Holder)entry.getKey();
                        int level = mutable.getLevel(holder);
                        intValue = level == (intValue = entry.getIntValue()) ? intValue + 1 : Math.max(intValue, level);
                        Enchantment enchantment = (Enchantment)holder.value();
                        boolean canEnchant = this.canDoUnsafeEnchants || PurpurConfig.allowInapplicableEnchants || enchantment.canEnchant(item);
                        boolean canEnchant1 = true;
                        if (this.player.hasInfiniteMaterials() || item.is(Items.ENCHANTED_BOOK)) {
                            canEnchant = true;
                        }
                        HashSet<Holder<Enchantment>> removedEnchantments = new HashSet<Holder<Enchantment>>();
                        for (Holder<Enchantment> holder1 : mutable.keySet()) {
                            if (holder1.equals(holder) || Enchantment.areCompatible(holder, holder1)) continue;
                            boolean bl = canEnchant1 = this.canDoUnsafeEnchants || PurpurConfig.allowIncompatibleEnchants;
                            if (!canEnchant1 && PurpurConfig.replaceIncompatibleEnchants) {
                                removedEnchantments.add(holder1);
                                canEnchant1 = true;
                            }
                            ++i;
                        }
                        mutable.removeIf(removedEnchantments::contains);
                        if (!canEnchant || !canEnchant1) {
                            flag1 = true;
                            continue;
                        }
                        flag = true;
                        if (!PurpurConfig.allowHigherEnchantsLevels && intValue > enchantment.getMaxLevel() && !this.bypassEnchantmentLevelRestriction) {
                            intValue = enchantment.getMaxLevel();
                        }
                        mutable.set(holder, intValue);
                        int anvilCost = enchantment.getAnvilCost();
                        if (hasStoredEnchantments) {
                            anvilCost = Math.max(1, anvilCost / 2);
                        }
                        i += anvilCost * intValue;
                        if (item.getCount() <= 1) continue;
                        i = 40;
                    }
                    if (flag1 && !flag) {
                        CraftEventFactory.callPrepareAnvilEvent(this.getBukkitView(), net.minecraft.world.item.ItemStack.EMPTY);
                        this.cost.set(-1);
                        return;
                    }
                }
            }
            if (this.itemName != null && !StringUtil.isBlank(this.itemName)) {
                if (!this.itemName.equals(item.getHoverName().getString())) {
                    i1 = 1;
                    i += i1;
                    if (this.player != null) {
                        CraftHumanEntity player = this.player.getBukkitEntity();
                        String name = this.itemName;
                        boolean removeItalics = false;
                        if (player.hasPermission("purpur.anvil.remove_italics")) {
                            if (name.startsWith("&r")) {
                                name = name.substring(2);
                                removeItalics = true;
                            } else if (name.startsWith("<r>")) {
                                name = name.substring(3);
                                removeItalics = true;
                            } else if (name.startsWith("<reset>")) {
                                name = name.substring(7);
                                removeItalics = true;
                            }
                        }
                        if (this.player.level().purpurConfig.anvilAllowColors) {
                            String match;
                            if (player.hasPermission("purpur.anvil.color")) {
                                Matcher matcher = Pattern.compile("(?i)&([0-9a-fr])").matcher(name);
                                while (matcher.find()) {
                                    match = matcher.group(1);
                                    name = name.replace("&" + match, "\u00a7" + match.toLowerCase(Locale.ROOT));
                                }
                            }
                            if (player.hasPermission("purpur.anvil.format")) {
                                Matcher matcher = Pattern.compile("(?i)&([k-or])").matcher(name);
                                while (matcher.find()) {
                                    match = matcher.group(1);
                                    name = name.replace("&" + match, "\u00a7" + match.toLowerCase(Locale.ROOT));
                                }
                            }
                        }
                        Object component = this.player.level().purpurConfig.anvilColorsUseMiniMessage && player.hasPermission("purpur.anvil.minimessage") ? MiniMessage.miniMessage().deserialize((Object)ChatColor.stripColor((String)name)) : LegacyComponentSerializer.legacySection().deserialize(name);
                        if (removeItalics) {
                            component = component.decoration(TextDecoration.ITALIC, false);
                        }
                        itemStack.set(DataComponents.CUSTOM_NAME, PaperAdventure.asVanilla((Component)component));
                    } else {
                        itemStack.set(DataComponents.CUSTOM_NAME, net.minecraft.network.chat.Component.literal(this.itemName));
                    }
                }
            } else if (item.has(DataComponents.CUSTOM_NAME)) {
                i1 = 1;
                i += i1;
                itemStack.remove(DataComponents.CUSTOM_NAME);
            }
            int i6 = i <= 0 ? 0 : (int)Mth.clamp(l + (long)i, 0L, Integer.MAX_VALUE);
            this.cost.set(i6);
            if (i <= 0) {
                itemStack = net.minecraft.world.item.ItemStack.EMPTY;
            }
            if (i1 == i && i1 > 0) {
                if (this.cost.get() >= this.maximumRepairCost) {
                    this.cost.set(this.maximumRepairCost - 1);
                }
                this.onlyRenaming = true;
            }
            if (this.bypassCost && this.cost.get() >= this.maximumRepairCost) {
                this.cost.set(this.maximumRepairCost - 1);
            }
            if (this.cost.get() >= this.maximumRepairCost && !this.player.hasInfiniteMaterials()) {
                itemStack = net.minecraft.world.item.ItemStack.EMPTY;
            }
            if (!itemStack.isEmpty()) {
                int minxx = itemStack.getOrDefault(DataComponents.REPAIR_COST, 0);
                if (minxx < item1.getOrDefault(DataComponents.REPAIR_COST, 0)) {
                    minxx = item1.getOrDefault(DataComponents.REPAIR_COST, 0);
                }
                if (i1 != i || i1 == 0) {
                    minxx = AnvilMenu.calculateIncreasedRepairCost(minxx);
                }
                itemStack.set(DataComponents.REPAIR_COST, minxx);
                EnchantmentHelper.setEnchantments(itemStack, mutable.toImmutable());
            }
            CraftEventFactory.callPrepareAnvilEvent(this.getBukkitView(), itemStack);
            this.broadcastChanges();
            if ((this.canDoUnsafeEnchants || PurpurConfig.allowInapplicableEnchants || PurpurConfig.allowIncompatibleEnchants) && itemStack != net.minecraft.world.item.ItemStack.EMPTY) {
                ((ServerPlayer)this.player).connection.send(new ClientboundContainerSetSlotPacket(this.containerId, this.incrementStateId(), 2, itemStack));
                ((ServerPlayer)this.player).connection.send(new ClientboundContainerSetDataPacket(this.containerId, 0, this.cost.get()));
            }
        } else {
            CraftEventFactory.callPrepareAnvilEvent(this.getBukkitView(), net.minecraft.world.item.ItemStack.EMPTY);
            this.cost.set(-1);
        }
        this.sendAllDataToRemote();
    }

    public static int calculateIncreasedRepairCost(int oldRepairCost) {
        return PurpurConfig.anvilCumulativeCost ? (int)Math.min((long)oldRepairCost * 2L + 1L, Integer.MAX_VALUE) : 0;
    }

    public boolean setItemName(String itemName) {
        String string = AnvilMenu.validateName(itemName);
        if (string != null && !string.equals(this.itemName)) {
            this.itemName = string;
            if (this.getSlot(2).hasItem()) {
                net.minecraft.world.item.ItemStack item = this.getSlot(2).getItem();
                if (StringUtil.isBlank(string)) {
                    item.remove(DataComponents.CUSTOM_NAME);
                } else {
                    item.set(DataComponents.CUSTOM_NAME, net.minecraft.network.chat.Component.literal(string));
                }
            }
            this.createResult();
            CraftEventFactory.callPrepareResultEvent(this, 2);
            return true;
        }
        return false;
    }

    @Nullable
    private static String validateName(String itemName) {
        String string = StringUtil.filterText(itemName);
        return string.length() <= 50 ? string : null;
    }

    public int getCost() {
        return this.cost.get();
    }

    @Override
    public CraftAnvilView getBukkitView() {
        if (this.bukkitEntity != null) {
            return this.bukkitEntity;
        }
        CraftInventoryAnvil inventory = new CraftInventoryAnvil(this.access.getLocation(), this.inputSlots, this.resultSlots);
        this.bukkitEntity = new CraftAnvilView((HumanEntity)this.player.getBukkitEntity(), inventory, this);
        this.bukkitEntity.updateFromLegacy(inventory);
        return this.bukkitEntity;
    }
}

