/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.craftbukkit.inventory.CraftInventoryGrindstone;
import org.bukkit.craftbukkit.inventory.CraftInventoryView;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.block.BlockExpEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.purpurmc.purpur.PurpurConfig;
import org.purpurmc.purpur.event.inventory.GrindstoneTakeResultEvent;

public class GrindstoneMenu
extends AbstractContainerMenu {
    @Nullable
    private CraftInventoryView view = null;
    private final org.bukkit.entity.Player player;
    public static final int MAX_NAME_LENGTH = 35;
    public static final int INPUT_SLOT = 0;
    public static final int ADDITIONAL_SLOT = 1;
    public static final int RESULT_SLOT = 2;
    private static final int INV_SLOT_START = 3;
    private static final int INV_SLOT_END = 30;
    private static final int USE_ROW_SLOT_START = 30;
    private static final int USE_ROW_SLOT_END = 39;
    private final Container resultSlots;
    final Container repairSlots;
    private final ContainerLevelAccess access;
    private List<DataComponentType<?>> GRINDSTONE_REMOVE_ATTRIBUTES_REMOVAL_LIST = List.of(DataComponents.CUSTOM_DATA, DataComponents.ATTRIBUTE_MODIFIERS, DataComponents.CUSTOM_MODEL_DATA, DataComponents.DYED_COLOR, DataComponents.SUSPICIOUS_STEW_EFFECTS);

    @Override
    public CraftInventoryView getBukkitView() {
        if (this.view != null) {
            return this.view;
        }
        CraftInventoryGrindstone inventory = new CraftInventoryGrindstone(this.repairSlots, this.resultSlots);
        this.view = new CraftInventoryView<GrindstoneMenu, CraftInventoryGrindstone>((HumanEntity)this.player, inventory, this);
        return this.view;
    }

    public GrindstoneMenu(int containerId, Inventory playerInventory) {
        this(containerId, playerInventory, ContainerLevelAccess.NULL);
    }

    public GrindstoneMenu(int containerId, Inventory playerInventory, final ContainerLevelAccess access) {
        super(MenuType.GRINDSTONE, containerId);
        this.resultSlots = new ResultContainer(this.createBlockHolder(access));
        this.repairSlots = new SimpleContainer(this.createBlockHolder(access), 2){

            @Override
            public void setChanged() {
                super.setChanged();
                GrindstoneMenu.this.slotsChanged(this);
            }

            @Override
            public Location getLocation() {
                return access.getLocation();
            }
        };
        this.access = access;
        this.addSlot(new Slot(this, this.repairSlots, 0, 49, 19){

            @Override
            public boolean mayPlace(net.minecraft.world.item.ItemStack stack) {
                return stack.isDamageableItem() || EnchantmentHelper.hasAnyEnchantments(stack);
            }
        });
        this.addSlot(new Slot(this, this.repairSlots, 1, 49, 40){

            @Override
            public boolean mayPlace(net.minecraft.world.item.ItemStack stack) {
                return stack.isDamageableItem() || EnchantmentHelper.hasAnyEnchantments(stack);
            }
        });
        this.addSlot(new Slot(this.resultSlots, 2, 129, 34){

            @Override
            public boolean mayPlace(net.minecraft.world.item.ItemStack stack) {
                return false;
            }

            @Override
            public void onTake(Player player, net.minecraft.world.item.ItemStack stack) {
                access.execute((level, blockPos) -> {
                    net.minecraft.world.item.ItemStack itemstack;
                    net.minecraft.world.item.ItemStack itemStack = itemstack = GrindstoneMenu.this.activeQuickItem == null ? stack : GrindstoneMenu.this.activeQuickItem;
                    if (level instanceof ServerLevel) {
                        BlockExpEvent event = new BlockExpEvent((Block)CraftBlock.at(level, blockPos), this.getExperienceAmount((Level)level));
                        event.callEvent();
                        GrindstoneTakeResultEvent grindstoneTakeResultEvent = new GrindstoneTakeResultEvent((HumanEntity)player.getBukkitEntity(), (InventoryView)GrindstoneMenu.this.getBukkitView(), (ItemStack)CraftItemStack.asCraftMirror(itemstack), event.getExpToDrop());
                        grindstoneTakeResultEvent.callEvent();
                        ExperienceOrb.awardWithDirection((ServerLevel)level, Vec3.atCenterOf(blockPos), Vec3.ZERO, grindstoneTakeResultEvent.getExperienceAmount(), ExperienceOrb.SpawnReason.GRINDSTONE, player, null);
                    }
                    level.levelEvent(1042, (BlockPos)blockPos, 0);
                });
                GrindstoneMenu.this.repairSlots.setItem(0, net.minecraft.world.item.ItemStack.EMPTY);
                GrindstoneMenu.this.repairSlots.setItem(1, net.minecraft.world.item.ItemStack.EMPTY);
            }

            private int getExperienceAmount(Level level) {
                int i = 0;
                i += this.getExperienceFromItem(GrindstoneMenu.this.repairSlots.getItem(0));
                if ((i += this.getExperienceFromItem(GrindstoneMenu.this.repairSlots.getItem(1))) > 0) {
                    int i1 = (int)Math.ceil((double)i / 2.0);
                    return i1 + level.random.nextInt(i1);
                }
                return 0;
            }

            private int getExperienceFromItem(net.minecraft.world.item.ItemStack stack) {
                int i = 0;
                ItemEnchantments enchantmentsForCrafting = EnchantmentHelper.getEnchantmentsForCrafting(stack);
                for (Object2IntMap.Entry<Holder<Enchantment>> entry : enchantmentsForCrafting.entrySet()) {
                    Holder holder = (Holder)entry.getKey();
                    int intValue = entry.getIntValue();
                    if (PurpurConfig.grindstoneIgnoredEnchants.contains(holder.value())) continue;
                    i += ((Enchantment)holder.value()).getMinCost(intValue);
                }
                return i;
            }
        });
        this.addStandardInventorySlots(playerInventory, 8, 84);
        this.player = (org.bukkit.entity.Player)playerInventory.player.getBukkitEntity();
    }

    @Override
    public void slotsChanged(Container inventory) {
        super.slotsChanged(inventory);
        if (inventory == this.repairSlots) {
            this.createResult();
            CraftEventFactory.callPrepareResultEvent(this, 2);
        }
    }

    private void createResult() {
        CraftEventFactory.callPrepareGrindstoneEvent(this.getBukkitView(), this.computeResult(this.repairSlots.getItem(0), this.repairSlots.getItem(1)));
        this.sendAllDataToRemote();
        this.broadcastChanges();
    }

    private net.minecraft.world.item.ItemStack computeResult(net.minecraft.world.item.ItemStack inputItem, net.minecraft.world.item.ItemStack additionalItem) {
        boolean flag;
        boolean bl = flag = !inputItem.isEmpty() || !additionalItem.isEmpty();
        if (!flag) {
            return net.minecraft.world.item.ItemStack.EMPTY;
        }
        if (inputItem.getCount() <= 1 && additionalItem.getCount() <= 1) {
            boolean flag1;
            boolean bl2 = flag1 = !inputItem.isEmpty() && !additionalItem.isEmpty();
            if (!flag1) {
                net.minecraft.world.item.ItemStack itemStack = !inputItem.isEmpty() ? inputItem : additionalItem;
                return !EnchantmentHelper.hasAnyEnchantments(itemStack) ? net.minecraft.world.item.ItemStack.EMPTY : this.removeNonCursesFrom(itemStack.copy());
            }
            return this.mergeItems(inputItem, additionalItem);
        }
        return net.minecraft.world.item.ItemStack.EMPTY;
    }

    private net.minecraft.world.item.ItemStack mergeItems(net.minecraft.world.item.ItemStack inputItem, net.minecraft.world.item.ItemStack additionalItem) {
        net.minecraft.world.item.ItemStack itemStack;
        if (!inputItem.is(additionalItem.getItem())) {
            return net.minecraft.world.item.ItemStack.EMPTY;
        }
        int max = Math.max(inputItem.getMaxDamage(), additionalItem.getMaxDamage());
        int i = inputItem.getMaxDamage() - inputItem.getDamageValue();
        int i1 = additionalItem.getMaxDamage() - additionalItem.getDamageValue();
        int i2 = i + i1 + max * 5 / 100;
        int i3 = 1;
        if (!inputItem.isDamageableItem()) {
            if (inputItem.getMaxStackSize() < 2 || !net.minecraft.world.item.ItemStack.matches(inputItem, additionalItem)) {
                return net.minecraft.world.item.ItemStack.EMPTY;
            }
            i3 = 2;
        }
        if ((itemStack = inputItem.copyWithCount(i3)).isDamageableItem()) {
            itemStack.set(DataComponents.MAX_DAMAGE, max);
            itemStack.setDamageValue(Math.max(max - i2, 0));
        }
        this.mergeEnchantsFrom(itemStack, additionalItem);
        return this.removeNonCursesFrom(itemStack);
    }

    private void mergeEnchantsFrom(net.minecraft.world.item.ItemStack inputItem, net.minecraft.world.item.ItemStack additionalItem) {
        EnchantmentHelper.updateEnchantments(inputItem, mutable -> {
            ItemEnchantments enchantmentsForCrafting = EnchantmentHelper.getEnchantmentsForCrafting(additionalItem);
            for (Object2IntMap.Entry<Holder<Enchantment>> entry : enchantmentsForCrafting.entrySet()) {
                Holder holder = (Holder)entry.getKey();
                if (PurpurConfig.grindstoneIgnoredEnchants.contains(holder.value()) && mutable.getLevel(holder) != 0) continue;
                mutable.upgrade(holder, entry.getIntValue());
            }
        });
    }

    private net.minecraft.world.item.ItemStack removeNonCursesFrom(net.minecraft.world.item.ItemStack item) {
        ItemEnchantments itemEnchantments = EnchantmentHelper.updateEnchantments(item, mutable -> mutable.removeIf(holder -> !PurpurConfig.grindstoneIgnoredEnchants.contains(holder.value())));
        if (item.is(Items.ENCHANTED_BOOK) && itemEnchantments.isEmpty()) {
            item = item.transmuteCopy(Items.BOOK);
        }
        int i = 0;
        for (int i1 = 0; i1 < itemEnchantments.size(); ++i1) {
            i = AnvilMenu.calculateIncreasedRepairCost(i);
        }
        item.set(DataComponents.REPAIR_COST, i);
        DataComponentPatch.Builder builder = DataComponentPatch.builder();
        if (PurpurConfig.grindstoneRemoveAttributes) {
            item.getComponents().forEach(typedDataComponent -> {
                if (this.GRINDSTONE_REMOVE_ATTRIBUTES_REMOVAL_LIST.contains(typedDataComponent.type())) {
                    builder.remove(typedDataComponent.type());
                }
            });
        }
        if (PurpurConfig.grindstoneRemoveDisplay) {
            builder.remove(DataComponents.CUSTOM_NAME);
            builder.remove(DataComponents.LORE);
        }
        item.applyComponents(builder.build());
        return item;
    }

    @Override
    public void removed(Player player) {
        super.removed(player);
        this.access.execute((level, blockPos) -> this.clearContainer(player, this.repairSlots));
    }

    @Override
    public boolean stillValid(Player player) {
        if (!this.checkReachable) {
            return true;
        }
        return GrindstoneMenu.stillValid(this.access, player, Blocks.GRINDSTONE);
    }

    @Override
    public net.minecraft.world.item.ItemStack quickMoveStack(Player player, int slotIndex) {
        net.minecraft.world.item.ItemStack itemStack = net.minecraft.world.item.ItemStack.EMPTY;
        Slot slot = this.slots.get(slotIndex);
        if (slot != null && slot.hasItem()) {
            net.minecraft.world.item.ItemStack item = slot.getItem();
            itemStack = item.copy();
            net.minecraft.world.item.ItemStack item1 = this.repairSlots.getItem(0);
            net.minecraft.world.item.ItemStack item2 = this.repairSlots.getItem(1);
            if (slotIndex == 2) {
                if (!this.moveItemStackTo(item, 3, 39, true)) {
                    return net.minecraft.world.item.ItemStack.EMPTY;
                }
                slot.onQuickCraft(item, itemStack);
            } else if (slotIndex != 0 && slotIndex != 1 ? (!item1.isEmpty() && !item2.isEmpty() ? (slotIndex >= 3 && slotIndex < 30 ? !this.moveItemStackTo(item, 30, 39, false) : slotIndex >= 30 && slotIndex < 39 && !this.moveItemStackTo(item, 3, 30, false)) : !this.moveItemStackTo(item, 0, 2, false)) : !this.moveItemStackTo(item, 3, 39, false)) {
                return net.minecraft.world.item.ItemStack.EMPTY;
            }
            if (item.isEmpty()) {
                slot.setByPlayer(net.minecraft.world.item.ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (item.getCount() == itemStack.getCount()) {
                return net.minecraft.world.item.ItemStack.EMPTY;
            }
            this.activeQuickItem = itemStack;
            slot.onTake(player, item);
            this.activeQuickItem = null;
        }
        return itemStack;
    }
}

