/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.end.EndDragonFight;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import org.bukkit.craftbukkit.event.CraftEventFactory;

public class EndCrystalItem
extends Item {
    public EndCrystalItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public InteractionResult useOn(UseOnContext context) {
        double d2;
        double d1;
        BlockPos blockPos;
        Level level = context.getLevel();
        BlockPos clickedPos = context.getClickedPos();
        BlockState blockState = level.getBlockState(clickedPos);
        if (!(level.purpurConfig.endCrystalPlaceAnywhere || blockState.is(Blocks.OBSIDIAN) || blockState.is(Blocks.BEDROCK))) {
            return InteractionResult.FAIL;
        }
        BlockPos aboveBlockPos = blockPos = clickedPos.above();
        if (!level.isEmptyBlock(blockPos)) {
            return InteractionResult.FAIL;
        }
        double d = blockPos.getX();
        List<Entity> entities = level.getEntities(null, new AABB(d, d1 = (double)blockPos.getY(), d2 = (double)blockPos.getZ(), d + 1.0, d1 + 2.0, d2 + 1.0));
        if (!entities.isEmpty()) {
            return InteractionResult.FAIL;
        }
        if (level instanceof ServerLevel) {
            EndCrystal endCrystal = new EndCrystal(level, d + 0.5, d1, d2 + 0.5);
            endCrystal.setShowBottom(false);
            if (CraftEventFactory.callEntityPlaceEvent(context, endCrystal).isCancelled()) {
                if (context.getPlayer() != null) {
                    context.getPlayer().containerMenu.sendAllDataToRemote();
                }
                return InteractionResult.FAIL;
            }
            level.addFreshEntity(endCrystal);
            level.gameEvent((Entity)context.getPlayer(), GameEvent.ENTITY_PLACE, blockPos);
            EndDragonFight dragonFight = ((ServerLevel)level).getDragonFight();
            if (dragonFight != null) {
                dragonFight.tryRespawn(aboveBlockPos);
            }
        }
        context.getItemInHand().shrink(1);
        return InteractionResult.SUCCESS;
    }
}

