/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.CraftEquipmentSlot;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.block.data.CraftBlockData;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockCanBuildEvent;

public class StandingAndWallBlockItem
extends BlockItem {
    public final Block wallBlock;
    private final Direction attachmentDirection;

    public StandingAndWallBlockItem(Block block, Block wallBlock, Direction attachmentDirection, Item.Properties properties) {
        super(block, properties);
        this.wallBlock = wallBlock;
        this.attachmentDirection = attachmentDirection;
    }

    protected boolean canPlace(LevelReader level, BlockState state, BlockPos pos) {
        return state.canSurvive(level, pos);
    }

    @Override
    @Nullable
    protected BlockState getPlacementState(BlockPlaceContext context) {
        BlockState stateForPlacement = this.wallBlock.getStateForPlacement(context);
        BlockState blockState = null;
        Level level = context.getLevel();
        BlockPos clickedPos = context.getClickedPos();
        for (Direction direction : context.getNearestLookingDirections()) {
            BlockState blockState1;
            if (direction == this.attachmentDirection.getOpposite()) continue;
            BlockState blockState2 = blockState1 = direction == this.attachmentDirection ? this.getBlock().getStateForPlacement(context) : stateForPlacement;
            if (blockState1 == null || !this.canPlace(level, blockState1, clickedPos)) continue;
            blockState = blockState1;
            break;
        }
        if (blockState != null) {
            CraftPlayer craftPlayer;
            boolean defaultReturn = level.isUnobstructed(blockState, clickedPos, CollisionContext.empty());
            Player player = context.getPlayer();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                craftPlayer = serverPlayer.getBukkitEntity();
            } else {
                craftPlayer = null;
            }
            CraftPlayer player2 = craftPlayer;
            BlockCanBuildEvent event = new BlockCanBuildEvent((org.bukkit.block.Block)CraftBlock.at(context.getLevel(), clickedPos), (org.bukkit.entity.Player)player2, (BlockData)CraftBlockData.fromData(blockState), defaultReturn, CraftEquipmentSlot.getHand(context.getHand()));
            context.getLevel().getCraftServer().getPluginManager().callEvent((Event)event);
            return event.isBuildable() ? blockState : null;
        }
        return null;
    }

    @Override
    public void registerBlocks(Map<Block, Item> blockToItemMap, Item item) {
        super.registerBlocks(blockToItemMap, item);
        blockToItemMap.put(this.wallBlock, item);
    }
}

