/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ConsumableListener;
import net.minecraft.world.item.consume_effects.ConsumeEffect;
import net.minecraft.world.item.consume_effects.PlaySoundConsumeEffect;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;

public record Consumable(float consumeSeconds, ItemUseAnimation animation, Holder<SoundEvent> sound, boolean hasConsumeParticles, List<ConsumeEffect> onConsumeEffects) {
    public static final float DEFAULT_CONSUME_SECONDS = 1.6f;
    private static final int CONSUME_EFFECTS_INTERVAL = 4;
    private static final float CONSUME_EFFECTS_START_FRACTION = 0.21875f;
    public static final Codec<Consumable> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.NON_NEGATIVE_FLOAT.optionalFieldOf("consume_seconds", (Object)Float.valueOf(1.6f)).forGetter(Consumable::consumeSeconds), (App)ItemUseAnimation.CODEC.optionalFieldOf("animation", (Object)ItemUseAnimation.EAT).forGetter(Consumable::animation), (App)SoundEvent.CODEC.optionalFieldOf("sound", SoundEvents.GENERIC_EAT).forGetter(Consumable::sound), (App)Codec.BOOL.optionalFieldOf("has_consume_particles", (Object)true).forGetter(Consumable::hasConsumeParticles), (App)ConsumeEffect.CODEC.listOf().optionalFieldOf("on_consume_effects", List.of()).forGetter(Consumable::onConsumeEffects)).apply((Applicative)instance, Consumable::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, Consumable> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.FLOAT, Consumable::consumeSeconds, ItemUseAnimation.STREAM_CODEC, Consumable::animation, SoundEvent.STREAM_CODEC, Consumable::sound, ByteBufCodecs.BOOL, Consumable::hasConsumeParticles, ConsumeEffect.STREAM_CODEC.apply(ByteBufCodecs.list()), Consumable::onConsumeEffects, Consumable::new);

    public InteractionResult startConsuming(LivingEntity entity, ItemStack stack, InteractionHand hand) {
        boolean flag;
        if (!this.canConsume(entity, stack)) {
            return InteractionResult.FAIL;
        }
        boolean bl = flag = this.consumeTicks() > 0;
        if (flag) {
            entity.startUsingItem(hand);
            return InteractionResult.CONSUME;
        }
        ItemStack itemStack = this.onConsume(entity.level(), entity, stack);
        return InteractionResult.CONSUME.heldItemTransformedTo(itemStack);
    }

    public ItemStack onConsume(Level level, LivingEntity entity, ItemStack stack) {
        RandomSource random = entity.getRandom();
        this.emitParticlesAndSounds(random, entity, stack, 16);
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            serverPlayer.awardStat(Stats.ITEM_USED.get(stack.getItem()));
            CriteriaTriggers.CONSUME_ITEM.trigger(serverPlayer, stack);
        }
        stack.getAllOfType(ConsumableListener.class).forEach(consumableListener -> consumableListener.onConsume(level, entity, stack, this));
        if (!level.isClientSide()) {
            EntityPotionEffectEvent.Cause cause = stack.is(Items.MILK_BUCKET) ? EntityPotionEffectEvent.Cause.MILK : (stack.is(Items.POTION) ? EntityPotionEffectEvent.Cause.POTION_DRINK : EntityPotionEffectEvent.Cause.FOOD);
            this.onConsumeEffects.forEach(consumeEffect -> consumeEffect.apply(level, stack, entity, cause));
        }
        entity.gameEvent(this.animation == ItemUseAnimation.DRINK ? GameEvent.DRINK : GameEvent.EAT);
        stack.consume(1, entity);
        return stack;
    }

    public void cancelUsingItem(ServerPlayer player, ItemStack stack) {
        ObjectArrayList packets = new ObjectArrayList();
        stack.getAllOfType(ConsumableListener.class).forEach(arg_0 -> Consumable.lambda$cancelUsingItem$3(player, stack, (List)packets, arg_0));
        player.level().getServer().getPlayerList().sendActiveEffects((LivingEntity)player, ((List)packets)::add);
        player.connection.send(new ClientboundBundlePacket((Iterable<Packet<? super ClientGamePacketListener>>)packets));
    }

    public boolean canConsume(LivingEntity entity, ItemStack stack) {
        Player player;
        FoodProperties foodProperties = stack.get(DataComponents.FOOD);
        return foodProperties == null || !(entity instanceof Player) || (player = (Player)entity).canEat(foodProperties.canAlwaysEat());
    }

    public int consumeTicks() {
        return (int)(this.consumeSeconds * 20.0f);
    }

    public void emitParticlesAndSounds(RandomSource random, LivingEntity entity, ItemStack stack, int amount) {
        SoundEvent soundEvent;
        float f5;
        float f = random.nextBoolean() ? 0.5f : 1.0f;
        float f1 = random.triangle(1.0f, 0.2f);
        float f2 = 0.5f;
        float f3 = Mth.randomBetween(random, 0.9f, 1.0f);
        float f4 = this.animation == ItemUseAnimation.DRINK ? 0.5f : f;
        float f6 = f5 = this.animation == ItemUseAnimation.DRINK ? f3 : f1;
        if (this.hasConsumeParticles) {
            entity.spawnItemParticles(stack, amount);
        }
        if (entity instanceof OverrideConsumeSound) {
            OverrideConsumeSound overrideConsumeSound = (OverrideConsumeSound)((Object)entity);
            soundEvent = overrideConsumeSound.getConsumeSound(stack);
        } else {
            soundEvent = this.sound.value();
        }
        SoundEvent soundEvent2 = soundEvent;
        entity.playSound(soundEvent2, f4, f5);
    }

    public boolean shouldEmitParticlesAndSounds(int remainingUseDuration) {
        int i1;
        int i = this.consumeTicks() - remainingUseDuration;
        boolean flag = i > (i1 = (int)((float)this.consumeTicks() * 0.21875f));
        return flag && remainingUseDuration % 4 == 0;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static /* synthetic */ void lambda$cancelUsingItem$3(ServerPlayer player, ItemStack stack, List packets, ConsumableListener listener) {
        listener.cancelUsingItem(player, stack, packets);
    }

    public static interface OverrideConsumeSound {
        public SoundEvent getConsumeSound(ItemStack var1);
    }

    public static class Builder {
        private float consumeSeconds = 1.6f;
        private ItemUseAnimation animation = ItemUseAnimation.EAT;
        private Holder<SoundEvent> sound = SoundEvents.GENERIC_EAT;
        private boolean hasConsumeParticles = true;
        private final List<ConsumeEffect> onConsumeEffects = new ArrayList<ConsumeEffect>();

        Builder() {
        }

        public Builder consumeSeconds(float consumeSeconds) {
            this.consumeSeconds = consumeSeconds;
            return this;
        }

        public Builder animation(ItemUseAnimation animation) {
            this.animation = animation;
            return this;
        }

        public Builder sound(Holder<SoundEvent> sound) {
            this.sound = sound;
            return this;
        }

        public Builder soundAfterConsume(Holder<SoundEvent> consumptionSound) {
            return this.onConsume(new PlaySoundConsumeEffect(consumptionSound));
        }

        public Builder hasConsumeParticles(boolean hasConsumeParticles) {
            this.hasConsumeParticles = hasConsumeParticles;
            return this;
        }

        public Builder onConsume(ConsumeEffect effect) {
            this.onConsumeEffects.add(effect);
            return this;
        }

        public Consumable build() {
            return new Consumable(this.consumeSeconds, this.animation, this.sound, this.hasConsumeParticles, this.onConsumeEffects);
        }
    }
}

