/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.mojang.serialization.Codec;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;

public record UseRemainder(ItemStack convertInto) {
    public static final Codec<UseRemainder> CODEC = ItemStack.CODEC.xmap(UseRemainder::new, UseRemainder::convertInto);
    public static final StreamCodec<RegistryFriendlyByteBuf, UseRemainder> STREAM_CODEC = StreamCodec.composite(ItemStack.STREAM_CODEC.apply(ByteBufCodecs::increaseDepth), UseRemainder::convertInto, UseRemainder::new);

    public ItemStack convertIntoRemainder(ItemStack stack, int count, boolean hasInfiniteMaterials, OnExtraCreatedRemainder onExtraCreated) {
        if (hasInfiniteMaterials) {
            return stack;
        }
        if (stack.getCount() >= count) {
            return stack;
        }
        ItemStack itemStack = this.convertInto.copy();
        if (stack.isEmpty()) {
            return itemStack;
        }
        onExtraCreated.apply(itemStack);
        return stack;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other != null && this.getClass() == other.getClass()) {
            UseRemainder useRemainder = (UseRemainder)other;
            return ItemStack.matches(this.convertInto, useRemainder.convertInto);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return ItemStack.hashItemAndComponents(this.convertInto);
    }

    @FunctionalInterface
    public static interface OnExtraCreatedRemainder {
        public void apply(ItemStack var1);
    }
}

