/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.mojang.serialization.Codec;
import io.papermc.paper.inventory.recipe.ItemOrExact;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.HolderSetCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemStackLinkedSet;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.level.ItemLike;

public final class Ingredient
implements StackedContents.IngredientInfo<ItemOrExact>,
Predicate<ItemStack> {
    public static final StreamCodec<RegistryFriendlyByteBuf, Ingredient> CONTENTS_STREAM_CODEC = ByteBufCodecs.holderSet(Registries.ITEM).map(Ingredient::new, ingredient -> ingredient.values);
    public static final StreamCodec<RegistryFriendlyByteBuf, Optional<Ingredient>> OPTIONAL_CONTENTS_STREAM_CODEC = ByteBufCodecs.holderSet(Registries.ITEM).map(items -> items.size() == 0 ? Optional.empty() : Optional.of(new Ingredient((HolderSet<Item>)items)), optional -> optional.map(ingredient -> ingredient.values).orElse(HolderSet.direct(new Holder[0])));
    public static final Codec<HolderSet<Item>> NON_AIR_HOLDER_SET_CODEC = HolderSetCodec.create(Registries.ITEM, Item.CODEC, false);
    public static final Codec<Ingredient> CODEC = ExtraCodecs.nonEmptyHolderSet(NON_AIR_HOLDER_SET_CODEC).xmap(Ingredient::new, ingredient -> ingredient.values);
    private final HolderSet<Item> values;
    @Nullable
    private Set<ItemStack> itemStacks;
    public Predicate<org.bukkit.inventory.ItemStack> predicate;

    public boolean isExact() {
        return this.itemStacks != null;
    }

    @Nullable
    public Set<ItemStack> itemStacks() {
        return this.itemStacks;
    }

    public static Ingredient ofStacks(List<ItemStack> stacks) {
        Ingredient recipe = Ingredient.of(stacks.stream().map(ItemStack::getItem));
        recipe.itemStacks = ItemStackLinkedSet.createTypeAndComponentsSet();
        recipe.itemStacks.addAll(stacks);
        recipe.itemStacks = Collections.unmodifiableSet(recipe.itemStacks);
        return recipe;
    }

    private Ingredient(HolderSet<Item> values) {
        values.unwrap().ifRight(list -> {
            if (list.isEmpty()) {
                throw new UnsupportedOperationException("Ingredients can't be empty");
            }
            if (list.contains(Items.AIR.builtInRegistryHolder())) {
                throw new UnsupportedOperationException("Ingredient can't contain air");
            }
        });
        this.values = values;
    }

    public static boolean testOptionalIngredient(Optional<Ingredient> ingredient, ItemStack stack) {
        return ingredient.map(ingredient1 -> ingredient1.test(stack)).orElseGet(stack::isEmpty);
    }

    @Deprecated
    public Stream<Holder<Item>> items() {
        return this.values.stream();
    }

    public boolean isEmpty() {
        return this.values.size() == 0;
    }

    @Override
    public boolean test(ItemStack stack) {
        if (this.isExact()) {
            return this.itemStacks.contains(stack);
        }
        if (this.predicate != null) {
            return this.predicate.test(stack.asBukkitCopy());
        }
        return stack.is(this.values);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean acceptsItem(ItemOrExact itemOrExact) {
        ItemOrExact itemOrExact2 = itemOrExact;
        Objects.requireNonNull(itemOrExact2);
        ItemOrExact itemOrExact3 = itemOrExact2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ItemOrExact.Item.class, ItemOrExact.Exact.class}, (Object)itemOrExact3, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                ItemOrExact.Item item = (ItemOrExact.Item)itemOrExact3;
                try {
                    Holder<Item> holder;
                    Holder<Item> item2 = holder = item.item();
                    if (this.isExact()) return false;
                    if (!this.values.contains(item2)) return false;
                    return true;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            case 1: 
        }
        ItemOrExact.Exact exact = (ItemOrExact.Exact)itemOrExact3;
        {
            ItemStack itemStack;
            ItemStack exact2 = itemStack = exact.stack();
            if (!this.isExact()) return false;
            if (!this.itemStacks.contains(exact2)) return false;
            return true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (!(other instanceof Ingredient)) return false;
        Ingredient ingredient = (Ingredient)other;
        if (!Objects.equals(this.values, ingredient.values)) return false;
        if (!Objects.equals(this.itemStacks, ingredient.itemStacks)) return false;
        return true;
    }

    public static Ingredient of(ItemLike item) {
        return new Ingredient(HolderSet.direct(item.asItem().builtInRegistryHolder()));
    }

    public static Ingredient of(ItemLike ... items) {
        return Ingredient.of(Arrays.stream(items));
    }

    public static Ingredient of(Stream<? extends ItemLike> items) {
        return new Ingredient(HolderSet.direct(items.map(item -> item.asItem().builtInRegistryHolder()).toList()));
    }

    public static Ingredient of(HolderSet<Item> items) {
        return new Ingredient(items);
    }

    public SlotDisplay display() {
        if (this.isExact()) {
            return new SlotDisplay.Composite(this.itemStacks().stream().map(SlotDisplay.ItemStackSlotDisplay::new).toList());
        }
        return (SlotDisplay)((Object)this.values.unwrap().map(SlotDisplay.TagSlotDisplay::new, list -> new SlotDisplay.Composite(list.stream().map(Ingredient::displayForSingleItem).toList())));
    }

    public static SlotDisplay optionalIngredientToDisplay(Optional<Ingredient> ingredient) {
        return ingredient.map(Ingredient::display).orElse(SlotDisplay.Empty.INSTANCE);
    }

    private static SlotDisplay displayForSingleItem(Holder<Item> item) {
        SlotDisplay.ItemSlotDisplay slotDisplay = new SlotDisplay.ItemSlotDisplay(item);
        ItemStack craftingRemainder = item.value().getCraftingRemainder();
        if (!craftingRemainder.isEmpty()) {
            SlotDisplay.ItemStackSlotDisplay slotDisplay1 = new SlotDisplay.ItemStackSlotDisplay(craftingRemainder);
            return new SlotDisplay.WithRemainder(slotDisplay, slotDisplay1);
        }
        return slotDisplay;
    }
}

