/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment.effects;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Function;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.item.enchantment.effects.EnchantmentLocationBasedEffect;
import net.minecraft.world.item.enchantment.effects.EnchantmentValueEffect;
import net.minecraft.world.phys.Vec3;

public interface AllOf {
    public static <T, A extends T> MapCodec<A> codec(Codec<T> codec, Function<List<T>, A> getter, Function<A, List<T>> factory) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)codec.listOf().fieldOf("effects").forGetter(factory)).apply((Applicative)instance, getter));
    }

    public static EntityEffects entityEffects(EnchantmentEntityEffect ... effects) {
        return new EntityEffects(List.of(effects));
    }

    public static LocationBasedEffects locationBasedEffects(EnchantmentLocationBasedEffect ... effects) {
        return new LocationBasedEffects(List.of(effects));
    }

    public static ValueEffects valueEffects(EnchantmentValueEffect ... effects) {
        return new ValueEffects(List.of(effects));
    }

    public record EntityEffects(List<EnchantmentEntityEffect> effects) implements EnchantmentEntityEffect
    {
        public static final MapCodec<EntityEffects> CODEC = AllOf.codec(EnchantmentEntityEffect.CODEC, EntityEffects::new, EntityEffects::effects);

        @Override
        public void apply(ServerLevel level, int enchantmentLevel, EnchantedItemInUse item, Entity entity, Vec3 origin) {
            for (EnchantmentEntityEffect enchantmentEntityEffect : this.effects) {
                enchantmentEntityEffect.apply(level, enchantmentLevel, item, entity, origin);
            }
        }

        public MapCodec<EntityEffects> codec() {
            return CODEC;
        }
    }

    public record LocationBasedEffects(List<EnchantmentLocationBasedEffect> effects) implements EnchantmentLocationBasedEffect
    {
        public static final MapCodec<LocationBasedEffects> CODEC = AllOf.codec(EnchantmentLocationBasedEffect.CODEC, LocationBasedEffects::new, LocationBasedEffects::effects);

        @Override
        public void onChangedBlock(ServerLevel level, int enchantmentLevel, EnchantedItemInUse item, Entity entity, Vec3 pos, boolean applyTransientEffects) {
            for (EnchantmentLocationBasedEffect enchantmentLocationBasedEffect : this.effects) {
                enchantmentLocationBasedEffect.onChangedBlock(level, enchantmentLevel, item, entity, pos, applyTransientEffects);
            }
        }

        @Override
        public void onDeactivated(EnchantedItemInUse item, Entity entity, Vec3 pos, int enchantmentLevel) {
            for (EnchantmentLocationBasedEffect enchantmentLocationBasedEffect : this.effects) {
                enchantmentLocationBasedEffect.onDeactivated(item, entity, pos, enchantmentLevel);
            }
        }

        public MapCodec<LocationBasedEffects> codec() {
            return CODEC;
        }
    }

    public record ValueEffects(List<EnchantmentValueEffect> effects) implements EnchantmentValueEffect
    {
        public static final MapCodec<ValueEffects> CODEC = AllOf.codec(EnchantmentValueEffect.CODEC, ValueEffects::new, ValueEffects::effects);

        @Override
        public float process(int enchantmentLevel, RandomSource random, float value) {
            for (EnchantmentValueEffect enchantmentValueEffect : this.effects) {
                value = enchantmentValueEffect.process(enchantmentLevel, random, value);
            }
            return value;
        }

        public MapCodec<ValueEffects> codec() {
            return CODEC;
        }
    }
}

