/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.level.block.entity.DropperBlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.craftbukkit.inventory.CraftInventoryDoubleChest;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.slf4j.Logger;

public class DropperBlock
extends DispenserBlock {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final MapCodec<DropperBlock> CODEC = DropperBlock.simpleCodec(DropperBlock::new);
    private static final DispenseItemBehavior DISPENSE_BEHAVIOUR = new DefaultDispenseItemBehavior();

    public MapCodec<DropperBlock> codec() {
        return CODEC;
    }

    public DropperBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    protected DispenseItemBehavior getDispenseMethod(Level level, net.minecraft.world.item.ItemStack item) {
        return DISPENSE_BEHAVIOUR;
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new DropperBlockEntity(pos, state);
    }

    @Override
    public void dispenseFrom(ServerLevel level, BlockState state, BlockPos pos) {
        DispenserBlockEntity dispenserBlockEntity = level.getBlockEntity(pos, BlockEntityType.DROPPER).orElse(null);
        if (dispenserBlockEntity == null) {
            LOGGER.warn("Ignoring dispensing attempt for Dropper without matching block entity at {}", (Object)pos);
        } else {
            BlockSource blockSource = new BlockSource(level, pos, state, dispenserBlockEntity);
            int randomSlot = dispenserBlockEntity.getRandomSlot(level.random);
            if (randomSlot < 0) {
                if (CraftEventFactory.handleBlockFailedDispenseEvent(level, pos)) {
                    level.levelEvent(1001, pos, 0);
                }
            } else {
                net.minecraft.world.item.ItemStack item = dispenserBlockEntity.getItem(randomSlot);
                if (!item.isEmpty()) {
                    net.minecraft.world.item.ItemStack itemStack;
                    Direction direction = level.getBlockState(pos).getValue(DispenserBlock.FACING);
                    Container containerAt = HopperBlockEntity.getContainerAt(level, pos.relative(direction));
                    if (containerAt == null) {
                        if (!CraftEventFactory.handleBlockPreDispenseEvent(level, pos, item, randomSlot)) {
                            return;
                        }
                        itemStack = DISPENSE_BEHAVIOUR.dispense(blockSource, item);
                    } else {
                        Inventory destinationInventory;
                        CraftItemStack oitemstack = CraftItemStack.asCraftMirror(item.copyWithCount(1));
                        if (containerAt instanceof CompoundContainer) {
                            CompoundContainer compoundContainer = (CompoundContainer)containerAt;
                            destinationInventory = new CraftInventoryDoubleChest(compoundContainer);
                        } else {
                            destinationInventory = containerAt.getOwner().getInventory();
                        }
                        InventoryMoveItemEvent event = new InventoryMoveItemEvent(dispenserBlockEntity.getOwner().getInventory(), (ItemStack)oitemstack, destinationInventory, true);
                        level.getCraftServer().getPluginManager().callEvent((Event)event);
                        if (event.isCancelled()) {
                            return;
                        }
                        itemStack = HopperBlockEntity.addItem(dispenserBlockEntity, containerAt, CraftItemStack.asNMSCopy(event.getItem()), direction.getOpposite());
                        if (event.getItem().equals((Object)oitemstack) && itemStack.isEmpty()) {
                            itemStack = item.copy();
                            itemStack.shrink(1);
                        } else {
                            itemStack = item.copy();
                        }
                    }
                    dispenserBlockEntity.setItem(randomSlot, itemStack);
                }
            }
        }
    }
}

