/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import io.papermc.paper.adventure.PaperAdventure;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import org.slf4j.Logger;

public class SpawnerBlock
extends BaseEntityBlock {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final MapCodec<SpawnerBlock> CODEC = SpawnerBlock.simpleCodec(SpawnerBlock::new);

    public MapCodec<SpawnerBlock> codec() {
        return CODEC;
    }

    protected SpawnerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new SpawnerBlockEntity(pos, state);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return SpawnerBlock.createTickerHelper(blockEntityType, BlockEntityType.MOB_SPAWNER, level.isClientSide() ? SpawnerBlockEntity::clientTick : SpawnerBlockEntity::serverTick);
    }

    @Override
    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack stack, boolean includeDrops, boolean dropExp) {
        if (level.purpurConfig.silkTouchEnabled && player.getBukkitEntity().hasPermission("purpur.drop.spawners") && this.isSilkTouch(level, stack)) {
            SpawnData spawnData;
            ItemStack item = new ItemStack(Blocks.SPAWNER.asItem());
            if (blockEntity instanceof SpawnerBlockEntity) {
                SpawnerBlockEntity spawnerBlock = (SpawnerBlockEntity)blockEntity;
                spawnData = spawnerBlock.getSpawner().nextSpawnData;
            } else {
                spawnData = null;
            }
            SpawnData nextSpawnData = spawnData;
            Optional<Object> type = Optional.empty();
            if (nextSpawnData != null) {
                try (ProblemReporter.ScopedCollector scopedCollector = new ProblemReporter.ScopedCollector(blockEntity.problemPath(), LOGGER);){
                    ValueInput valueInput = TagValueInput.create((ProblemReporter)scopedCollector, (HolderLookup.Provider)player.level().registryAccess(), nextSpawnData.entityToSpawn());
                    type = EntityType.by(valueInput);
                }
                CompoundTag spawnDataTag = new CompoundTag();
                spawnDataTag.storeNullable("SpawnData", SpawnData.CODEC, nextSpawnData);
                item.set(DataComponents.CUSTOM_DATA, CustomData.EMPTY.update(compoundTag -> compoundTag.put("Purpur.SpawnData", spawnDataTag)));
            }
            if (type.isPresent()) {
                List<String> lore;
                net.kyori.adventure.text.Component mobName = PaperAdventure.asAdventure(((EntityType)type.get()).getDescription());
                String name = level.purpurConfig.silkTouchSpawnerName;
                if (name != null && !name.isEmpty() && !name.equals("Monster Spawner")) {
                    net.kyori.adventure.text.Component displayName = MiniMessage.miniMessage().deserialize(name, (TagResolver)Placeholder.component((String)"mob", (ComponentLike)mobName));
                    if (name.startsWith("<reset>")) {
                        displayName = displayName.decoration(TextDecoration.ITALIC, false);
                    }
                    item.set(DataComponents.CUSTOM_NAME, PaperAdventure.asVanilla(displayName));
                }
                if ((lore = level.purpurConfig.silkTouchSpawnerLore) != null && !lore.isEmpty()) {
                    ArrayList<Component> loreComponentList = new ArrayList<Component>();
                    for (String line : lore) {
                        net.kyori.adventure.text.Component lineComponent = MiniMessage.miniMessage().deserialize(line, (TagResolver)Placeholder.component((String)"mob", (ComponentLike)mobName));
                        if (line.startsWith("<reset>")) {
                            lineComponent = lineComponent.decoration(TextDecoration.ITALIC, false);
                        }
                        loreComponentList.add(PaperAdventure.asVanilla(lineComponent));
                    }
                    item.set(DataComponents.LORE, new ItemLore(loreComponentList, loreComponentList));
                }
                item.set(DataComponents.TOOLTIP_DISPLAY, TooltipDisplay.DEFAULT.withHidden(DataComponents.BLOCK_ENTITY_DATA, true));
            }
            SpawnerBlock.popResource(level, pos, item);
        }
        super.playerDestroy(level, player, pos, state, blockEntity, stack, includeDrops, dropExp);
    }

    private boolean isSilkTouch(Level level, ItemStack stack) {
        return stack != null && level.purpurConfig.silkTouchTools.contains(stack.getItem()) && EnchantmentHelper.getItemEnchantmentLevel(Enchantments.SILK_TOUCH, stack) >= level.purpurConfig.minimumSilkTouchSpawnerRequire;
    }

    @Override
    protected void spawnAfterBreak(BlockState state, ServerLevel level, BlockPos pos, ItemStack stack, boolean dropExperience) {
        super.spawnAfterBreak(state, level, pos, stack, dropExperience);
    }

    @Override
    public int getExpDrop(BlockState state, ServerLevel level, BlockPos pos, ItemStack stack, boolean dropExperience) {
        if (level.purpurConfig.silkTouchEnabled && this.isSilkTouch(level, stack)) {
            return 0;
        }
        if (dropExperience) {
            int i = 15 + level.random.nextInt(15) + level.random.nextInt(15);
            return i;
        }
        return 0;
    }
}

