/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.base.MoreObjects;
import com.mojang.serialization.MapCodec;
import io.papermc.paper.configuration.GlobalConfiguration;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.TripWireBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.event.block.BlockRedstoneEvent;

public class TripWireHookBlock
extends Block {
    public static final MapCodec<TripWireHookBlock> CODEC = TripWireHookBlock.simpleCodec(TripWireHookBlock::new);
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty ATTACHED = BlockStateProperties.ATTACHED;
    protected static final int WIRE_DIST_MIN = 1;
    protected static final int WIRE_DIST_MAX = 42;
    private static final int RECHECK_PERIOD = 10;
    private static final Map<Direction, VoxelShape> SHAPES = Shapes.rotateHorizontal(Block.boxZ(6.0, 0.0, 10.0, 10.0, 16.0));

    public MapCodec<TripWireHookBlock> codec() {
        return CODEC;
    }

    public TripWireHookBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any().setValue(FACING, Direction.NORTH)).setValue(POWERED, false)).setValue(ATTACHED, false));
    }

    @Override
    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPES.get(state.getValue(FACING));
    }

    @Override
    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = state.getValue(FACING);
        BlockPos blockPos = pos.relative(direction.getOpposite());
        BlockState blockState = level.getBlockState(blockPos);
        return direction.getAxis().isHorizontal() && blockState.isFaceSturdy(level, blockPos, direction);
    }

    @Override
    protected BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess scheduledTickAccess, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource random) {
        return direction.getOpposite() == state.getValue(FACING) && !state.canSurvive(level, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction[] nearestLookingDirections;
        BlockState blockState = (BlockState)((BlockState)this.defaultBlockState().setValue(POWERED, false)).setValue(ATTACHED, false);
        Level level = context.getLevel();
        BlockPos clickedPos = context.getClickedPos();
        for (Direction direction : nearestLookingDirections = context.getNearestLookingDirections()) {
            Direction opposite;
            if (!direction.getAxis().isHorizontal() || !(blockState = (BlockState)blockState.setValue(FACING, opposite = direction.getOpposite())).canSurvive(level, clickedPos)) continue;
            return blockState;
        }
        return null;
    }

    @Override
    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TripWireHookBlock.calculateState(level, pos, state, false, false, -1, null);
    }

    public static void calculateState(Level level, BlockPos pos, BlockState hookState, boolean attaching, boolean shouldNotifyNeighbours, int searchRange, @Nullable BlockState state) {
        Optional<Direction> optionalValue = hookState.getOptionalValue(FACING);
        if (optionalValue.isPresent()) {
            Direction direction = optionalValue.get();
            boolean flag = hookState.getOptionalValue(ATTACHED).orElse(false);
            boolean flag1 = hookState.getOptionalValue(POWERED).orElse(false);
            Block block = hookState.getBlock();
            boolean flag2 = !attaching;
            boolean flag3 = false;
            int i = 0;
            BlockState[] blockStates = new BlockState[42];
            for (int i1 = 1; i1 < 42; ++i1) {
                BlockPos blockPos = pos.relative(direction, i1);
                BlockState blockState = level.getBlockState(blockPos);
                if (blockState.is(Blocks.TRIPWIRE_HOOK)) {
                    if (blockState.getValue(FACING) != direction.getOpposite()) break;
                    i = i1;
                    break;
                }
                if (!blockState.is(Blocks.TRIPWIRE) && i1 != searchRange) {
                    blockStates[i1] = null;
                    flag2 = false;
                    continue;
                }
                if (i1 == searchRange) {
                    blockState = (BlockState)MoreObjects.firstNonNull((Object)state, (Object)blockState);
                }
                boolean flag4 = blockState.getValue(TripWireBlock.DISARMED) == false;
                boolean poweredValue = blockState.getValue(TripWireBlock.POWERED);
                flag3 |= flag4 && poweredValue;
                blockStates[i1] = blockState;
                if (i1 != searchRange) continue;
                level.scheduleTick(pos, block, 10);
                flag2 &= flag4;
            }
            BlockState blockState1 = (BlockState)((BlockState)block.defaultBlockState().trySetValue(ATTACHED, flag2)).trySetValue(POWERED, flag3 &= (flag2 &= i > 1));
            boolean cancelledEmitterHook = false;
            boolean cancelledReceiverHook = false;
            boolean wasPowered = flag1;
            boolean willBePowered = flag3;
            if (i > 0) {
                BlockPos blockPosx = pos.relative(direction, i);
                if (wasPowered != willBePowered) {
                    int newCurrent = willBePowered ? 15 : 0;
                    BlockRedstoneEvent event = new BlockRedstoneEvent((org.bukkit.block.Block)CraftBlock.at(level, blockPosx), wasPowered ? 15 : 0, newCurrent);
                    event.callEvent();
                    boolean bl = cancelledReceiverHook = event.getNewCurrent() != newCurrent;
                }
                if (!cancelledReceiverHook) {
                    Direction opposite = direction.getOpposite();
                    level.setBlock(blockPosx, (BlockState)blockState1.setValue(FACING, opposite), 3);
                    TripWireHookBlock.notifyNeighbors(block, level, blockPosx, opposite);
                    TripWireHookBlock.emitState(level, blockPosx, flag2, flag3, flag, flag1);
                }
            }
            if (wasPowered != willBePowered) {
                int newCurrent = willBePowered ? 15 : 0;
                BlockRedstoneEvent event = new BlockRedstoneEvent((org.bukkit.block.Block)CraftBlock.at(level, pos), wasPowered ? 15 : 0, newCurrent);
                event.callEvent();
                boolean bl = cancelledEmitterHook = event.getNewCurrent() != newCurrent;
            }
            if (!cancelledEmitterHook) {
                TripWireHookBlock.emitState(level, pos, flag2, flag3, flag, flag1);
                if (!attaching) {
                    if (GlobalConfiguration.get().unsupportedSettings.skipTripwireHookPlacementValidation || level.getBlockState(pos).is(Blocks.TRIPWIRE_HOOK)) {
                        level.setBlock(pos, (BlockState)blockState1.setValue(FACING, direction), 3);
                    }
                    if (shouldNotifyNeighbours) {
                        TripWireHookBlock.notifyNeighbors(block, level, pos, direction);
                    }
                }
            }
            if (flag != flag2) {
                for (int i2 = 1; i2 < i; ++i2) {
                    BlockState blockState3;
                    BlockPos blockPos1 = pos.relative(direction, i2);
                    BlockState blockState2 = blockStates[i2];
                    if (blockState2 == null || !(blockState3 = level.getBlockState(blockPos1)).is(Blocks.TRIPWIRE) && !blockState3.is(Blocks.TRIPWIRE_HOOK) || GlobalConfiguration.get().blockUpdates.disableTripwireUpdates && blockState3.is(Blocks.TRIPWIRE)) continue;
                    level.setBlock(blockPos1, (BlockState)blockState2.trySetValue(ATTACHED, flag2), 3);
                }
            }
        }
    }

    @Override
    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        TripWireHookBlock.calculateState(level, pos, state, false, true, -1, null);
    }

    private static void emitState(Level level, BlockPos pos, boolean attached, boolean powered, boolean wasAttached, boolean wasPowered) {
        if (powered && !wasPowered) {
            level.playSound(null, pos, SoundEvents.TRIPWIRE_CLICK_ON, SoundSource.BLOCKS, 0.4f, 0.6f);
            level.gameEvent(null, GameEvent.BLOCK_ACTIVATE, pos);
        } else if (!powered && wasPowered) {
            level.playSound(null, pos, SoundEvents.TRIPWIRE_CLICK_OFF, SoundSource.BLOCKS, 0.4f, 0.5f);
            level.gameEvent(null, GameEvent.BLOCK_DEACTIVATE, pos);
        } else if (attached && !wasAttached) {
            level.playSound(null, pos, SoundEvents.TRIPWIRE_ATTACH, SoundSource.BLOCKS, 0.4f, 0.7f);
            level.gameEvent(null, GameEvent.BLOCK_ATTACH, pos);
        } else if (!attached && wasAttached) {
            level.playSound(null, pos, SoundEvents.TRIPWIRE_DETACH, SoundSource.BLOCKS, 0.4f, 1.2f / (level.random.nextFloat() * 0.2f + 0.9f));
            level.gameEvent(null, GameEvent.BLOCK_DETACH, pos);
        }
    }

    private static void notifyNeighbors(Block block, Level level, BlockPos pos, Direction direction) {
        Direction opposite = direction.getOpposite();
        Orientation orientation = ExperimentalRedstoneUtils.initialOrientation(level, opposite, Direction.UP);
        level.updateNeighborsAt(pos, block, orientation);
        level.updateNeighborsAt(pos.relative(opposite), block, orientation);
    }

    @Override
    protected void affectNeighborsAfterRemoval(BlockState state, ServerLevel level, BlockPos pos, boolean movedByPiston) {
        if (!movedByPiston) {
            boolean attachedValue = state.getValue(ATTACHED);
            boolean poweredValue = state.getValue(POWERED);
            if (attachedValue || poweredValue) {
                TripWireHookBlock.calculateState(level, pos, state, true, false, -1, null);
            }
            if (poweredValue) {
                TripWireHookBlock.notifyNeighbors(this, level, pos, state.getValue(FACING));
            }
        }
    }

    @Override
    protected int getSignal(BlockState state, BlockGetter level, BlockPos pos, Direction side) {
        return state.getValue(POWERED) != false ? 15 : 0;
    }

    @Override
    protected int getDirectSignal(BlockState state, BlockGetter level, BlockPos pos, Direction side) {
        if (!state.getValue(POWERED).booleanValue()) {
            return 0;
        }
        return state.getValue(FACING) == side ? 15 : 0;
    }

    @Override
    protected boolean isSignalSource(BlockState state) {
        return true;
    }

    @Override
    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue(FACING, rotation.rotate(state.getValue(FACING)));
    }

    @Override
    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation(state.getValue(FACING)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(FACING, POWERED, ATTACHED);
    }
}

