/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.state.properties;

import ca.spottedleaf.moonrise.patches.blockstate_propertyaccess.PropertyAccess;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.state.properties.Property;

public final class EnumProperty<T extends Enum<T>>
extends Property<T>
implements PropertyAccess<T> {
    private final List<T> values;
    private final Map<String, T> names;
    private final int[] ordinalToIndex;
    private int[] idLookupTable;

    @Override
    public final int moonrise$getIdFor(T value) {
        Class target = this.getValueClass();
        return value.getClass() != target && ((Enum)value).getDeclaringClass() != target ? -1 : this.idLookupTable[((Enum)value).ordinal()];
    }

    private void init() {
        List<T> values = this.getPossibleValues();
        Class clazz = this.getValueClass();
        int id = 0;
        this.idLookupTable = new int[((Enum[])clazz.getEnumConstants()).length];
        Arrays.fill(this.idLookupTable, -1);
        Enum[] byId = (Enum[])Array.newInstance(clazz, values.size());
        for (Enum value : values) {
            int valueId;
            this.idLookupTable[value.ordinal()] = valueId = id++;
            byId[valueId] = value;
        }
        this.moonrise$setById((Comparable[])byId);
    }

    private EnumProperty(String name, Class<T> clazz, List<T> values) {
        super(name, clazz);
        if (values.isEmpty()) {
            throw new IllegalArgumentException("Trying to make empty EnumProperty '" + name + "'");
        }
        this.values = List.copyOf(values);
        Enum[] enums = (Enum[])clazz.getEnumConstants();
        this.ordinalToIndex = new int[enums.length];
        for (Enum _enum : enums) {
            this.ordinalToIndex[_enum.ordinal()] = values.indexOf(_enum);
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Enum _enum1 : values) {
            String serializedName = ((StringRepresentable)((Object)_enum1)).getSerializedName();
            builder.put((Object)serializedName, (Object)_enum1);
        }
        this.names = builder.buildOrThrow();
        this.init();
    }

    @Override
    public List<T> getPossibleValues() {
        return this.values;
    }

    @Override
    public Optional<T> getValue(String value) {
        return Optional.ofNullable((Enum)this.names.get(value));
    }

    @Override
    public String getName(T value) {
        return ((StringRepresentable)value).getSerializedName();
    }

    @Override
    public int getInternalIndex(T value) {
        return this.ordinalToIndex[((Enum)value).ordinal()];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals_unused(Object other) {
        if (this == other) return true;
        if (!(other instanceof EnumProperty)) return false;
        EnumProperty enumProperty = (EnumProperty)other;
        if (!super.equals(other)) return false;
        if (!this.values.equals(enumProperty.values)) return false;
        return true;
    }

    @Override
    public int generateHashCode() {
        int i = super.generateHashCode();
        return 31 * i + this.values.hashCode();
    }

    public static <T extends Enum<T>> EnumProperty<T> create(String name, Class<T> clazz) {
        return EnumProperty.create(name, clazz, (T type) -> true);
    }

    public static <T extends Enum<T>> EnumProperty<T> create(String name, Class<T> clazz, Predicate<T> filter) {
        return EnumProperty.create(name, clazz, Arrays.stream((Enum[])clazz.getEnumConstants()).filter(filter).collect(Collectors.toList()));
    }

    @SafeVarargs
    public static <T extends Enum<T>> EnumProperty<T> create(String name, Class<T> clazz, T ... values) {
        return EnumProperty.create(name, clazz, List.of(values));
    }

    public static <T extends Enum<T>> EnumProperty<T> create(String name, Class<T> clazz, List<T> values) {
        return new EnumProperty<T>(name, clazz, values);
    }
}

