/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import ca.spottedleaf.moonrise.common.list.ShortList;
import ca.spottedleaf.moonrise.patches.block_counting.BlockCountingChunkSection;
import ca.spottedleaf.moonrise.patches.collisions.CollisionUtil;
import io.papermc.paper.annotation.DoNotUse;
import io.papermc.paper.antixray.ChunkPacketInfo;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.BitStorage;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.Palette;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.PalettedContainerFactory;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.material.FluidState;

public class LevelChunkSection
implements BlockCountingChunkSection {
    public static final int SECTION_WIDTH = 16;
    public static final int SECTION_HEIGHT = 16;
    public static final int SECTION_SIZE = 4096;
    public static final int BIOME_CONTAINER_BITS = 2;
    short nonEmptyBlockCount;
    private short tickingBlockCount;
    private short tickingFluidCount;
    public final PalettedContainer<BlockState> states;
    private PalettedContainer<Holder<Biome>> biomes;
    private static final ShortArrayList FULL_LIST = new ShortArrayList(4096);
    private boolean isClient;
    private static final short CLIENT_FORCED_SPECIAL_COLLIDING_BLOCKS = 9999;
    private short specialCollidingBlocks;
    private final ShortList tickingBlocks = new ShortList();

    @Override
    public final boolean moonrise$hasSpecialCollidingBlocks() {
        return this.specialCollidingBlocks != 0;
    }

    @Override
    public final ShortList moonrise$getTickingBlockList() {
        return this.tickingBlocks;
    }

    private LevelChunkSection(LevelChunkSection section) {
        this.nonEmptyBlockCount = section.nonEmptyBlockCount;
        this.tickingBlockCount = section.tickingBlockCount;
        this.tickingFluidCount = section.tickingFluidCount;
        this.states = section.states.copy();
        this.biomes = section.biomes.copy();
    }

    public LevelChunkSection(PalettedContainer<BlockState> states, PalettedContainer<Holder<Biome>> biomes) {
        this.states = states;
        this.biomes = biomes;
        this.recalcBlockCounts();
    }

    @Deprecated
    @DoNotUse
    public LevelChunkSection(PalettedContainerFactory containerFactory) {
        this(containerFactory, null, null, 0);
    }

    public LevelChunkSection(PalettedContainerFactory containerFactory, Level level, ChunkPos chunkPos, int chunkSectionY) {
        this.states = containerFactory.createForBlockStates(level, chunkPos, chunkSectionY);
        this.biomes = containerFactory.createForBiomes();
    }

    public BlockState getBlockState(int x, int y, int z) {
        return this.states.get(x, y, z);
    }

    public FluidState getFluidState(int x, int y, int z) {
        return this.states.get(x, y, z).getFluidState();
    }

    public void acquire() {
        this.states.acquire();
    }

    public void release() {
        this.states.release();
    }

    public BlockState setBlockState(int x, int y, int z, BlockState state) {
        return this.setBlockState(x, y, z, state, true);
    }

    private void updateBlockCallback(int x, int y, int z, BlockState newState, BlockState oldState) {
        boolean newTicking;
        boolean oldTicking;
        boolean isSpecialNew;
        if (oldState == newState) {
            return;
        }
        if (this.isClient) {
            if (CollisionUtil.isSpecialCollidingBlock(newState)) {
                this.specialCollidingBlocks = (short)9999;
            }
            return;
        }
        boolean isSpecialOld = CollisionUtil.isSpecialCollidingBlock(oldState);
        if (isSpecialOld != (isSpecialNew = CollisionUtil.isSpecialCollidingBlock(newState))) {
            this.specialCollidingBlocks = isSpecialOld ? (short)(this.specialCollidingBlocks - 1) : (short)(this.specialCollidingBlocks + 1);
        }
        if ((oldTicking = oldState.isRandomlyTicking()) != (newTicking = newState.isRandomlyTicking())) {
            ShortList tickingBlocks = this.tickingBlocks;
            short position = (short)(x | z << 4 | y << 8);
            if (oldTicking) {
                tickingBlocks.remove(position);
            } else {
                tickingBlocks.add(position);
            }
        }
    }

    public BlockState setBlockState(int x, int y, int z, BlockState state, boolean useLocks) {
        BlockState blockState = useLocks ? this.states.getAndSet(x, y, z, state) : this.states.getAndSetUnchecked(x, y, z, state);
        FluidState fluidState = blockState.getFluidState();
        FluidState fluidState1 = state.getFluidState();
        if (!blockState.isAir()) {
            this.nonEmptyBlockCount = (short)(this.nonEmptyBlockCount - 1);
            if (blockState.isRandomlyTicking()) {
                this.tickingBlockCount = (short)(this.tickingBlockCount - 1);
            }
        }
        if (fluidState.isRandomlyTicking()) {
            this.tickingFluidCount = (short)(this.tickingFluidCount - 1);
        }
        if (!state.isAir()) {
            this.nonEmptyBlockCount = (short)(this.nonEmptyBlockCount + 1);
            if (state.isRandomlyTicking()) {
                this.tickingBlockCount = (short)(this.tickingBlockCount + 1);
            }
        }
        if (fluidState1.isRandomlyTicking()) {
            this.tickingFluidCount = (short)(this.tickingFluidCount + 1);
        }
        this.updateBlockCallback(x, y, z, state, blockState);
        return blockState;
    }

    public boolean hasOnlyAir() {
        return this.nonEmptyBlockCount == 0;
    }

    public boolean isRandomlyTicking() {
        return this.isRandomlyTickingBlocks() || this.isRandomlyTickingFluids();
    }

    public boolean isRandomlyTickingBlocks() {
        return this.tickingBlockCount > 0;
    }

    public boolean isRandomlyTickingFluids() {
        return this.tickingFluidCount > 0;
    }

    public void recalcBlockCounts() {
        this.nonEmptyBlockCount = 0;
        this.tickingBlockCount = 0;
        this.tickingFluidCount = 0;
        this.specialCollidingBlocks = 0;
        this.tickingBlocks.clear();
        if (this.maybeHas(state -> !state.isAir())) {
            Int2ObjectOpenHashMap counts;
            PalettedContainer.Data data = this.states.data;
            Palette palette = data.palette();
            int paletteSize = palette.getSize();
            BitStorage storage = data.storage();
            if (paletteSize == 1) {
                counts = new Int2ObjectOpenHashMap(1);
                counts.put(0, (Object)FULL_LIST);
            } else {
                counts = storage.moonrise$countEntries();
            }
            ObjectIterator iterator = counts.int2ObjectEntrySet().fastIterator();
            while (iterator.hasNext()) {
                FluidState fluid;
                Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)iterator.next();
                int paletteIdx = entry.getIntKey();
                ShortArrayList coordinates = (ShortArrayList)entry.getValue();
                int paletteCount = coordinates.size();
                BlockState state2 = (BlockState)palette.valueFor(paletteIdx);
                if (state2.isAir()) continue;
                if (CollisionUtil.isSpecialCollidingBlock(state2)) {
                    this.specialCollidingBlocks = (short)(this.specialCollidingBlocks + (short)paletteCount);
                }
                this.nonEmptyBlockCount = (short)(this.nonEmptyBlockCount + (short)paletteCount);
                if (state2.isRandomlyTicking()) {
                    this.tickingBlockCount = (short)(this.tickingBlockCount + (short)paletteCount);
                    short[] raw = coordinates.elements();
                    int rawLen = raw.length;
                    ShortList tickingBlocks = this.tickingBlocks;
                    tickingBlocks.setMinCapacity(Math.min((rawLen + tickingBlocks.size()) * 3 / 2, 4096));
                    Objects.checkFromToIndex(0, paletteCount, raw.length);
                    for (int i = 0; i < paletteCount; ++i) {
                        tickingBlocks.add(raw[i]);
                    }
                }
                if ((fluid = state2.getFluidState()).isEmpty() || !fluid.isRandomlyTicking()) continue;
                this.tickingFluidCount = (short)(this.tickingFluidCount + (short)paletteCount);
            }
        }
    }

    public PalettedContainer<BlockState> getStates() {
        return this.states;
    }

    public PalettedContainerRO<Holder<Biome>> getBiomes() {
        return this.biomes;
    }

    public void read(FriendlyByteBuf buffer) {
        this.nonEmptyBlockCount = buffer.readShort();
        this.states.read(buffer);
        PalettedContainer<Holder<Biome>> palettedContainer = this.biomes.recreate();
        palettedContainer.read(buffer);
        this.biomes = palettedContainer;
        this.isClient = true;
        this.specialCollidingBlocks = this.nonEmptyBlockCount != 0 && this.maybeHas(CollisionUtil::isSpecialCollidingBlock) ? 9999 : 0;
    }

    public void readBiomes(FriendlyByteBuf buffer) {
        PalettedContainer<Holder<Biome>> palettedContainer = this.biomes.recreate();
        palettedContainer.read(buffer);
        this.biomes = palettedContainer;
    }

    @Deprecated
    @DoNotUse
    public void write(FriendlyByteBuf buffer) {
        this.write(buffer, null, 0);
    }

    public void write(FriendlyByteBuf buffer, ChunkPacketInfo<BlockState> chunkPacketInfo, int chunkSectionIndex) {
        buffer.writeShort(this.nonEmptyBlockCount);
        this.states.write(buffer, chunkPacketInfo, chunkSectionIndex);
        this.biomes.write(buffer, null, chunkSectionIndex);
    }

    public int getSerializedSize() {
        return 2 + this.states.getSerializedSize() + this.biomes.getSerializedSize();
    }

    public boolean maybeHas(Predicate<BlockState> predicate) {
        return this.states.maybeHas(predicate);
    }

    public Holder<Biome> getNoiseBiome(int x, int y, int z) {
        return this.biomes.get(x, y, z);
    }

    public void setBiome(int x, int y, int z, Holder<Biome> biome) {
        this.biomes.set(x, y, z, biome);
    }

    public void fillBiomesFromNoise(BiomeResolver biomeResolver, Climate.Sampler climateSampler, int x, int y, int z) {
        PalettedContainer<Holder<Biome>> palettedContainer = this.biomes.recreate();
        int i = 4;
        for (int i1 = 0; i1 < 4; ++i1) {
            for (int i2 = 0; i2 < 4; ++i2) {
                for (int i3 = 0; i3 < 4; ++i3) {
                    palettedContainer.getAndSetUnchecked(i1, i2, i3, biomeResolver.getNoiseBiome(x + i1, y + i2, z + i3, climateSampler));
                }
            }
        }
        this.biomes = palettedContainer;
    }

    public LevelChunkSection copy() {
        return new LevelChunkSection(this);
    }

    static {
        for (short i = 0; i < 4096; i = (short)(i + 1)) {
            FULL_LIST.add(i);
        }
    }
}

