/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.mojang.logging.LogUtils;
import io.papermc.paper.configuration.GlobalConfiguration;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.InflaterInputStream;
import javax.annotation.Nullable;
import net.jpountz.lz4.LZ4BlockInputStream;
import net.jpountz.lz4.LZ4BlockOutputStream;
import net.minecraft.util.FastBufferedInputStream;
import org.slf4j.Logger;

public class RegionFileVersion {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Int2ObjectMap<RegionFileVersion> VERSIONS = new Int2ObjectOpenHashMap();
    private static final Object2ObjectMap<String, RegionFileVersion> VERSIONS_BY_NAME = new Object2ObjectOpenHashMap();
    public static final RegionFileVersion VERSION_GZIP = RegionFileVersion.register(new RegionFileVersion(1, null, inputWrapper -> new FastBufferedInputStream(new GZIPInputStream((InputStream)inputWrapper)), outputWrapper -> new BufferedOutputStream(new GZIPOutputStream((OutputStream)outputWrapper))));
    public static final RegionFileVersion VERSION_DEFLATE = RegionFileVersion.register(new RegionFileVersion(2, "deflate", inputWrapper -> new FastBufferedInputStream(new InflaterInputStream((InputStream)inputWrapper)), outputWrapper -> new BufferedOutputStream(new DeflaterOutputStream((OutputStream)outputWrapper))));
    public static final RegionFileVersion VERSION_NONE = RegionFileVersion.register(new RegionFileVersion(3, "none", FastBufferedInputStream::new, BufferedOutputStream::new));
    public static final RegionFileVersion VERSION_LZ4 = RegionFileVersion.register(new RegionFileVersion(4, "lz4", stream -> new FastBufferedInputStream((InputStream)new LZ4BlockInputStream(stream)), stream -> new BufferedOutputStream((OutputStream)new LZ4BlockOutputStream(stream))));
    public static final RegionFileVersion VERSION_CUSTOM = RegionFileVersion.register(new RegionFileVersion(127, null, inputWrapper -> {
        throw new UnsupportedOperationException();
    }, outputWrapper -> {
        throw new UnsupportedOperationException();
    }));
    public static final RegionFileVersion DEFAULT;
    private static volatile RegionFileVersion selected;
    private final int id;
    @Nullable
    private final String optionName;
    private final StreamWrapper<InputStream> inputWrapper;
    private final StreamWrapper<OutputStream> outputWrapper;

    public static RegionFileVersion getCompressionFormat() {
        return switch (GlobalConfiguration.get().unsupportedSettings.compressionFormat) {
            default -> throw new MatchException(null, null);
            case GlobalConfiguration.UnsupportedSettings.CompressionFormat.GZIP -> VERSION_GZIP;
            case GlobalConfiguration.UnsupportedSettings.CompressionFormat.ZLIB -> VERSION_DEFLATE;
            case GlobalConfiguration.UnsupportedSettings.CompressionFormat.LZ4 -> VERSION_LZ4;
            case GlobalConfiguration.UnsupportedSettings.CompressionFormat.NONE -> VERSION_NONE;
        };
    }

    private RegionFileVersion(int id, @Nullable String optionName, StreamWrapper<InputStream> inputWrapper, StreamWrapper<OutputStream> outputWrapper) {
        this.id = id;
        this.optionName = optionName;
        this.inputWrapper = inputWrapper;
        this.outputWrapper = outputWrapper;
    }

    private static RegionFileVersion register(RegionFileVersion fileVersion) {
        VERSIONS.put(fileVersion.id, (Object)fileVersion);
        if (fileVersion.optionName != null) {
            VERSIONS_BY_NAME.put((Object)fileVersion.optionName, (Object)fileVersion);
        }
        return fileVersion;
    }

    @Nullable
    public static RegionFileVersion fromId(int id) {
        return (RegionFileVersion)VERSIONS.get(id);
    }

    public static void configure(String optionValue) {
        RegionFileVersion regionFileVersion = (RegionFileVersion)VERSIONS_BY_NAME.get((Object)optionValue);
        if (regionFileVersion != null) {
            selected = regionFileVersion;
        } else {
            LOGGER.error("Invalid `region-file-compression` value `{}` in server.properties. Please use one of: {}", (Object)optionValue, (Object)String.join((CharSequence)", ", (Iterable<? extends CharSequence>)VERSIONS_BY_NAME.keySet()));
        }
    }

    public static RegionFileVersion getSelected() {
        return selected;
    }

    public static boolean isValidVersion(int id) {
        return VERSIONS.containsKey(id);
    }

    public int getId() {
        return this.id;
    }

    public OutputStream wrap(OutputStream outputStream) throws IOException {
        return this.outputWrapper.wrap(outputStream);
    }

    public InputStream wrap(InputStream inputStream) throws IOException {
        return this.inputWrapper.wrap(inputStream);
    }

    static {
        selected = DEFAULT = VERSION_DEFLATE;
    }

    @FunctionalInterface
    static interface StreamWrapper<O> {
        public O wrap(O var1) throws IOException;
    }
}

