/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import ca.spottedleaf.moonrise.patches.chunk_system.level.storage.ChunkSystemSectionStorage;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.OptionalDynamic;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.storage.ChunkIOErrorReporter;
import net.minecraft.world.level.chunk.storage.RegionFileStorage;
import net.minecraft.world.level.chunk.storage.SimpleRegionStorage;
import org.slf4j.Logger;

public class SectionStorage<R, P>
implements AutoCloseable,
ChunkSystemSectionStorage {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final String SECTIONS_TAG = "Sections";
    private final Long2ObjectMap<Optional<R>> storage = new Long2ObjectOpenHashMap();
    private final LongLinkedOpenHashSet dirtyChunks = new LongLinkedOpenHashSet();
    private final Codec<P> codec;
    private final Function<R, P> packer;
    private final BiFunction<P, Runnable, R> unpacker;
    private final Function<Runnable, R> factory;
    private final RegistryAccess registryAccess;
    private final ChunkIOErrorReporter errorReporter;
    protected final LevelHeightAccessor levelHeightAccessor;
    private final LongSet loadedChunks = new LongOpenHashSet();
    private final Long2ObjectMap<CompletableFuture<Optional<PackedChunk<P>>>> pendingLoads = new Long2ObjectOpenHashMap();
    private final Object loadLock = new Object();
    private final RegionFileStorage regionStorage;

    @Override
    public final RegionFileStorage moonrise$getRegionStorage() {
        return this.regionStorage;
    }

    @Override
    public void moonrise$close() throws IOException {
    }

    public SectionStorage(SimpleRegionStorage simpleRegionStorage, Codec<P> codec, Function<R, P> packer, BiFunction<P, Runnable, R> unpacker, Function<Runnable, R> factory, RegistryAccess registryAccess, ChunkIOErrorReporter errorReporter, LevelHeightAccessor levelHeightAccessor) {
        this.codec = codec;
        this.packer = packer;
        this.unpacker = unpacker;
        this.factory = factory;
        this.registryAccess = registryAccess;
        this.errorReporter = errorReporter;
        this.levelHeightAccessor = levelHeightAccessor;
        this.regionStorage = simpleRegionStorage.worker.storage;
    }

    protected void tick(BooleanSupplier aheadOfTime) {
        LongListIterator longIterator = this.dirtyChunks.iterator();
        while (longIterator.hasNext() && aheadOfTime.getAsBoolean()) {
            ChunkPos chunkPos = new ChunkPos(longIterator.nextLong());
            longIterator.remove();
            this.writeChunk(chunkPos);
        }
        this.unpackPendingLoads();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unpackPendingLoads() {
        Object object = this.loadLock;
        synchronized (object) {
            ObjectIterator iterator = Long2ObjectMaps.fastIterator(this.pendingLoads);
            while (iterator.hasNext()) {
                Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)iterator.next();
                Optional optional = ((CompletableFuture)entry.getValue()).getNow(null);
                if (optional == null) continue;
                long longKey = entry.getLongKey();
                this.unpackChunk(new ChunkPos(longKey), optional.orElse(null));
                iterator.remove();
                this.loadedChunks.add(longKey);
            }
        }
    }

    public void flushAll() {
        if (!this.dirtyChunks.isEmpty()) {
            this.dirtyChunks.forEach(l -> this.writeChunk(new ChunkPos(l)));
            this.dirtyChunks.clear();
        }
    }

    public boolean hasWork() {
        return !this.dirtyChunks.isEmpty();
    }

    @Nullable
    public Optional<R> get(long sectionKey) {
        return (Optional)this.storage.get(sectionKey);
    }

    public Optional<R> getOrLoad(long sectionKey) {
        if (this.outsideStoredRange(sectionKey)) {
            return Optional.empty();
        }
        Optional<R> optional = this.get(sectionKey);
        if (optional != null) {
            return optional;
        }
        this.unpackChunk(SectionPos.of(sectionKey).chunk());
        optional = this.get(sectionKey);
        if (optional == null) {
            throw Util.pauseInIde(new IllegalStateException());
        }
        return optional;
    }

    protected boolean outsideStoredRange(long sectionKey) {
        int blockPosY = SectionPos.sectionToBlockCoord(SectionPos.y(sectionKey));
        return this.levelHeightAccessor.isOutsideBuildHeight(blockPosY);
    }

    protected R getOrCreate(long sectionKey) {
        if (this.outsideStoredRange(sectionKey)) {
            throw Util.pauseInIde(new IllegalArgumentException("sectionPos out of bounds"));
        }
        Optional<R> orLoad = this.getOrLoad(sectionKey);
        if (orLoad.isPresent()) {
            return orLoad.get();
        }
        R object = this.factory.apply(() -> this.setDirty(sectionKey));
        this.storage.put(sectionKey, Optional.of(object));
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<?> prefetch(ChunkPos pos) {
        Object object = this.loadLock;
        synchronized (object) {
            long packedChunkPos = pos.toLong();
            return this.loadedChunks.contains(packedChunkPos) ? CompletableFuture.completedFuture(null) : (CompletableFuture)this.pendingLoads.computeIfAbsent(packedChunkPos, l -> this.tryRead(pos));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unpackChunk(ChunkPos pos) {
        CompletableFuture completableFuture;
        long packedChunkPos = pos.toLong();
        Object object = this.loadLock;
        synchronized (object) {
            if (!this.loadedChunks.add(packedChunkPos)) {
                return;
            }
            completableFuture = (CompletableFuture)this.pendingLoads.computeIfAbsent(packedChunkPos, l -> this.tryRead(pos));
        }
        this.unpackChunk(pos, ((Optional)completableFuture.join()).orElse(null));
        object = this.loadLock;
        synchronized (object) {
            this.pendingLoads.remove(packedChunkPos);
        }
    }

    private CompletableFuture<Optional<PackedChunk<P>>> tryRead(ChunkPos chunkPos) {
        throw new IllegalStateException("Only chunk system can write state, offending class:" + this.getClass().getName());
    }

    private void unpackChunk(ChunkPos pos, @Nullable PackedChunk<P> packedChunk) {
        throw new IllegalStateException("Only chunk system can load in state, offending class:" + this.getClass().getName());
    }

    private void writeChunk(ChunkPos pos) {
        throw new IllegalStateException("Only chunk system can write state, offending class:" + this.getClass().getName());
    }

    private <T> Dynamic<T> writeChunk(ChunkPos pos, DynamicOps<T> ops) {
        HashMap map = Maps.newHashMap();
        for (int sectionY = this.levelHeightAccessor.getMinSectionY(); sectionY <= this.levelHeightAccessor.getMaxSectionY(); ++sectionY) {
            long key = SectionStorage.getKey(pos, sectionY);
            Optional optional = (Optional)this.storage.get(key);
            if (optional == null || optional.isEmpty()) continue;
            DataResult dataResult = this.codec.encodeStart(ops, this.packer.apply(optional.get()));
            String string = Integer.toString(sectionY);
            dataResult.resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(object -> map.put(ops.createString(string), object));
        }
        return new Dynamic<Object>(ops, ops.createMap((Map)ImmutableMap.of((Object)ops.createString(SECTIONS_TAG), (Object)ops.createMap((Map)map), (Object)ops.createString("DataVersion"), (Object)ops.createInt(SharedConstants.getCurrentVersion().dataVersion().version()))));
    }

    private static long getKey(ChunkPos chunkPos, int sectionY) {
        return SectionPos.asLong(chunkPos.x, sectionY, chunkPos.z);
    }

    protected void onSectionLoad(long sectionKey) {
    }

    public void setDirty(long sectionPos) {
        Optional optional = (Optional)this.storage.get(sectionPos);
        if (optional != null && !optional.isEmpty()) {
            this.dirtyChunks.add(ChunkPos.asLong(SectionPos.x(sectionPos), SectionPos.z(sectionPos)));
        } else {
            LOGGER.warn("No data for position: {}", (Object)SectionPos.of(sectionPos));
        }
    }

    public void flush(ChunkPos chunkPos) {
        if (this.dirtyChunks.remove(chunkPos.toLong())) {
            this.writeChunk(chunkPos);
        }
    }

    @Override
    public void close() throws IOException {
        this.moonrise$close();
    }

    record PackedChunk<T>(Int2ObjectMap<T> sectionsByY, boolean versionChanged) {
        public static <T> PackedChunk<T> parse(Codec<T> codec, DynamicOps<Tag> ops, Tag value, SimpleRegionStorage simpleRegionStorage, LevelHeightAccessor level) {
            Dynamic<Tag> dynamic = new Dynamic<Tag>(ops, value);
            Dynamic<Tag> dynamic1 = simpleRegionStorage.upgradeChunkTag(dynamic, 1945);
            boolean flag = dynamic != dynamic1;
            OptionalDynamic<Tag> optionalDynamic = dynamic1.get(SectionStorage.SECTIONS_TAG);
            Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap();
            for (int sectionY = level.getMinSectionY(); sectionY <= level.getMaxSectionY(); ++sectionY) {
                Optional optional = optionalDynamic.get(Integer.toString(sectionY)).result().flatMap(dynamic2 -> codec.parse(dynamic2).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)));
                if (!optional.isPresent()) continue;
                map.put(sectionY, optional.get());
            }
            return new PackedChunk<T>(map, flag);
        }
    }
}

