/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.HugeMushroomFeatureConfiguration;

public abstract class AbstractHugeMushroomFeature
extends Feature<HugeMushroomFeatureConfiguration> {
    public AbstractHugeMushroomFeature(Codec<HugeMushroomFeatureConfiguration> codec) {
        super(codec);
    }

    protected void placeTrunk(LevelAccessor level, RandomSource random, BlockPos pos, HugeMushroomFeatureConfiguration config, int maxHeight, BlockPos.MutableBlockPos mutablePos) {
        for (int i = 0; i < maxHeight; ++i) {
            mutablePos.set(pos).move(Direction.UP, i);
            this.placeMushroomBlock(level, mutablePos, config.stemProvider.getState(random, pos));
        }
    }

    protected void placeMushroomBlock(LevelAccessor level, BlockPos.MutableBlockPos mutablePos, BlockState state) {
        BlockState blockState = level.getBlockState(mutablePos);
        if (blockState.isAir() || blockState.is(BlockTags.REPLACEABLE_BY_MUSHROOMS)) {
            this.setBlock(level, mutablePos, state);
        }
    }

    protected int getTreeHeight(RandomSource random) {
        int i = random.nextInt(3) + 4;
        if (random.nextInt(12) == 0) {
            i *= 2;
        }
        return i;
    }

    protected boolean isValidPosition(LevelAccessor level, BlockPos pos, int maxHeight, BlockPos.MutableBlockPos mutablePos, HugeMushroomFeatureConfiguration config) {
        int y = pos.getY();
        if (y >= level.getMinY() + 1 && y + maxHeight + 1 <= level.getMaxY()) {
            BlockState blockState = level.getBlockState(pos.below());
            if (!AbstractHugeMushroomFeature.isDirt(blockState) && !blockState.is(BlockTags.MUSHROOM_GROW_BLOCK)) {
                return false;
            }
            for (int i = 0; i <= maxHeight; ++i) {
                int treeRadiusForHeight = this.getTreeRadiusForHeight(-1, -1, config.foliageRadius, i);
                for (int i1 = -treeRadiusForHeight; i1 <= treeRadiusForHeight; ++i1) {
                    for (int i2 = -treeRadiusForHeight; i2 <= treeRadiusForHeight; ++i2) {
                        BlockState blockState1 = level.getBlockState(mutablePos.setWithOffset(pos, i1, i, i2));
                        if (blockState1.isAir() || blockState1.is(BlockTags.LEAVES)) continue;
                        return false;
                    }
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean place(FeaturePlaceContext<HugeMushroomFeatureConfiguration> context) {
        BlockPos.MutableBlockPos mutableBlockPos;
        WorldGenLevel worldGenLevel = context.level();
        BlockPos blockPos = context.origin();
        RandomSource randomSource = context.random();
        HugeMushroomFeatureConfiguration hugeMushroomFeatureConfiguration = context.config();
        int treeHeight = this.getTreeHeight(randomSource);
        if (!this.isValidPosition(worldGenLevel, blockPos, treeHeight, mutableBlockPos = new BlockPos.MutableBlockPos(), hugeMushroomFeatureConfiguration)) {
            return false;
        }
        this.makeCap(worldGenLevel, randomSource, blockPos, treeHeight, mutableBlockPos, hugeMushroomFeatureConfiguration);
        this.placeTrunk(worldGenLevel, randomSource, blockPos, hugeMushroomFeatureConfiguration, treeHeight, mutableBlockPos);
        return true;
    }

    protected abstract int getTreeRadiusForHeight(int var1, int var2, int var3, int var4);

    protected abstract void makeCap(LevelAccessor var1, RandomSource var2, BlockPos var3, int var4, BlockPos.MutableBlockPos var5, HugeMushroomFeatureConfiguration var6);
}

