/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.RandomizableContainer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import org.slf4j.Logger;

public class MonsterRoomFeature
extends Feature<NoneFeatureConfiguration> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final EntityType<?>[] MOBS = new EntityType[]{EntityType.SKELETON, EntityType.ZOMBIE, EntityType.ZOMBIE, EntityType.SPIDER};
    private static final BlockState AIR = Blocks.CAVE_AIR.defaultBlockState();

    public MonsterRoomFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    @Override
    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        int i12;
        int i11;
        int i10;
        Predicate<BlockState> predicate = Feature.isReplaceable(BlockTags.FEATURES_CANNOT_REPLACE);
        BlockPos blockPos = context.origin();
        RandomSource randomSource = context.random();
        WorldGenLevel worldGenLevel = context.level();
        int i = 3;
        int i1 = randomSource.nextInt(2) + 2;
        int i2 = -i1 - 1;
        int i3 = i1 + 1;
        int i4 = -1;
        int i5 = 4;
        int i6 = randomSource.nextInt(2) + 2;
        int i7 = -i6 - 1;
        int i8 = i6 + 1;
        int i9 = 0;
        for (i10 = i2; i10 <= i3; ++i10) {
            for (i11 = -1; i11 <= 4; ++i11) {
                for (i12 = i7; i12 <= i8; ++i12) {
                    BlockPos blockPos1 = blockPos.offset(i10, i11, i12);
                    boolean isSolid = worldGenLevel.getBlockState(blockPos1).isSolid();
                    if (i11 == -1 && !isSolid) {
                        return false;
                    }
                    if (i11 == 4 && !isSolid) {
                        return false;
                    }
                    if (i10 != i2 && i10 != i3 && i12 != i7 && i12 != i8 || i11 != 0 || !worldGenLevel.isEmptyBlock(blockPos1) || !worldGenLevel.isEmptyBlock(blockPos1.above())) continue;
                    ++i9;
                }
            }
        }
        if (i9 >= 1 && i9 <= 5) {
            for (i10 = i2; i10 <= i3; ++i10) {
                for (i11 = 3; i11 >= -1; --i11) {
                    for (i12 = i7; i12 <= i8; ++i12) {
                        BlockPos blockPos1x = blockPos.offset(i10, i11, i12);
                        BlockState blockState = worldGenLevel.getBlockState(blockPos1x);
                        if (i10 == i2 || i11 == -1 || i12 == i7 || i10 == i3 || i11 == 4 || i12 == i8) {
                            if (blockPos1x.getY() >= worldGenLevel.getMinY() && !worldGenLevel.getBlockState(blockPos1x.below()).isSolid()) {
                                worldGenLevel.setBlock(blockPos1x, AIR, 2);
                                continue;
                            }
                            if (!blockState.isSolid() || blockState.is(Blocks.CHEST)) continue;
                            if (i11 == -1 && randomSource.nextInt(4) != 0) {
                                this.safeSetBlock(worldGenLevel, blockPos1x, Blocks.MOSSY_COBBLESTONE.defaultBlockState(), predicate);
                                continue;
                            }
                            this.safeSetBlock(worldGenLevel, blockPos1x, Blocks.COBBLESTONE.defaultBlockState(), predicate);
                            continue;
                        }
                        if (blockState.is(Blocks.CHEST) || blockState.is(Blocks.SPAWNER)) continue;
                        this.safeSetBlock(worldGenLevel, blockPos1x, AIR, predicate);
                    }
                }
            }
            block6: for (i10 = 0; i10 < 2; ++i10) {
                for (i11 = 0; i11 < 3; ++i11) {
                    int i13;
                    int y;
                    int i12x = blockPos.getX() + randomSource.nextInt(i1 * 2 + 1) - i1;
                    BlockPos blockPos2 = new BlockPos(i12x, y = blockPos.getY(), i13 = blockPos.getZ() + randomSource.nextInt(i6 * 2 + 1) - i6);
                    if (!worldGenLevel.isEmptyBlock(blockPos2)) continue;
                    int i14 = 0;
                    for (Direction direction : Direction.Plane.HORIZONTAL) {
                        if (!worldGenLevel.getBlockState(blockPos2.relative(direction)).isSolid()) continue;
                        ++i14;
                    }
                    if (i14 != true) continue;
                    this.safeSetBlock(worldGenLevel, blockPos2, StructurePiece.reorient(worldGenLevel, blockPos2, Blocks.CHEST.defaultBlockState()), predicate);
                    RandomizableContainer.setBlockEntityLootTable(worldGenLevel, randomSource, blockPos2, BuiltInLootTables.SIMPLE_DUNGEON);
                    continue block6;
                }
            }
            this.safeSetBlock(worldGenLevel, blockPos, Blocks.SPAWNER.defaultBlockState(), predicate);
            BlockEntity blockEntity = worldGenLevel.getBlockEntity(blockPos);
            if (blockEntity instanceof SpawnerBlockEntity) {
                SpawnerBlockEntity spawnerBlockEntity = (SpawnerBlockEntity)blockEntity;
                spawnerBlockEntity.setEntityId(this.randomEntityId(randomSource), randomSource);
            } else {
                LOGGER.error("Failed to fetch mob spawner entity at ({}, {}, {})", new Object[]{blockPos.getX(), blockPos.getY(), blockPos.getZ()});
            }
            return true;
        }
        return false;
    }

    private EntityType<?> randomEntityId(RandomSource random) {
        return Util.getRandom(MOBS, random);
    }
}

