/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.treedecorators;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class TrunkVineDecorator
extends TreeDecorator {
    public static final MapCodec<TrunkVineDecorator> CODEC = MapCodec.unit(() -> INSTANCE);
    public static final TrunkVineDecorator INSTANCE = new TrunkVineDecorator();

    @Override
    protected TreeDecoratorType<?> type() {
        return TreeDecoratorType.TRUNK_VINE;
    }

    @Override
    public void place(TreeDecorator.Context context) {
        RandomSource randomSource = context.random();
        context.logs().forEach(blockPos -> {
            BlockPos blockPos1;
            if (randomSource.nextInt(3) > 0 && context.isAir(blockPos1 = blockPos.west())) {
                context.placeVine(blockPos1, VineBlock.EAST);
            }
            if (randomSource.nextInt(3) > 0 && context.isAir(blockPos1 = blockPos.east())) {
                context.placeVine(blockPos1, VineBlock.WEST);
            }
            if (randomSource.nextInt(3) > 0 && context.isAir(blockPos1 = blockPos.north())) {
                context.placeVine(blockPos1, VineBlock.SOUTH);
            }
            if (randomSource.nextInt(3) > 0 && context.isAir(blockPos1 = blockPos.south())) {
                context.placeVine(blockPos1, VineBlock.NORTH);
            }
        });
    }
}

