/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.lighting;

import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.util.function.LongPredicate;
import net.minecraft.util.Mth;
import net.minecraft.world.level.lighting.LeveledPriorityQueue;

public abstract class DynamicGraphMinFixedPoint {
    public static final long SOURCE = Long.MAX_VALUE;
    private static final int NO_COMPUTED_LEVEL = 255;
    protected final int levelCount;
    private final LeveledPriorityQueue priorityQueue;
    private final Long2ByteMap computedLevels;
    private volatile boolean hasWork;

    protected DynamicGraphMinFixedPoint(int firstQueuedLevel, int width, final int height) {
        if (firstQueuedLevel >= 254) {
            throw new IllegalArgumentException("Level count must be < 254.");
        }
        this.levelCount = firstQueuedLevel;
        this.priorityQueue = new LeveledPriorityQueue(firstQueuedLevel, width);
        this.computedLevels = new Long2ByteOpenHashMap(height, 0.5f){

            protected void rehash(int newSize) {
                if (newSize > height) {
                    super.rehash(newSize);
                }
            }
        };
        this.computedLevels.defaultReturnValue((byte)-1);
    }

    protected void removeFromQueue(long position) {
        int i = this.computedLevels.remove(position) & 0xFF;
        if (i != 255) {
            int level = this.getLevel(position);
            int i1 = this.calculatePriority(level, i);
            this.priorityQueue.dequeue(position, i1, this.levelCount);
            this.hasWork = !this.priorityQueue.isEmpty();
        }
    }

    public void removeIf(LongPredicate predicate) {
        LongArrayList list = new LongArrayList();
        this.computedLevels.keySet().forEach(arg_0 -> DynamicGraphMinFixedPoint.lambda$removeIf$0(predicate, (LongList)list, arg_0));
        list.forEach(this::removeFromQueue);
    }

    private int calculatePriority(int oldLevel, int newLevel) {
        return Math.min(Math.min(oldLevel, newLevel), this.levelCount - 1);
    }

    protected void checkNode(long pos) {
        this.checkEdge(pos, pos, this.levelCount - 1, false);
    }

    protected void checkEdge(long fromPos, long toPos, int newLevel, boolean isDecreasing) {
        this.checkEdge(fromPos, toPos, newLevel, this.getLevel(toPos), this.computedLevels.get(toPos) & 0xFF, isDecreasing);
        this.hasWork = !this.priorityQueue.isEmpty();
    }

    private void checkEdge(long fromPos, long toPos, int newLevel, int previousLevel, int propagationLevel, boolean isDecreasing) {
        if (!this.isSource(toPos)) {
            boolean flag;
            newLevel = Mth.clamp(newLevel, 0, this.levelCount - 1);
            previousLevel = Mth.clamp(previousLevel, 0, this.levelCount - 1);
            boolean bl = flag = propagationLevel == 255;
            if (flag) {
                propagationLevel = previousLevel;
            }
            int min = isDecreasing ? Math.min(propagationLevel, newLevel) : Mth.clamp(this.getComputedLevel(toPos, fromPos, newLevel), 0, this.levelCount - 1);
            int i = this.calculatePriority(previousLevel, propagationLevel);
            if (previousLevel != min) {
                int i1 = this.calculatePriority(previousLevel, min);
                if (i != i1 && !flag) {
                    this.priorityQueue.dequeue(toPos, i, i1);
                }
                this.priorityQueue.enqueue(toPos, i1);
                this.computedLevels.put(toPos, (byte)min);
            } else if (!flag) {
                this.priorityQueue.dequeue(toPos, i, this.levelCount);
                this.computedLevels.remove(toPos);
            }
        }
    }

    protected final void checkNeighbor(long fromPos, long toPos, int sourceLevel, boolean isDecreasing) {
        int i = this.computedLevels.get(toPos) & 0xFF;
        int i1 = Mth.clamp(this.computeLevelFromNeighbor(fromPos, toPos, sourceLevel), 0, this.levelCount - 1);
        if (isDecreasing) {
            this.checkEdge(fromPos, toPos, i1, this.getLevel(toPos), i, isDecreasing);
        } else {
            boolean flag = i == 255;
            int i2 = flag ? Mth.clamp(this.getLevel(toPos), 0, this.levelCount - 1) : i;
            if (i1 == i2) {
                this.checkEdge(fromPos, toPos, this.levelCount - 1, flag ? i2 : this.getLevel(toPos), i, isDecreasing);
            }
        }
    }

    protected final boolean hasWork() {
        return this.hasWork;
    }

    protected final int runUpdates(int toUpdateCount) {
        if (this.priorityQueue.isEmpty()) {
            return toUpdateCount;
        }
        while (!this.priorityQueue.isEmpty() && toUpdateCount > 0) {
            --toUpdateCount;
            long l = this.priorityQueue.removeFirstLong();
            int i = Mth.clamp(this.getLevel(l), 0, this.levelCount - 1);
            int i1 = this.computedLevels.remove(l) & 0xFF;
            if (i1 < i) {
                this.setLevel(l, i1);
                this.checkNeighborsAfterUpdate(l, i1, true);
                continue;
            }
            if (i1 <= i) continue;
            this.setLevel(l, this.levelCount - 1);
            if (i1 != this.levelCount - 1) {
                this.priorityQueue.enqueue(l, this.calculatePriority(this.levelCount - 1, i1));
                this.computedLevels.put(l, (byte)i1);
            }
            this.checkNeighborsAfterUpdate(l, i, false);
        }
        this.hasWork = !this.priorityQueue.isEmpty();
        return toUpdateCount;
    }

    public int getQueueSize() {
        return this.computedLevels.size();
    }

    protected boolean isSource(long pos) {
        return pos == Long.MAX_VALUE;
    }

    protected abstract int getComputedLevel(long var1, long var3, int var5);

    protected abstract void checkNeighborsAfterUpdate(long var1, int var3, boolean var4);

    protected abstract int getLevel(long var1);

    protected abstract void setLevel(long var1, int var3);

    protected abstract int computeLevelFromNeighbor(long var1, long var3, int var5);

    private static /* synthetic */ void lambda$removeIf$0(LongPredicate predicate, LongList list, long value) {
        if (predicate.test(value)) {
            list.add(value);
        }
    }
}

