/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.pathfinder;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.profiling.metrics.MetricCategory;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.pathfinder.BinaryHeap;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.Target;

public class PathFinder {
    private static final float FUDGING = 1.5f;
    private final Node[] neighbors = new Node[32];
    private int maxVisitedNodes;
    public final NodeEvaluator nodeEvaluator;
    private final BinaryHeap openSet = new BinaryHeap();
    private BooleanSupplier captureDebug = () -> false;

    public PathFinder(NodeEvaluator nodeEvaluator, int maxVisitedNodes) {
        this.nodeEvaluator = nodeEvaluator;
        this.maxVisitedNodes = maxVisitedNodes;
    }

    public void setCaptureDebug(BooleanSupplier captureDebug) {
        this.captureDebug = captureDebug;
    }

    public void setMaxVisitedNodes(int maxVisitedNodes) {
        this.maxVisitedNodes = maxVisitedNodes;
    }

    @Nullable
    public Path findPath(PathNavigationRegion region, Mob mob, Set<BlockPos> targets, float maxRange, int reachRange, float maxVisitedNodesMultiplier) {
        this.openSet.clear();
        this.nodeEvaluator.prepare(region, mob);
        Node start = this.nodeEvaluator.getStart();
        if (start == null) {
            return null;
        }
        ArrayList map = Lists.newArrayList();
        for (BlockPos pos : targets) {
            map.add(new AbstractMap.SimpleEntry<Target, BlockPos>(this.nodeEvaluator.getTarget(pos.getX(), pos.getY(), pos.getZ()), pos));
        }
        Path path = this.findPath(start, map, maxRange, reachRange, maxVisitedNodesMultiplier);
        this.nodeEvaluator.done();
        return path;
    }

    @Nullable
    private Path findPath(Node node, List<Map.Entry<Target, BlockPos>> positions, float maxRange, int reachRange, float maxVisitedNodesMultiplier) {
        ProfilerFiller profilerFiller = Profiler.get();
        profilerFiller.push("find_path");
        profilerFiller.markForCharting(MetricCategory.PATH_FINDING);
        node.g = 0.0f;
        node.f = node.h = this.getBestH(node, positions);
        this.openSet.clear();
        this.openSet.insert(node);
        boolean asBoolean = this.captureDebug.getAsBoolean();
        HashSet<Node> set1 = asBoolean ? new HashSet<Node>() : Set.of();
        int i = 0;
        ArrayList entryList = Lists.newArrayListWithExpectedSize((int)positions.size());
        int i1 = (int)((float)this.maxVisitedNodes * maxVisitedNodesMultiplier);
        while (!this.openSet.isEmpty() && ++i < i1) {
            Node node1 = this.openSet.pop();
            node1.closed = true;
            int size = positions.size();
            for (int positionIndex = 0; positionIndex < size; ++positionIndex) {
                Map.Entry entry = (Map.Entry)positions.get(positionIndex);
                Target target = (Target)entry.getKey();
                if (!(node1.distanceManhattan(target) <= (float)reachRange)) continue;
                target.setReached();
                entryList.add(entry);
            }
            if (!entryList.isEmpty()) break;
            if (asBoolean) {
                set1.add(node1);
            }
            if (node1.distanceTo(node) >= maxRange) continue;
            int neighbors = this.nodeEvaluator.getNeighbors(this.neighbors, node1);
            for (int i2 = 0; i2 < neighbors; ++i2) {
                Node node2 = this.neighbors[i2];
                float f = this.distance(node1, node2);
                node2.walkedDistance = node1.walkedDistance + f;
                float f1 = node1.g + f + node2.costMalus;
                if (!(node2.walkedDistance < maxRange) || node2.inOpenSet() && !(f1 < node2.g)) continue;
                node2.cameFrom = node1;
                node2.g = f1;
                node2.h = this.getBestH(node2, positions) * 1.5f;
                if (node2.inOpenSet()) {
                    this.openSet.changeCost(node2, node2.g + node2.h);
                    continue;
                }
                node2.f = node2.g + node2.h;
                this.openSet.insert(node2);
            }
        }
        Path best = null;
        boolean entryListIsEmpty = entryList.isEmpty();
        Comparator<Path> comparator = entryListIsEmpty ? Comparator.comparingInt(Path::getNodeCount) : Comparator.comparingDouble(Path::getDistToTarget).thenComparingInt(Path::getNodeCount);
        for (Map.Entry entry : entryListIsEmpty ? positions : entryList) {
            Path path = this.reconstructPath(((Target)entry.getKey()).getBestNode(), (BlockPos)entry.getValue(), !entryListIsEmpty);
            if (best != null && comparator.compare(path, best) >= 0) continue;
            best = path;
        }
        profilerFiller.pop();
        if (asBoolean && best != null) {
            HashSet set = Sets.newHashSet();
            for (Map.Entry entry : positions) {
                set.add((Target)entry.getKey());
            }
            best.setDebug(this.openSet.getHeap(), (Node[])set1.toArray(Node[]::new), set);
        }
        return best;
    }

    protected float distance(Node first, Node second) {
        return first.distanceTo(second);
    }

    private float getBestH(Node node, List<Map.Entry<Target, BlockPos>> targets) {
        float f = Float.MAX_VALUE;
        int targetsSize = targets.size();
        for (int i = 0; i < targetsSize; ++i) {
            Target target = targets.get(i).getKey();
            float f1 = node.distanceTo(target);
            target.updateBest(f1, node);
            f = Math.min(f1, f);
        }
        return f;
    }

    private Path reconstructPath(Node node, BlockPos targetPos, boolean reachesTarget) {
        ArrayList list = Lists.newArrayList();
        Node node1 = node;
        list.add(0, node);
        while (node1.cameFrom != null) {
            node1 = node1.cameFrom;
            list.add(0, node1);
        }
        return new Path(list, targetPos, reachesTarget);
    }
}

