/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;

public interface ContainerComponentManipulator<T> {
    public DataComponentType<T> type();

    public T empty();

    public T setContents(T var1, Stream<ItemStack> var2);

    public Stream<ItemStack> getContents(T var1);

    default public void setContents(ItemStack stack, T contents, Stream<ItemStack> items) {
        T orDefault = stack.getOrDefault(this.type(), contents);
        T object = this.setContents(orDefault, items);
        stack.set(this.type(), object);
    }

    default public void setContents(ItemStack stack, Stream<ItemStack> items) {
        this.setContents(stack, this.empty(), items);
    }

    default public void modifyItems(ItemStack stack, UnaryOperator<ItemStack> modifier) {
        T object = stack.get(this.type());
        if (object != null) {
            UnaryOperator unaryOperator = itemStack -> {
                if (itemStack.isEmpty()) {
                    return itemStack;
                }
                ItemStack itemStack1 = (ItemStack)modifier.apply((ItemStack)itemStack);
                itemStack1.limitSize(itemStack1.getMaxStackSize());
                return itemStack1;
            };
            this.setContents(stack, this.getContents(object).map(unaryOperator));
        }
    }
}

