/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.entries;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.world.level.storage.loot.entries.ComposableEntryContainer;
import net.minecraft.world.level.storage.loot.entries.CompositeEntryBase;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntries;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class EntryGroup
extends CompositeEntryBase {
    public static final MapCodec<EntryGroup> CODEC = EntryGroup.createCodec(EntryGroup::new);

    EntryGroup(List<LootPoolEntryContainer> children, List<LootItemCondition> conditions) {
        super(children, conditions);
    }

    @Override
    public LootPoolEntryType getType() {
        return LootPoolEntries.GROUP;
    }

    @Override
    protected ComposableEntryContainer compose(List<? extends ComposableEntryContainer> children) {
        return switch (children.size()) {
            case 0 -> ALWAYS_TRUE;
            case 1 -> children.get(0);
            case 2 -> {
                ComposableEntryContainer composableEntryContainer = children.get(0);
                ComposableEntryContainer composableEntryContainer1 = children.get(1);
                yield (lootContext, entryConsumer) -> {
                    composableEntryContainer.expand(lootContext, entryConsumer);
                    composableEntryContainer1.expand(lootContext, entryConsumer);
                    return true;
                };
            }
            default -> (lootContext, entryConsumer) -> {
                for (ComposableEntryContainer composableEntryContainer2 : children) {
                    composableEntryContainer2.expand(lootContext, entryConsumer);
                }
                return true;
            };
        };
    }

    public static Builder list(LootPoolEntryContainer.Builder<?> ... children) {
        return new Builder(children);
    }

    public static class Builder
    extends LootPoolEntryContainer.Builder<Builder> {
        private final ImmutableList.Builder<LootPoolEntryContainer> entries = ImmutableList.builder();

        public Builder(LootPoolEntryContainer.Builder<?> ... children) {
            for (LootPoolEntryContainer.Builder<?> builder : children) {
                this.entries.add((Object)builder.build());
            }
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        @Override
        public Builder append(LootPoolEntryContainer.Builder<?> childBuilder) {
            this.entries.add((Object)childBuilder.build());
            return this;
        }

        @Override
        public LootPoolEntryContainer build() {
            return new EntryGroup((List<LootPoolEntryContainer>)this.entries.build(), this.getConditions());
        }
    }
}

