/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.entries;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.papermc.paper.configuration.GlobalConfiguration;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntry;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public abstract class LootPoolSingletonContainer
extends LootPoolEntryContainer {
    public static final int DEFAULT_WEIGHT = 1;
    public static final int DEFAULT_QUALITY = 0;
    protected final int weight;
    protected final int quality;
    protected final List<LootItemFunction> functions;
    final BiFunction<ItemStack, LootContext, ItemStack> compositeFunction;
    private final LootPoolEntry entry = new EntryBase(){

        @Override
        public void createItemStack(Consumer<ItemStack> stackConsumer, LootContext lootContext) {
            LootPoolSingletonContainer.this.createItemStack(LootItemFunction.decorate(LootPoolSingletonContainer.this.compositeFunction, stackConsumer, lootContext), lootContext);
        }
    };
    private Float lastLuck;
    private int lastWeight;

    protected LootPoolSingletonContainer(int weight, int quality, List<LootItemCondition> conditions, List<LootItemFunction> functions) {
        super(conditions);
        this.weight = weight;
        this.quality = quality;
        this.functions = functions;
        this.compositeFunction = LootItemFunctions.compose(functions);
    }

    protected static <T extends LootPoolSingletonContainer> Products.P4<RecordCodecBuilder.Mu<T>, Integer, Integer, List<LootItemCondition>, List<LootItemFunction>> singletonFields(RecordCodecBuilder.Instance<T> instance) {
        return instance.group((App)Codec.INT.optionalFieldOf("weight", (Object)1).forGetter(container -> container.weight), (App)Codec.INT.optionalFieldOf("quality", (Object)0).forGetter(lootPoolSingletonContainer -> lootPoolSingletonContainer.quality)).and(LootPoolSingletonContainer.commonFields(instance).t1()).and((App)LootItemFunctions.ROOT_CODEC.listOf().optionalFieldOf("functions", List.of()).forGetter(container -> container.functions));
    }

    @Override
    public void validate(ValidationContext validationContext) {
        super.validate(validationContext);
        for (int i = 0; i < this.functions.size(); ++i) {
            this.functions.get(i).validate(validationContext.forChild(new ProblemReporter.IndexedFieldPathElement("functions", i)));
        }
    }

    protected abstract void createItemStack(Consumer<ItemStack> var1, LootContext var2);

    @Override
    public boolean expand(LootContext lootContext, Consumer<LootPoolEntry> entryConsumer) {
        if (this.canRun(lootContext)) {
            entryConsumer.accept(this.entry);
            return true;
        }
        return false;
    }

    public static Builder<?> simpleBuilder(EntryConstructor entryBuilder) {
        return new DummyBuilder(entryBuilder);
    }

    static class DummyBuilder
    extends Builder<DummyBuilder> {
        private final EntryConstructor constructor;

        public DummyBuilder(EntryConstructor constructor) {
            this.constructor = constructor;
        }

        @Override
        protected DummyBuilder getThis() {
            return this;
        }

        @Override
        public LootPoolEntryContainer build() {
            return this.constructor.build(this.weight, this.quality, this.getConditions(), this.getFunctions());
        }
    }

    @FunctionalInterface
    protected static interface EntryConstructor {
        public LootPoolSingletonContainer build(int var1, int var2, List<LootItemCondition> var3, List<LootItemFunction> var4);
    }

    protected abstract class EntryBase
    implements LootPoolEntry {
        protected EntryBase() {
        }

        @Override
        public int getWeight(float luck) {
            if (LootPoolSingletonContainer.this.lastLuck != null && LootPoolSingletonContainer.this.lastLuck.floatValue() == luck) {
                return LootPoolSingletonContainer.this.lastWeight;
            }
            float qualityModifer = (float)LootPoolSingletonContainer.this.quality * luck;
            double baseWeight = (float)LootPoolSingletonContainer.this.weight + qualityModifer;
            if (GlobalConfiguration.get().misc.useAlternativeLuckFormula) {
                int weightBoost = 100;
                double impacted = (baseWeight *= 100.0) * ((baseWeight - 100.0) / 100.0 / 100.0);
                float luckModifier = Math.min(100.0f, luck * 10.0f) / 100.0f;
                baseWeight = Math.ceil(baseWeight - impacted * (double)luckModifier);
            }
            LootPoolSingletonContainer.this.lastLuck = Float.valueOf(luck);
            LootPoolSingletonContainer.this.lastWeight = (int)Math.max(Math.floor(baseWeight), 0.0);
            return LootPoolSingletonContainer.this.lastWeight;
        }
    }

    public static abstract class Builder<T extends Builder<T>>
    extends LootPoolEntryContainer.Builder<T>
    implements FunctionUserBuilder<T> {
        protected int weight = 1;
        protected int quality = 0;
        private final ImmutableList.Builder<LootItemFunction> functions = ImmutableList.builder();

        @Override
        public T apply(LootItemFunction.Builder functionBuilder) {
            this.functions.add((Object)functionBuilder.build());
            return (T)((Builder)this.getThis());
        }

        protected List<LootItemFunction> getFunctions() {
            return this.functions.build();
        }

        public T setWeight(int weight) {
            this.weight = weight;
            return (T)((Builder)this.getThis());
        }

        public T setQuality(int quality) {
            this.quality = quality;
            return (T)((Builder)this.getThis());
        }
    }
}

